/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Readable;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Writable;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Field;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Schema;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Type;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.ByteUtils;

public class EnvelopeResponseData
implements ApiMessage {
    ByteBuffer responseData;
    short errorCode;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("response_data", Type.COMPACT_NULLABLE_BYTES, "The embedded response header and data."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public EnvelopeResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public EnvelopeResponseData() {
        this.responseData = null;
        this.errorCode = 0;
    }

    @Override
    public short apiKey() {
        return 58;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        int length = _readable.readUnsignedVarint() - 1;
        this.responseData = length < 0 ? null : _readable.readByteBuffer(length);
        this.errorCode = _readable.readShort();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (this.responseData == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.responseData.remaining() + 1);
            _writable.writeByteBuffer(this.responseData);
        }
        _writable.writeShort(this.errorCode);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (this.responseData == null) {
            _size.addBytes(1);
        } else {
            _size.addZeroCopyBytes(this.responseData.remaining());
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.responseData.remaining() + 1));
        }
        _size.addBytes(2);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EnvelopeResponseData)) {
            return false;
        }
        EnvelopeResponseData other = (EnvelopeResponseData)obj;
        if (!Objects.equals(this.responseData, other.responseData)) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + Objects.hashCode(this.responseData);
        hashCode = 31 * hashCode + this.errorCode;
        return hashCode;
    }

    @Override
    public EnvelopeResponseData duplicate() {
        EnvelopeResponseData _duplicate = new EnvelopeResponseData();
        _duplicate.responseData = this.responseData == null ? null : this.responseData.duplicate();
        _duplicate.errorCode = this.errorCode;
        return _duplicate;
    }

    public String toString() {
        return "EnvelopeResponseData(responseData=" + this.responseData + ", errorCode=" + this.errorCode + ")";
    }

    public ByteBuffer responseData() {
        return this.responseData;
    }

    public short errorCode() {
        return this.errorCode;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public EnvelopeResponseData setResponseData(ByteBuffer v) {
        this.responseData = v;
        return this;
    }

    public EnvelopeResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }
}

