/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.DescribeDelegationTokenResponseData;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Errors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.security.token.delegation.TokenInformation;

public class DescribeDelegationTokenResponse
extends AbstractResponse {
    private final DescribeDelegationTokenResponseData data;

    public DescribeDelegationTokenResponse(int version, int throttleTimeMs, Errors error, List<DelegationToken> tokens) {
        super(ApiKeys.DESCRIBE_DELEGATION_TOKEN);
        List<DescribeDelegationTokenResponseData.DescribedDelegationToken> describedDelegationTokenList = tokens.stream().map(dt -> {
            DescribeDelegationTokenResponseData.DescribedDelegationToken ddt = new DescribeDelegationTokenResponseData.DescribedDelegationToken().setTokenId(dt.tokenInfo().tokenId()).setPrincipalType(dt.tokenInfo().owner().getPrincipalType()).setPrincipalName(dt.tokenInfo().owner().getName()).setIssueTimestamp(dt.tokenInfo().issueTimestamp()).setMaxTimestamp(dt.tokenInfo().maxTimestamp()).setExpiryTimestamp(dt.tokenInfo().expiryTimestamp()).setHmac(dt.hmac()).setRenewers(dt.tokenInfo().renewers().stream().map(r -> new DescribeDelegationTokenResponseData.DescribedDelegationTokenRenewer().setPrincipalName(r.getName()).setPrincipalType(r.getPrincipalType())).collect(Collectors.toList()));
            if (version > 2) {
                ddt.setTokenRequesterPrincipalType(dt.tokenInfo().tokenRequester().getPrincipalType()).setTokenRequesterPrincipalName(dt.tokenInfo().tokenRequester().getName());
            }
            return ddt;
        }).collect(Collectors.toList());
        this.data = new DescribeDelegationTokenResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()).setTokens(describedDelegationTokenList);
    }

    public DescribeDelegationTokenResponse(int version, int throttleTimeMs, Errors error) {
        this(version, throttleTimeMs, error, new ArrayList<DelegationToken>());
    }

    public DescribeDelegationTokenResponse(DescribeDelegationTokenResponseData data) {
        super(ApiKeys.DESCRIBE_DELEGATION_TOKEN);
        this.data = data;
    }

    public static DescribeDelegationTokenResponse parse(ByteBuffer buffer, short version) {
        return new DescribeDelegationTokenResponse(new DescribeDelegationTokenResponseData(new ByteBufferAccessor(buffer), version));
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error());
    }

    @Override
    public DescribeDelegationTokenResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    public List<DelegationToken> tokens() {
        return this.data.tokens().stream().map(ddt -> new DelegationToken(new TokenInformation(ddt.tokenId(), new KafkaPrincipal(ddt.principalType(), ddt.principalName()), new KafkaPrincipal(ddt.tokenRequesterPrincipalType(), ddt.tokenRequesterPrincipalName()), ddt.renewers().stream().map(ddtr -> new KafkaPrincipal(ddtr.principalType(), ddtr.principalName())).collect(Collectors.toList()), ddt.issueTimestamp(), ddt.maxTimestamp(), ddt.expiryTimestamp()), ddt.hmac())).collect(Collectors.toList());
    }

    public boolean hasError() {
        return this.error() != Errors.NONE;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }
}

