/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.serialization;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.SerializationException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.header.Headers;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.serialization.Deserializer;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.Utils;

public class StringDeserializer
implements Deserializer<String> {
    private Charset encoding = StandardCharsets.UTF_8;

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        String propertyName = isKey ? "key.deserializer.encoding" : "value.deserializer.encoding";
        Object encodingValue = configs.get(propertyName);
        if (encodingValue == null) {
            encodingValue = configs.get("deserializer.encoding");
        }
        if (encodingValue instanceof String) {
            String encodingName = (String)encodingValue;
            try {
                this.encoding = Charset.forName(encodingName);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                throw new SerializationException("Unsupported encoding " + encodingName, e);
            }
        }
    }

    @Override
    public String deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        return new String(data, this.encoding);
    }

    @Override
    public String deserialize(String topic, Headers headers, ByteBuffer data) {
        if (data == null) {
            return null;
        }
        if (data.hasArray()) {
            return new String(data.array(), data.position() + data.arrayOffset(), data.remaining(), this.encoding);
        }
        return new String(Utils.toArray(data), this.encoding);
    }
}

