/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.peaberry.osgi;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import org.ops4j.peaberry.Import;
import org.ops4j.peaberry.osgi.AttributeDictionary;
import org.ops4j.peaberry.util.SimpleExport;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OSGiServiceExport<T>
extends SimpleExport<T> {
    private final BundleContext bundleContext;
    private ServiceRegistration reg;

    OSGiServiceExport(BundleContext bundleContext, Import<T> service) {
        super(service);
        this.bundleContext = bundleContext;
        this.exportOSGiService();
    }

    @Override
    public synchronized void put(T newInstance) {
        this.removeOSGiService();
        super.put(newInstance);
        this.exportOSGiService();
    }

    @Override
    public synchronized void attributes(Map<String, ?> newAttributes) {
        super.attributes(newAttributes);
        if (null != this.reg) {
            this.reg.setProperties(OSGiServiceExport.getProperties(newAttributes));
        }
    }

    private void exportOSGiService() {
        Object instance = this.get();
        if (null != instance) {
            Dictionary<String, ?> properties = OSGiServiceExport.getProperties(this.attributes());
            String[] interfaceNames = OSGiServiceExport.getInterfaceNames(instance, properties);
            this.reg = this.bundleContext.registerService(interfaceNames, instance, properties);
        }
    }

    private void removeOSGiService() {
        if (null != this.reg) {
            try {
                this.reg.unregister();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.reg = null;
        }
    }

    private static Dictionary<String, ?> getProperties(Map<String, ?> attributes) {
        return null == attributes || attributes.isEmpty() ? null : new AttributeDictionary(attributes);
    }

    private static String[] getInterfaceNames(Object instance, Dictionary<?, ?> properties) {
        Object objectClass;
        Object v0 = objectClass = null == properties ? null : properties.get("objectClass");
        if (objectClass instanceof String[]) {
            return objectClass;
        }
        HashSet<String> names = new HashSet<String>();
        for (Class<?> clazz = instance.getClass(); null != clazz; clazz = clazz.getSuperclass()) {
            for (Class<?> i : clazz.getInterfaces()) {
                names.add(i.getName());
            }
        }
        return names.toArray(new String[names.size()]);
    }
}

