/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.markup;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;
import com.day.cq.dam.commons.util.PrefixRenditionPicker;
import com.day.cq.dam.video.VideoProfile;
import com.google.common.collect.ImmutableList;
import io.wcm.handler.commons.dom.HtmlElement;
import io.wcm.handler.commons.dom.Video;
import io.wcm.handler.media.Dimension;
import io.wcm.handler.media.Media;
import io.wcm.handler.media.markup.MediaMarkupBuilderUtil;
import io.wcm.handler.media.spi.MediaMarkupBuilder;
import io.wcm.handler.url.UrlHandler;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ConsumerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class})
@ConsumerType
public class DamVideoMediaMarkupBuilder
implements MediaMarkupBuilder {
    private static final String H264_PROFILE = "format_aac";
    private static final String OGG_PROFILE = "format_ogg";
    private static final String LEGACY_H264_PROFILE = "hq";
    private static final String LEGACY_OGG_PROFILE = "firefoxhq";
    private static final List<String> VIDEO_PROFILE_NAMES = ImmutableList.of((Object)"format_aac", (Object)"format_ogg", (Object)"hq", (Object)"firefoxhq");
    private static final Logger log = LoggerFactory.getLogger(DamVideoMediaMarkupBuilder.class);
    @SlingObject
    private ResourceResolver resourceResolver;
    @Self
    private UrlHandler urlHandler;
    @OSGiService
    private ConfigurationResourceResolver configurationResourceResolver;

    @Override
    public final boolean accepts(@NotNull Media media) {
        if (!media.isValid()) {
            return false;
        }
        Asset asset = this.getDamAsset(media);
        if (asset != null) {
            return asset.getRendition((RenditionPicker)new PrefixRenditionPicker("cq5dam.video.")) != null;
        }
        return false;
    }

    protected List<String> getVideoProfileNames() {
        return VIDEO_PROFILE_NAMES;
    }

    protected List<VideoProfile> getVideoProfiles() {
        ArrayList<VideoProfile> profiles = new ArrayList<VideoProfile>();
        for (String profileName : this.getVideoProfileNames()) {
            VideoProfile profile = this.getVideoProfile(profileName);
            if (profile != null) {
                profiles.add(profile);
                continue;
            }
            log.debug("DAM video profile with name '{}' does not exist.", (Object)profileName);
        }
        return profiles;
    }

    private VideoProfile getVideoProfile(String profileName) {
        return VideoProfile.get((ResourceResolver)this.resourceResolver, (ConfigurationResourceResolver)this.configurationResourceResolver, (String)profileName);
    }

    protected Asset getDamAsset(Media media) {
        return (Asset)media.getAsset().adaptTo(Asset.class);
    }

    @Override
    public final HtmlElement<?> build(@NotNull Media media) {
        return this.getVideoPlayerElement(media);
    }

    protected Video getVideoPlayerElement(@NotNull Media media) {
        Dimension dimension = MediaMarkupBuilderUtil.getMediaformatDimension(media);
        Video video = new Video();
        video.setWidth((long)((int)dimension.getWidth()));
        video.setHeight((long)((int)dimension.getHeight()));
        video.setControls(true);
        this.addSources(video, media);
        return video;
    }

    protected void addSources(Video video, Media media) {
        Asset asset = this.getDamAsset(media);
        if (asset == null) {
            return;
        }
        for (VideoProfile profile : this.getVideoProfiles()) {
            Rendition rendition = profile.getRendition(asset);
            if (rendition == null) continue;
            video.createSource().setType(profile.getHtmlType()).setSrc(this.urlHandler.get(rendition.getPath()).buildExternalResourceUrl((Resource)rendition.adaptTo(Resource.class)));
        }
    }

    @Deprecated
    protected HtmlElement getFlashPlayerElement(Media media, Dimension dimension) {
        Asset asset = this.getDamAsset(media);
        if (asset == null) {
            return null;
        }
        Rendition rendition = asset.getRendition((RenditionPicker)new PrefixRenditionPicker("cq5dam.video.format_aac"));
        if (rendition == null && (rendition = asset.getRendition((RenditionPicker)new PrefixRenditionPicker("cq5dam.video.hq"))) == null) {
            return null;
        }
        String playerUrl = this.urlHandler.get("/etc/clientlibs/foundation/video/swf/StrobeMediaPlayback.swf").buildExternalResourceUrl();
        String renditionUrl = "../../../../.." + rendition.getPath();
        renditionUrl = StringUtils.replace((String)renditionUrl, (String)"jcr:content", (String)"_jcr_content");
        HtmlElement object = new HtmlElement("object");
        object.setAttribute("type", "application/x-shockwave-flash");
        object.setAttribute("data", playerUrl);
        object.setAttribute("width", Long.toString(dimension.getWidth()));
        object.setAttribute("height", Long.toString(dimension.getHeight()));
        HashMap<String, String> flashvars = new HashMap<String, String>();
        flashvars.put("src", renditionUrl);
        flashvars.putAll(this.getAdditionalFlashPlayerFlashVars(media, dimension));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("movie", playerUrl);
        parameters.put("flashvars", this.buildFlashVarsString(flashvars));
        parameters.putAll(this.getAdditionalFlashPlayerParameters(media, dimension));
        for (Map.Entry entry : parameters.entrySet()) {
            HtmlElement param = object.create("param");
            param.setAttribute("name", (String)entry.getKey());
            param.setAttribute("value", (String)entry.getValue());
        }
        return object;
    }

    @Deprecated
    protected String buildFlashVarsString(Map<String, String> flashVars) {
        try {
            StringBuilder flashvarsString = new StringBuilder();
            Iterator<Map.Entry<String, String>> flashvarsIterator = flashVars.entrySet().iterator();
            while (flashvarsIterator.hasNext()) {
                Map.Entry<String, String> entry = flashvarsIterator.next();
                flashvarsString.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8.name()));
                flashvarsString.append('=');
                flashvarsString.append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.name()));
                if (!flashvarsIterator.hasNext()) continue;
                flashvarsString.append('&');
            }
            return flashvarsString.toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Unsupported encoding.", ex);
        }
    }

    protected Map<String, String> getAdditionalFlashPlayerParameters(Media media, Dimension dimension) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("allowFullScreen", "true");
        parameters.put("wmode", "opaque");
        return parameters;
    }

    protected Map<String, String> getAdditionalFlashPlayerFlashVars(Media media, Dimension dimension) {
        HashMap<String, String> flashvars = new HashMap<String, String>();
        flashvars.put("autoPlay", "false");
        flashvars.put("loop", "false");
        return flashvars;
    }

    @Override
    public final boolean isValidMedia(@NotNull HtmlElement<?> element) {
        return element instanceof Video;
    }
}

