/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.streaming.util.RateLimitedOutputStream;
import org.apache.spark.util.IntParam$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class RawTextSender$
implements Logging {
    public static final RawTextSender$ MODULE$ = new RawTextSender$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void main(String[] args) {
        Option option;
        int blockSize;
        int port;
        String file;
        block13: {
            String[] stringArray;
            block12: {
                Option option2;
                Option option3;
                Object object;
                if (args.length != 4) {
                    System.err.println("Usage: RawTextSender <port> <file> <blockSize> <bytesPerSec>");
                    System.exit(1);
                }
                if ((stringArray = args) == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 4) != 0) break block12;
                String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                file = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2);
                String string3 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3);
                if (string == null || (option3 = IntParam$.MODULE$.unapply(string)).isEmpty()) break block12;
                port = BoxesRunTime.unboxToInt((Object)option3.get());
                if (string2 == null || (option2 = IntParam$.MODULE$.unapply(string2)).isEmpty()) break block12;
                blockSize = BoxesRunTime.unboxToInt((Object)option2.get());
                if (string3 != null && !(option = IntParam$.MODULE$.unapply(string3)).isEmpty()) break block13;
            }
            throw new MatchError((Object)stringArray);
        }
        int bytesPerSec = BoxesRunTime.unboxToInt((Object)option.get());
        Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)port), (Object)file, (Object)BoxesRunTime.boxToInteger((int)blockSize), (Object)BoxesRunTime.boxToInteger((int)bytesPerSec));
        int port2 = BoxesRunTime.unboxToInt((Object)tuple4._1());
        String file2 = (String)tuple4._2();
        int blockSize2 = BoxesRunTime.unboxToInt((Object)tuple4._3());
        int bytesPerSec2 = BoxesRunTime.unboxToInt((Object)tuple4._4());
        String[] lines = (String[])Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> Source$.MODULE$.fromFile(file2, Codec$.MODULE$.fallbackSystemCodec()), (Function1 & Serializable)x$2 -> (String[])x$2.getLines().toArray(ClassTag$.MODULE$.apply(String.class)));
        ByteArrayOutputStream bufferStream = new ByteArrayOutputStream(blockSize2 + 1000);
        SerializerInstance ser = new KryoSerializer(new SparkConf()).newInstance();
        SerializationStream serStream = ser.serializeStream((OutputStream)bufferStream);
        int i = 0;
        while (bufferStream.size() < blockSize2) {
            serStream.writeObject((Object)lines[i], ClassTag$.MODULE$.apply(String.class));
            i = (i + 1) % lines.length;
        }
        byte[] array = bufferStream.toByteArray();
        ByteBuffer countBuf = ByteBuffer.wrap(new byte[4]);
        countBuf.putInt(array.length);
        countBuf.flip();
        ServerSocket serverSocket = new ServerSocket(port2);
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Listening on port ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.PORT, BoxesRunTime.boxToInteger((int)port2))}))));
        while (true) {
            Socket socket = serverSocket.accept();
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Got a new connection");
            RateLimitedOutputStream out = new RateLimitedOutputStream(socket.getOutputStream(), bytesPerSec2);
            try {
                try {
                    while (true) {
                        out.write(countBuf.array());
                        out.write(array);
                    }
                }
                catch (IOException e) {
                    this.logError((Function0<String>)(Function0 & Serializable)() -> "Client disconnected");
                    continue;
                }
            }
            finally {
                socket.close();
                continue;
            }
            break;
        }
    }

    private RawTextSender$() {
    }
}

