/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

public final class KMeansDataGenerator$ {
    public static final KMeansDataGenerator$ MODULE$ = new KMeansDataGenerator$();

    public RDD<double[]> generateKMeansRDD(SparkContext sc, int numPoints, int k, int d, double r, int numPartitions) {
        Random rand = new Random(42);
        double[][] centers = (double[][])Array$.MODULE$.fill(k, (Function0 & Serializable)() -> (double[])Array$.MODULE$.fill(d, (Function0)(JFunction0.mcD.sp & Serializable)() -> rand.nextGaussian() * r, (ClassTag)ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        return sc.parallelize((Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPoints), numPartitions, (ClassTag)ClassTag$.MODULE$.Int()).map((Function1 & Serializable)idx -> KMeansDataGenerator$.$anonfun$generateKMeansRDD$3(centers, k, d, BoxesRunTime.unboxToInt((Object)idx)), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
    }

    public int generateKMeansRDD$default$6() {
        return 2;
    }

    public void main(String[] args) {
        if (args.length < 6) {
            Predef$.MODULE$.println((Object)"Usage: KMeansGenerator <master> <output_dir> <num_points> <k> <d> <r> [<num_partitions>]");
            System.exit(1);
        }
        String sparkMaster = args[0];
        String outputPath = args[1];
        int numPoints = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[2]));
        int k = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[3]));
        int d = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[4]));
        double r = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(args[5]));
        int parts = args.length >= 7 ? StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[6])) : 2;
        SparkContext sc = new SparkContext(sparkMaster, "KMeansDataGenerator");
        RDD<double[]> data = this.generateKMeansRDD(sc, numPoints, k, d, r, parts);
        data.map((Function1 & Serializable)x$1 -> Predef$.MODULE$.wrapDoubleArray(x$1).mkString(" "), ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(outputPath);
        sc.stop();
        System.exit(0);
    }

    public static final /* synthetic */ double[] $anonfun$generateKMeansRDD$3(double[][] centers$1, int k$1, int d$1, int idx) {
        double[] center = centers$1[idx % k$1];
        Random rand2 = new Random(42 + idx);
        return (double[])Array$.MODULE$.tabulate(d$1, (Function1)(JFunction1.mcDI.sp & Serializable)i -> center[i] + rand2.nextGaussian(), (ClassTag)ClassTag$.MODULE$.Double());
    }

    private KMeansDataGenerator$() {
    }
}

