#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import pyspark.sql.connect.proto.common_pb2
import pyspark.sql.connect.proto.relations_pb2
import pyspark.sql.connect.proto.types_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _OutputType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _OutputTypeEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_OutputType.ValueType],
    builtins.type,
):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    OUTPUT_TYPE_UNSPECIFIED: _OutputType.ValueType  # 0
    """Safe default value. Should not be used."""
    MATERIALIZED_VIEW: _OutputType.ValueType  # 1
    """A materialized view which is published to the catalog"""
    TABLE: _OutputType.ValueType  # 2
    """A table which is published to the catalog"""
    TEMPORARY_VIEW: _OutputType.ValueType  # 3
    """A view which is not published to the catalog"""
    SINK: _OutputType.ValueType  # 4
    """A sink which is not published to the catalog"""

class OutputType(_OutputType, metaclass=_OutputTypeEnumTypeWrapper):
    """The type of output."""

OUTPUT_TYPE_UNSPECIFIED: OutputType.ValueType  # 0
"""Safe default value. Should not be used."""
MATERIALIZED_VIEW: OutputType.ValueType  # 1
"""A materialized view which is published to the catalog"""
TABLE: OutputType.ValueType  # 2
"""A table which is published to the catalog"""
TEMPORARY_VIEW: OutputType.ValueType  # 3
"""A view which is not published to the catalog"""
SINK: OutputType.ValueType  # 4
"""A sink which is not published to the catalog"""
global___OutputType = OutputType

class PipelineCommand(google.protobuf.message.Message):
    """Dispatch object for pipelines commands. See each individual command for documentation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class CreateDataflowGraph(google.protobuf.message.Message):
        """Request to create a new dataflow graph."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class SqlConfEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            value: builtins.str
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: builtins.str = ...,
            ) -> None: ...
            def ClearField(
                self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]
            ) -> None: ...

        DEFAULT_CATALOG_FIELD_NUMBER: builtins.int
        DEFAULT_DATABASE_FIELD_NUMBER: builtins.int
        SQL_CONF_FIELD_NUMBER: builtins.int
        default_catalog: builtins.str
        """The default catalog."""
        default_database: builtins.str
        """The default database."""
        @property
        def sql_conf(
            self,
        ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
            """SQL configurations for all flows in this graph."""
        def __init__(
            self,
            *,
            default_catalog: builtins.str | None = ...,
            default_database: builtins.str | None = ...,
            sql_conf: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        ) -> None: ...
        def HasField(
            self,
            field_name: typing_extensions.Literal[
                "_default_catalog",
                b"_default_catalog",
                "_default_database",
                b"_default_database",
                "default_catalog",
                b"default_catalog",
                "default_database",
                b"default_database",
            ],
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "_default_catalog",
                b"_default_catalog",
                "_default_database",
                b"_default_database",
                "default_catalog",
                b"default_catalog",
                "default_database",
                b"default_database",
                "sql_conf",
                b"sql_conf",
            ],
        ) -> None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_default_catalog", b"_default_catalog"]
        ) -> typing_extensions.Literal["default_catalog"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_default_database", b"_default_database"]
        ) -> typing_extensions.Literal["default_database"] | None: ...

    class DropDataflowGraph(google.protobuf.message.Message):
        """Drops the graph and stops any running attached flows."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DATAFLOW_GRAPH_ID_FIELD_NUMBER: builtins.int
        dataflow_graph_id: builtins.str
        """The graph to drop."""
        def __init__(
            self,
            *,
            dataflow_graph_id: builtins.str | None = ...,
        ) -> None: ...
        def HasField(
            self,
            field_name: typing_extensions.Literal[
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "dataflow_graph_id",
                b"dataflow_graph_id",
            ],
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "dataflow_graph_id",
                b"dataflow_graph_id",
            ],
        ) -> None: ...
        def WhichOneof(
            self,
            oneof_group: typing_extensions.Literal["_dataflow_graph_id", b"_dataflow_graph_id"],
        ) -> typing_extensions.Literal["dataflow_graph_id"] | None: ...

    class DefineOutput(google.protobuf.message.Message):
        """Request to define an output: a table, a materialized view, a temporary view or a sink."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class TableDetails(google.protobuf.message.Message):
            """Metadata that's only applicable to tables and materialized views."""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            class TablePropertiesEntry(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                KEY_FIELD_NUMBER: builtins.int
                VALUE_FIELD_NUMBER: builtins.int
                key: builtins.str
                value: builtins.str
                def __init__(
                    self,
                    *,
                    key: builtins.str = ...,
                    value: builtins.str = ...,
                ) -> None: ...
                def ClearField(
                    self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]
                ) -> None: ...

            TABLE_PROPERTIES_FIELD_NUMBER: builtins.int
            PARTITION_COLS_FIELD_NUMBER: builtins.int
            FORMAT_FIELD_NUMBER: builtins.int
            SCHEMA_DATA_TYPE_FIELD_NUMBER: builtins.int
            SCHEMA_STRING_FIELD_NUMBER: builtins.int
            CLUSTERING_COLUMNS_FIELD_NUMBER: builtins.int
            @property
            def table_properties(
                self,
            ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
                """Optional table properties."""
            @property
            def partition_cols(
                self,
            ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
                """Optional partition columns for the table."""
            format: builtins.str
            """The output table format for the table."""
            @property
            def schema_data_type(self) -> pyspark.sql.connect.proto.types_pb2.DataType: ...
            schema_string: builtins.str
            @property
            def clustering_columns(
                self,
            ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
                """Optional cluster columns for the table."""
            def __init__(
                self,
                *,
                table_properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
                partition_cols: collections.abc.Iterable[builtins.str] | None = ...,
                format: builtins.str | None = ...,
                schema_data_type: pyspark.sql.connect.proto.types_pb2.DataType | None = ...,
                schema_string: builtins.str = ...,
                clustering_columns: collections.abc.Iterable[builtins.str] | None = ...,
            ) -> None: ...
            def HasField(
                self,
                field_name: typing_extensions.Literal[
                    "_format",
                    b"_format",
                    "format",
                    b"format",
                    "schema",
                    b"schema",
                    "schema_data_type",
                    b"schema_data_type",
                    "schema_string",
                    b"schema_string",
                ],
            ) -> builtins.bool: ...
            def ClearField(
                self,
                field_name: typing_extensions.Literal[
                    "_format",
                    b"_format",
                    "clustering_columns",
                    b"clustering_columns",
                    "format",
                    b"format",
                    "partition_cols",
                    b"partition_cols",
                    "schema",
                    b"schema",
                    "schema_data_type",
                    b"schema_data_type",
                    "schema_string",
                    b"schema_string",
                    "table_properties",
                    b"table_properties",
                ],
            ) -> None: ...
            @typing.overload
            def WhichOneof(
                self, oneof_group: typing_extensions.Literal["_format", b"_format"]
            ) -> typing_extensions.Literal["format"] | None: ...
            @typing.overload
            def WhichOneof(
                self, oneof_group: typing_extensions.Literal["schema", b"schema"]
            ) -> typing_extensions.Literal["schema_data_type", "schema_string"] | None: ...

        class SinkDetails(google.protobuf.message.Message):
            """Metadata that's only applicable to sinks."""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            class OptionsEntry(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                KEY_FIELD_NUMBER: builtins.int
                VALUE_FIELD_NUMBER: builtins.int
                key: builtins.str
                value: builtins.str
                def __init__(
                    self,
                    *,
                    key: builtins.str = ...,
                    value: builtins.str = ...,
                ) -> None: ...
                def ClearField(
                    self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]
                ) -> None: ...

            OPTIONS_FIELD_NUMBER: builtins.int
            FORMAT_FIELD_NUMBER: builtins.int
            @property
            def options(
                self,
            ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
                """Streaming write options"""
            format: builtins.str
            """Streaming write format"""
            def __init__(
                self,
                *,
                options: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
                format: builtins.str | None = ...,
            ) -> None: ...
            def HasField(
                self,
                field_name: typing_extensions.Literal["_format", b"_format", "format", b"format"],
            ) -> builtins.bool: ...
            def ClearField(
                self,
                field_name: typing_extensions.Literal[
                    "_format", b"_format", "format", b"format", "options", b"options"
                ],
            ) -> None: ...
            def WhichOneof(
                self, oneof_group: typing_extensions.Literal["_format", b"_format"]
            ) -> typing_extensions.Literal["format"] | None: ...

        DATAFLOW_GRAPH_ID_FIELD_NUMBER: builtins.int
        OUTPUT_NAME_FIELD_NUMBER: builtins.int
        OUTPUT_TYPE_FIELD_NUMBER: builtins.int
        COMMENT_FIELD_NUMBER: builtins.int
        SOURCE_CODE_LOCATION_FIELD_NUMBER: builtins.int
        TABLE_DETAILS_FIELD_NUMBER: builtins.int
        SINK_DETAILS_FIELD_NUMBER: builtins.int
        EXTENSION_FIELD_NUMBER: builtins.int
        dataflow_graph_id: builtins.str
        """The graph to attach this output to."""
        output_name: builtins.str
        """Name of the output. Can be partially or fully qualified."""
        output_type: global___OutputType.ValueType
        """The type of the output."""
        comment: builtins.str
        """Optional comment for the output."""
        @property
        def source_code_location(self) -> global___SourceCodeLocation:
            """The location in source code that this output was defined."""
        @property
        def table_details(self) -> global___PipelineCommand.DefineOutput.TableDetails: ...
        @property
        def sink_details(self) -> global___PipelineCommand.DefineOutput.SinkDetails: ...
        @property
        def extension(self) -> google.protobuf.any_pb2.Any: ...
        def __init__(
            self,
            *,
            dataflow_graph_id: builtins.str | None = ...,
            output_name: builtins.str | None = ...,
            output_type: global___OutputType.ValueType | None = ...,
            comment: builtins.str | None = ...,
            source_code_location: global___SourceCodeLocation | None = ...,
            table_details: global___PipelineCommand.DefineOutput.TableDetails | None = ...,
            sink_details: global___PipelineCommand.DefineOutput.SinkDetails | None = ...,
            extension: google.protobuf.any_pb2.Any | None = ...,
        ) -> None: ...
        def HasField(
            self,
            field_name: typing_extensions.Literal[
                "_comment",
                b"_comment",
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "_output_name",
                b"_output_name",
                "_output_type",
                b"_output_type",
                "_source_code_location",
                b"_source_code_location",
                "comment",
                b"comment",
                "dataflow_graph_id",
                b"dataflow_graph_id",
                "details",
                b"details",
                "extension",
                b"extension",
                "output_name",
                b"output_name",
                "output_type",
                b"output_type",
                "sink_details",
                b"sink_details",
                "source_code_location",
                b"source_code_location",
                "table_details",
                b"table_details",
            ],
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "_comment",
                b"_comment",
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "_output_name",
                b"_output_name",
                "_output_type",
                b"_output_type",
                "_source_code_location",
                b"_source_code_location",
                "comment",
                b"comment",
                "dataflow_graph_id",
                b"dataflow_graph_id",
                "details",
                b"details",
                "extension",
                b"extension",
                "output_name",
                b"output_name",
                "output_type",
                b"output_type",
                "sink_details",
                b"sink_details",
                "source_code_location",
                b"source_code_location",
                "table_details",
                b"table_details",
            ],
        ) -> None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_comment", b"_comment"]
        ) -> typing_extensions.Literal["comment"] | None: ...
        @typing.overload
        def WhichOneof(
            self,
            oneof_group: typing_extensions.Literal["_dataflow_graph_id", b"_dataflow_graph_id"],
        ) -> typing_extensions.Literal["dataflow_graph_id"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_output_name", b"_output_name"]
        ) -> typing_extensions.Literal["output_name"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_output_type", b"_output_type"]
        ) -> typing_extensions.Literal["output_type"] | None: ...
        @typing.overload
        def WhichOneof(
            self,
            oneof_group: typing_extensions.Literal[
                "_source_code_location", b"_source_code_location"
            ],
        ) -> typing_extensions.Literal["source_code_location"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["details", b"details"]
        ) -> typing_extensions.Literal["table_details", "sink_details", "extension"] | None: ...

    class DefineFlow(google.protobuf.message.Message):
        """Request to define a flow targeting a dataset."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class SqlConfEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            value: builtins.str
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: builtins.str = ...,
            ) -> None: ...
            def ClearField(
                self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]
            ) -> None: ...

        class WriteRelationFlowDetails(google.protobuf.message.Message):
            """A flow that is that takes the contents of a relation and writes it to the target dataset."""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            RELATION_FIELD_NUMBER: builtins.int
            @property
            def relation(self) -> pyspark.sql.connect.proto.relations_pb2.Relation:
                """An unresolved relation that defines the dataset's flow. Empty if the query function
                that defines the flow cannot be analyzed at the time of flow definition.
                """
            def __init__(
                self,
                *,
                relation: pyspark.sql.connect.proto.relations_pb2.Relation | None = ...,
            ) -> None: ...
            def HasField(
                self,
                field_name: typing_extensions.Literal[
                    "_relation", b"_relation", "relation", b"relation"
                ],
            ) -> builtins.bool: ...
            def ClearField(
                self,
                field_name: typing_extensions.Literal[
                    "_relation", b"_relation", "relation", b"relation"
                ],
            ) -> None: ...
            def WhichOneof(
                self, oneof_group: typing_extensions.Literal["_relation", b"_relation"]
            ) -> typing_extensions.Literal["relation"] | None: ...

        class Response(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            FLOW_NAME_FIELD_NUMBER: builtins.int
            flow_name: builtins.str
            """Fully qualified flow name that uniquely identify a flow in the Dataflow graph."""
            def __init__(
                self,
                *,
                flow_name: builtins.str | None = ...,
            ) -> None: ...
            def HasField(
                self,
                field_name: typing_extensions.Literal[
                    "_flow_name", b"_flow_name", "flow_name", b"flow_name"
                ],
            ) -> builtins.bool: ...
            def ClearField(
                self,
                field_name: typing_extensions.Literal[
                    "_flow_name", b"_flow_name", "flow_name", b"flow_name"
                ],
            ) -> None: ...
            def WhichOneof(
                self, oneof_group: typing_extensions.Literal["_flow_name", b"_flow_name"]
            ) -> typing_extensions.Literal["flow_name"] | None: ...

        DATAFLOW_GRAPH_ID_FIELD_NUMBER: builtins.int
        FLOW_NAME_FIELD_NUMBER: builtins.int
        TARGET_DATASET_NAME_FIELD_NUMBER: builtins.int
        SQL_CONF_FIELD_NUMBER: builtins.int
        CLIENT_ID_FIELD_NUMBER: builtins.int
        SOURCE_CODE_LOCATION_FIELD_NUMBER: builtins.int
        RELATION_FLOW_DETAILS_FIELD_NUMBER: builtins.int
        EXTENSION_FIELD_NUMBER: builtins.int
        ONCE_FIELD_NUMBER: builtins.int
        dataflow_graph_id: builtins.str
        """The graph to attach this flow to."""
        flow_name: builtins.str
        """Name of the flow. For standalone flows, this must be a single-part name."""
        target_dataset_name: builtins.str
        """Name of the dataset this flow writes to. Can be partially or fully qualified."""
        @property
        def sql_conf(
            self,
        ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
            """SQL configurations set when running this flow."""
        client_id: builtins.str
        """Identifier for the client making the request. The server uses this to determine what flow
        evaluation request stream to dispatch evaluation requests to for this flow.
        """
        @property
        def source_code_location(self) -> global___SourceCodeLocation:
            """The location in source code that this flow was defined."""
        @property
        def relation_flow_details(
            self,
        ) -> global___PipelineCommand.DefineFlow.WriteRelationFlowDetails: ...
        @property
        def extension(self) -> google.protobuf.any_pb2.Any: ...
        once: builtins.bool
        """If true, define the flow as a one-time flow, such as for backfill.
        Set to true changes the flow in two ways:
          - The flow is run one time by default. If the pipeline is ran with a full refresh,
            the flow will run again.
          - The flow function must be a batch DataFrame, not a streaming DataFrame.
        """
        def __init__(
            self,
            *,
            dataflow_graph_id: builtins.str | None = ...,
            flow_name: builtins.str | None = ...,
            target_dataset_name: builtins.str | None = ...,
            sql_conf: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
            client_id: builtins.str | None = ...,
            source_code_location: global___SourceCodeLocation | None = ...,
            relation_flow_details: global___PipelineCommand.DefineFlow.WriteRelationFlowDetails
            | None = ...,
            extension: google.protobuf.any_pb2.Any | None = ...,
            once: builtins.bool | None = ...,
        ) -> None: ...
        def HasField(
            self,
            field_name: typing_extensions.Literal[
                "_client_id",
                b"_client_id",
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "_flow_name",
                b"_flow_name",
                "_once",
                b"_once",
                "_source_code_location",
                b"_source_code_location",
                "_target_dataset_name",
                b"_target_dataset_name",
                "client_id",
                b"client_id",
                "dataflow_graph_id",
                b"dataflow_graph_id",
                "details",
                b"details",
                "extension",
                b"extension",
                "flow_name",
                b"flow_name",
                "once",
                b"once",
                "relation_flow_details",
                b"relation_flow_details",
                "source_code_location",
                b"source_code_location",
                "target_dataset_name",
                b"target_dataset_name",
            ],
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "_client_id",
                b"_client_id",
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "_flow_name",
                b"_flow_name",
                "_once",
                b"_once",
                "_source_code_location",
                b"_source_code_location",
                "_target_dataset_name",
                b"_target_dataset_name",
                "client_id",
                b"client_id",
                "dataflow_graph_id",
                b"dataflow_graph_id",
                "details",
                b"details",
                "extension",
                b"extension",
                "flow_name",
                b"flow_name",
                "once",
                b"once",
                "relation_flow_details",
                b"relation_flow_details",
                "source_code_location",
                b"source_code_location",
                "sql_conf",
                b"sql_conf",
                "target_dataset_name",
                b"target_dataset_name",
            ],
        ) -> None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_client_id", b"_client_id"]
        ) -> typing_extensions.Literal["client_id"] | None: ...
        @typing.overload
        def WhichOneof(
            self,
            oneof_group: typing_extensions.Literal["_dataflow_graph_id", b"_dataflow_graph_id"],
        ) -> typing_extensions.Literal["dataflow_graph_id"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_flow_name", b"_flow_name"]
        ) -> typing_extensions.Literal["flow_name"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_once", b"_once"]
        ) -> typing_extensions.Literal["once"] | None: ...
        @typing.overload
        def WhichOneof(
            self,
            oneof_group: typing_extensions.Literal[
                "_source_code_location", b"_source_code_location"
            ],
        ) -> typing_extensions.Literal["source_code_location"] | None: ...
        @typing.overload
        def WhichOneof(
            self,
            oneof_group: typing_extensions.Literal["_target_dataset_name", b"_target_dataset_name"],
        ) -> typing_extensions.Literal["target_dataset_name"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["details", b"details"]
        ) -> typing_extensions.Literal["relation_flow_details", "extension"] | None: ...

    class StartRun(google.protobuf.message.Message):
        """Resolves all datasets and flows and start a pipeline update. Should be called after all
        graph elements are registered.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DATAFLOW_GRAPH_ID_FIELD_NUMBER: builtins.int
        FULL_REFRESH_SELECTION_FIELD_NUMBER: builtins.int
        FULL_REFRESH_ALL_FIELD_NUMBER: builtins.int
        REFRESH_SELECTION_FIELD_NUMBER: builtins.int
        DRY_FIELD_NUMBER: builtins.int
        STORAGE_FIELD_NUMBER: builtins.int
        dataflow_graph_id: builtins.str
        """The graph to start."""
        @property
        def full_refresh_selection(
            self,
        ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """List of dataset to reset and recompute."""
        full_refresh_all: builtins.bool
        """Perform a full graph reset and recompute."""
        @property
        def refresh_selection(
            self,
        ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """List of dataset to update."""
        dry: builtins.bool
        """If true, the run will not actually execute any flows, but will only validate the graph and
        check for any errors. This is useful for testing and validation purposes.
        """
        storage: builtins.str
        """storage location for pipeline checkpoints and metadata."""
        def __init__(
            self,
            *,
            dataflow_graph_id: builtins.str | None = ...,
            full_refresh_selection: collections.abc.Iterable[builtins.str] | None = ...,
            full_refresh_all: builtins.bool | None = ...,
            refresh_selection: collections.abc.Iterable[builtins.str] | None = ...,
            dry: builtins.bool | None = ...,
            storage: builtins.str | None = ...,
        ) -> None: ...
        def HasField(
            self,
            field_name: typing_extensions.Literal[
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "_dry",
                b"_dry",
                "_full_refresh_all",
                b"_full_refresh_all",
                "_storage",
                b"_storage",
                "dataflow_graph_id",
                b"dataflow_graph_id",
                "dry",
                b"dry",
                "full_refresh_all",
                b"full_refresh_all",
                "storage",
                b"storage",
            ],
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "_dry",
                b"_dry",
                "_full_refresh_all",
                b"_full_refresh_all",
                "_storage",
                b"_storage",
                "dataflow_graph_id",
                b"dataflow_graph_id",
                "dry",
                b"dry",
                "full_refresh_all",
                b"full_refresh_all",
                "full_refresh_selection",
                b"full_refresh_selection",
                "refresh_selection",
                b"refresh_selection",
                "storage",
                b"storage",
            ],
        ) -> None: ...
        @typing.overload
        def WhichOneof(
            self,
            oneof_group: typing_extensions.Literal["_dataflow_graph_id", b"_dataflow_graph_id"],
        ) -> typing_extensions.Literal["dataflow_graph_id"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_dry", b"_dry"]
        ) -> typing_extensions.Literal["dry"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_full_refresh_all", b"_full_refresh_all"]
        ) -> typing_extensions.Literal["full_refresh_all"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_storage", b"_storage"]
        ) -> typing_extensions.Literal["storage"] | None: ...

    class DefineSqlGraphElements(google.protobuf.message.Message):
        """Parses the SQL file and registers all datasets and flows."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DATAFLOW_GRAPH_ID_FIELD_NUMBER: builtins.int
        SQL_FILE_PATH_FIELD_NUMBER: builtins.int
        SQL_TEXT_FIELD_NUMBER: builtins.int
        dataflow_graph_id: builtins.str
        """The graph to attach this dataset to."""
        sql_file_path: builtins.str
        """The full path to the SQL file. Can be relative or absolute."""
        sql_text: builtins.str
        """The contents of the SQL file."""
        def __init__(
            self,
            *,
            dataflow_graph_id: builtins.str | None = ...,
            sql_file_path: builtins.str | None = ...,
            sql_text: builtins.str | None = ...,
        ) -> None: ...
        def HasField(
            self,
            field_name: typing_extensions.Literal[
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "_sql_file_path",
                b"_sql_file_path",
                "_sql_text",
                b"_sql_text",
                "dataflow_graph_id",
                b"dataflow_graph_id",
                "sql_file_path",
                b"sql_file_path",
                "sql_text",
                b"sql_text",
            ],
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "_sql_file_path",
                b"_sql_file_path",
                "_sql_text",
                b"_sql_text",
                "dataflow_graph_id",
                b"dataflow_graph_id",
                "sql_file_path",
                b"sql_file_path",
                "sql_text",
                b"sql_text",
            ],
        ) -> None: ...
        @typing.overload
        def WhichOneof(
            self,
            oneof_group: typing_extensions.Literal["_dataflow_graph_id", b"_dataflow_graph_id"],
        ) -> typing_extensions.Literal["dataflow_graph_id"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_sql_file_path", b"_sql_file_path"]
        ) -> typing_extensions.Literal["sql_file_path"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_sql_text", b"_sql_text"]
        ) -> typing_extensions.Literal["sql_text"] | None: ...

    class GetQueryFunctionExecutionSignalStream(google.protobuf.message.Message):
        """Request to get the stream of query function execution signals for a graph. Responses should
        be a stream of PipelineQueryFunctionExecutionSignal messages.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DATAFLOW_GRAPH_ID_FIELD_NUMBER: builtins.int
        CLIENT_ID_FIELD_NUMBER: builtins.int
        dataflow_graph_id: builtins.str
        """The graph to get the query function execution signal stream for."""
        client_id: builtins.str
        """Identifier for the client that is requesting the stream."""
        def __init__(
            self,
            *,
            dataflow_graph_id: builtins.str | None = ...,
            client_id: builtins.str | None = ...,
        ) -> None: ...
        def HasField(
            self,
            field_name: typing_extensions.Literal[
                "_client_id",
                b"_client_id",
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "client_id",
                b"client_id",
                "dataflow_graph_id",
                b"dataflow_graph_id",
            ],
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "_client_id",
                b"_client_id",
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "client_id",
                b"client_id",
                "dataflow_graph_id",
                b"dataflow_graph_id",
            ],
        ) -> None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_client_id", b"_client_id"]
        ) -> typing_extensions.Literal["client_id"] | None: ...
        @typing.overload
        def WhichOneof(
            self,
            oneof_group: typing_extensions.Literal["_dataflow_graph_id", b"_dataflow_graph_id"],
        ) -> typing_extensions.Literal["dataflow_graph_id"] | None: ...

    class DefineFlowQueryFunctionResult(google.protobuf.message.Message):
        """Request from the client to update the flow function evaluation result
        for a previously un-analyzed flow.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        FLOW_NAME_FIELD_NUMBER: builtins.int
        DATAFLOW_GRAPH_ID_FIELD_NUMBER: builtins.int
        RELATION_FIELD_NUMBER: builtins.int
        flow_name: builtins.str
        """The fully qualified name of the flow being updated."""
        dataflow_graph_id: builtins.str
        """The ID of the graph this flow belongs to."""
        @property
        def relation(self) -> pyspark.sql.connect.proto.relations_pb2.Relation:
            """An unresolved relation that defines the dataset's flow."""
        def __init__(
            self,
            *,
            flow_name: builtins.str | None = ...,
            dataflow_graph_id: builtins.str | None = ...,
            relation: pyspark.sql.connect.proto.relations_pb2.Relation | None = ...,
        ) -> None: ...
        def HasField(
            self,
            field_name: typing_extensions.Literal[
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "_flow_name",
                b"_flow_name",
                "_relation",
                b"_relation",
                "dataflow_graph_id",
                b"dataflow_graph_id",
                "flow_name",
                b"flow_name",
                "relation",
                b"relation",
            ],
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "_flow_name",
                b"_flow_name",
                "_relation",
                b"_relation",
                "dataflow_graph_id",
                b"dataflow_graph_id",
                "flow_name",
                b"flow_name",
                "relation",
                b"relation",
            ],
        ) -> None: ...
        @typing.overload
        def WhichOneof(
            self,
            oneof_group: typing_extensions.Literal["_dataflow_graph_id", b"_dataflow_graph_id"],
        ) -> typing_extensions.Literal["dataflow_graph_id"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_flow_name", b"_flow_name"]
        ) -> typing_extensions.Literal["flow_name"] | None: ...
        @typing.overload
        def WhichOneof(
            self, oneof_group: typing_extensions.Literal["_relation", b"_relation"]
        ) -> typing_extensions.Literal["relation"] | None: ...

    CREATE_DATAFLOW_GRAPH_FIELD_NUMBER: builtins.int
    DEFINE_OUTPUT_FIELD_NUMBER: builtins.int
    DEFINE_FLOW_FIELD_NUMBER: builtins.int
    DROP_DATAFLOW_GRAPH_FIELD_NUMBER: builtins.int
    START_RUN_FIELD_NUMBER: builtins.int
    DEFINE_SQL_GRAPH_ELEMENTS_FIELD_NUMBER: builtins.int
    GET_QUERY_FUNCTION_EXECUTION_SIGNAL_STREAM_FIELD_NUMBER: builtins.int
    DEFINE_FLOW_QUERY_FUNCTION_RESULT_FIELD_NUMBER: builtins.int
    EXTENSION_FIELD_NUMBER: builtins.int
    @property
    def create_dataflow_graph(self) -> global___PipelineCommand.CreateDataflowGraph: ...
    @property
    def define_output(self) -> global___PipelineCommand.DefineOutput: ...
    @property
    def define_flow(self) -> global___PipelineCommand.DefineFlow: ...
    @property
    def drop_dataflow_graph(self) -> global___PipelineCommand.DropDataflowGraph: ...
    @property
    def start_run(self) -> global___PipelineCommand.StartRun: ...
    @property
    def define_sql_graph_elements(self) -> global___PipelineCommand.DefineSqlGraphElements: ...
    @property
    def get_query_function_execution_signal_stream(
        self,
    ) -> global___PipelineCommand.GetQueryFunctionExecutionSignalStream: ...
    @property
    def define_flow_query_function_result(
        self,
    ) -> global___PipelineCommand.DefineFlowQueryFunctionResult: ...
    @property
    def extension(self) -> google.protobuf.any_pb2.Any:
        """Reserved field for protocol extensions.
        Used to support forward-compatibility by carrying additional command types
        that are not yet defined in this version of the proto. During planning, the
        engine will resolve and dispatch the concrete command contained in this field.
        """
    def __init__(
        self,
        *,
        create_dataflow_graph: global___PipelineCommand.CreateDataflowGraph | None = ...,
        define_output: global___PipelineCommand.DefineOutput | None = ...,
        define_flow: global___PipelineCommand.DefineFlow | None = ...,
        drop_dataflow_graph: global___PipelineCommand.DropDataflowGraph | None = ...,
        start_run: global___PipelineCommand.StartRun | None = ...,
        define_sql_graph_elements: global___PipelineCommand.DefineSqlGraphElements | None = ...,
        get_query_function_execution_signal_stream: global___PipelineCommand.GetQueryFunctionExecutionSignalStream
        | None = ...,
        define_flow_query_function_result: global___PipelineCommand.DefineFlowQueryFunctionResult
        | None = ...,
        extension: google.protobuf.any_pb2.Any | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "command_type",
            b"command_type",
            "create_dataflow_graph",
            b"create_dataflow_graph",
            "define_flow",
            b"define_flow",
            "define_flow_query_function_result",
            b"define_flow_query_function_result",
            "define_output",
            b"define_output",
            "define_sql_graph_elements",
            b"define_sql_graph_elements",
            "drop_dataflow_graph",
            b"drop_dataflow_graph",
            "extension",
            b"extension",
            "get_query_function_execution_signal_stream",
            b"get_query_function_execution_signal_stream",
            "start_run",
            b"start_run",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "command_type",
            b"command_type",
            "create_dataflow_graph",
            b"create_dataflow_graph",
            "define_flow",
            b"define_flow",
            "define_flow_query_function_result",
            b"define_flow_query_function_result",
            "define_output",
            b"define_output",
            "define_sql_graph_elements",
            b"define_sql_graph_elements",
            "drop_dataflow_graph",
            b"drop_dataflow_graph",
            "extension",
            b"extension",
            "get_query_function_execution_signal_stream",
            b"get_query_function_execution_signal_stream",
            "start_run",
            b"start_run",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["command_type", b"command_type"]
    ) -> (
        typing_extensions.Literal[
            "create_dataflow_graph",
            "define_output",
            "define_flow",
            "drop_dataflow_graph",
            "start_run",
            "define_sql_graph_elements",
            "get_query_function_execution_signal_stream",
            "define_flow_query_function_result",
            "extension",
        ]
        | None
    ): ...

global___PipelineCommand = PipelineCommand

class PipelineCommandResult(google.protobuf.message.Message):
    """Dispatch object for pipelines command results."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class CreateDataflowGraphResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DATAFLOW_GRAPH_ID_FIELD_NUMBER: builtins.int
        dataflow_graph_id: builtins.str
        """The ID of the created graph."""
        def __init__(
            self,
            *,
            dataflow_graph_id: builtins.str | None = ...,
        ) -> None: ...
        def HasField(
            self,
            field_name: typing_extensions.Literal[
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "dataflow_graph_id",
                b"dataflow_graph_id",
            ],
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "_dataflow_graph_id",
                b"_dataflow_graph_id",
                "dataflow_graph_id",
                b"dataflow_graph_id",
            ],
        ) -> None: ...
        def WhichOneof(
            self,
            oneof_group: typing_extensions.Literal["_dataflow_graph_id", b"_dataflow_graph_id"],
        ) -> typing_extensions.Literal["dataflow_graph_id"] | None: ...

    class DefineOutputResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        RESOLVED_IDENTIFIER_FIELD_NUMBER: builtins.int
        @property
        def resolved_identifier(self) -> pyspark.sql.connect.proto.common_pb2.ResolvedIdentifier:
            """Resolved identifier of the output"""
        def __init__(
            self,
            *,
            resolved_identifier: pyspark.sql.connect.proto.common_pb2.ResolvedIdentifier
            | None = ...,
        ) -> None: ...
        def HasField(
            self,
            field_name: typing_extensions.Literal[
                "_resolved_identifier",
                b"_resolved_identifier",
                "resolved_identifier",
                b"resolved_identifier",
            ],
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "_resolved_identifier",
                b"_resolved_identifier",
                "resolved_identifier",
                b"resolved_identifier",
            ],
        ) -> None: ...
        def WhichOneof(
            self,
            oneof_group: typing_extensions.Literal["_resolved_identifier", b"_resolved_identifier"],
        ) -> typing_extensions.Literal["resolved_identifier"] | None: ...

    class DefineFlowResult(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        RESOLVED_IDENTIFIER_FIELD_NUMBER: builtins.int
        @property
        def resolved_identifier(self) -> pyspark.sql.connect.proto.common_pb2.ResolvedIdentifier:
            """Resolved identifier of the flow"""
        def __init__(
            self,
            *,
            resolved_identifier: pyspark.sql.connect.proto.common_pb2.ResolvedIdentifier
            | None = ...,
        ) -> None: ...
        def HasField(
            self,
            field_name: typing_extensions.Literal[
                "_resolved_identifier",
                b"_resolved_identifier",
                "resolved_identifier",
                b"resolved_identifier",
            ],
        ) -> builtins.bool: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal[
                "_resolved_identifier",
                b"_resolved_identifier",
                "resolved_identifier",
                b"resolved_identifier",
            ],
        ) -> None: ...
        def WhichOneof(
            self,
            oneof_group: typing_extensions.Literal["_resolved_identifier", b"_resolved_identifier"],
        ) -> typing_extensions.Literal["resolved_identifier"] | None: ...

    CREATE_DATAFLOW_GRAPH_RESULT_FIELD_NUMBER: builtins.int
    DEFINE_OUTPUT_RESULT_FIELD_NUMBER: builtins.int
    DEFINE_FLOW_RESULT_FIELD_NUMBER: builtins.int
    @property
    def create_dataflow_graph_result(
        self,
    ) -> global___PipelineCommandResult.CreateDataflowGraphResult: ...
    @property
    def define_output_result(self) -> global___PipelineCommandResult.DefineOutputResult: ...
    @property
    def define_flow_result(self) -> global___PipelineCommandResult.DefineFlowResult: ...
    def __init__(
        self,
        *,
        create_dataflow_graph_result: global___PipelineCommandResult.CreateDataflowGraphResult
        | None = ...,
        define_output_result: global___PipelineCommandResult.DefineOutputResult | None = ...,
        define_flow_result: global___PipelineCommandResult.DefineFlowResult | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "create_dataflow_graph_result",
            b"create_dataflow_graph_result",
            "define_flow_result",
            b"define_flow_result",
            "define_output_result",
            b"define_output_result",
            "result_type",
            b"result_type",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "create_dataflow_graph_result",
            b"create_dataflow_graph_result",
            "define_flow_result",
            b"define_flow_result",
            "define_output_result",
            b"define_output_result",
            "result_type",
            b"result_type",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["result_type", b"result_type"]
    ) -> (
        typing_extensions.Literal[
            "create_dataflow_graph_result", "define_output_result", "define_flow_result"
        ]
        | None
    ): ...

global___PipelineCommandResult = PipelineCommandResult

class PipelineEventResult(google.protobuf.message.Message):
    """A response containing an event emitted during the run of a pipeline."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EVENT_FIELD_NUMBER: builtins.int
    @property
    def event(self) -> global___PipelineEvent: ...
    def __init__(
        self,
        *,
        event: global___PipelineEvent | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["event", b"event"]
    ) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["event", b"event"]) -> None: ...

global___PipelineEventResult = PipelineEventResult

class PipelineEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The timestamp corresponding to when the event occurred."""
    message: builtins.str
    """The message that should be displayed to users."""
    def __init__(
        self,
        *,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        message: builtins.str | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "_message", b"_message", "message", b"message", "timestamp", b"timestamp"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "_message", b"_message", "message", b"message", "timestamp", b"timestamp"
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_message", b"_message"]
    ) -> typing_extensions.Literal["message"] | None: ...

global___PipelineEvent = PipelineEvent

class SourceCodeLocation(google.protobuf.message.Message):
    """Source code location information associated with a particular dataset or flow."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_NAME_FIELD_NUMBER: builtins.int
    LINE_NUMBER_FIELD_NUMBER: builtins.int
    DEFINITION_PATH_FIELD_NUMBER: builtins.int
    EXTENSION_FIELD_NUMBER: builtins.int
    file_name: builtins.str
    """The file that this pipeline source code was defined in."""
    line_number: builtins.int
    """The specific line number that this pipeline source code is located at, if applicable."""
    definition_path: builtins.str
    """The path of the top-level pipeline file determined at runtime during pipeline initialization."""
    @property
    def extension(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        google.protobuf.any_pb2.Any
    ]:
        """Reserved field for protocol extensions.
        Used to support forward-compatibility by carrying additional fields
        that are not yet defined in this version of the proto. During planning, the
        engine will resolve and dispatch the concrete command contained in this field.
        """
    def __init__(
        self,
        *,
        file_name: builtins.str | None = ...,
        line_number: builtins.int | None = ...,
        definition_path: builtins.str | None = ...,
        extension: collections.abc.Iterable[google.protobuf.any_pb2.Any] | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "_definition_path",
            b"_definition_path",
            "_file_name",
            b"_file_name",
            "_line_number",
            b"_line_number",
            "definition_path",
            b"definition_path",
            "file_name",
            b"file_name",
            "line_number",
            b"line_number",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "_definition_path",
            b"_definition_path",
            "_file_name",
            b"_file_name",
            "_line_number",
            b"_line_number",
            "definition_path",
            b"definition_path",
            "extension",
            b"extension",
            "file_name",
            b"file_name",
            "line_number",
            b"line_number",
        ],
    ) -> None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_definition_path", b"_definition_path"]
    ) -> typing_extensions.Literal["definition_path"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_file_name", b"_file_name"]
    ) -> typing_extensions.Literal["file_name"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_line_number", b"_line_number"]
    ) -> typing_extensions.Literal["line_number"] | None: ...

global___SourceCodeLocation = SourceCodeLocation

class PipelineQueryFunctionExecutionSignal(google.protobuf.message.Message):
    """A signal from the server to the client to execute the query function for one or more flows, and
    to register their results with the server.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FLOW_NAMES_FIELD_NUMBER: builtins.int
    @property
    def flow_names(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        flow_names: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["flow_names", b"flow_names"]
    ) -> None: ...

global___PipelineQueryFunctionExecutionSignal = PipelineQueryFunctionExecutionSignal

class PipelineAnalysisContext(google.protobuf.message.Message):
    """Metadata providing context about the pipeline during Spark Connect query analysis."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATAFLOW_GRAPH_ID_FIELD_NUMBER: builtins.int
    DEFINITION_PATH_FIELD_NUMBER: builtins.int
    FLOW_NAME_FIELD_NUMBER: builtins.int
    EXTENSION_FIELD_NUMBER: builtins.int
    dataflow_graph_id: builtins.str
    """Unique identifier of the dataflow graph associated with this pipeline."""
    definition_path: builtins.str
    """The path of the top-level pipeline file determined at runtime during pipeline initialization."""
    flow_name: builtins.str
    """The name of the Flow involved in this analysis"""
    @property
    def extension(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        google.protobuf.any_pb2.Any
    ]:
        """Reserved field for protocol extensions."""
    def __init__(
        self,
        *,
        dataflow_graph_id: builtins.str | None = ...,
        definition_path: builtins.str | None = ...,
        flow_name: builtins.str | None = ...,
        extension: collections.abc.Iterable[google.protobuf.any_pb2.Any] | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "_dataflow_graph_id",
            b"_dataflow_graph_id",
            "_definition_path",
            b"_definition_path",
            "_flow_name",
            b"_flow_name",
            "dataflow_graph_id",
            b"dataflow_graph_id",
            "definition_path",
            b"definition_path",
            "flow_name",
            b"flow_name",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "_dataflow_graph_id",
            b"_dataflow_graph_id",
            "_definition_path",
            b"_definition_path",
            "_flow_name",
            b"_flow_name",
            "dataflow_graph_id",
            b"dataflow_graph_id",
            "definition_path",
            b"definition_path",
            "extension",
            b"extension",
            "flow_name",
            b"flow_name",
        ],
    ) -> None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_dataflow_graph_id", b"_dataflow_graph_id"]
    ) -> typing_extensions.Literal["dataflow_graph_id"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_definition_path", b"_definition_path"]
    ) -> typing_extensions.Literal["definition_path"] | None: ...
    @typing.overload
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["_flow_name", b"_flow_name"]
    ) -> typing_extensions.Literal["flow_name"] | None: ...

global___PipelineAnalysisContext = PipelineAnalysisContext
