/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$;
import org.apache.spark.sql.classic.ClassicConversions$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.AlterTableAddColumnsCommand$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat;
import org.apache.spark.sql.execution.datasources.json.JsonFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.v2.csv.CSVDataSourceV2;
import org.apache.spark.sql.execution.datasources.v2.json.JsonDataSourceV2;
import org.apache.spark.sql.execution.datasources.v2.orc.OrcDataSourceV2;
import org.apache.spark.sql.execution.datasources.v2.parquet.ParquetDataSourceV2;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.SchemaUtils$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015g\u0001B\r\u001b\u0001\u001eB\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0015\"Aq\n\u0001BK\u0002\u0013\u0005\u0001\u000b\u0003\u0005[\u0001\tE\t\u0015!\u0003R\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015a\u0007\u0001\"\u0003n\u0011%\t\u0019\u0001AA\u0001\n\u0003\t)\u0001C\u0005\u0002\f\u0001\t\n\u0011\"\u0001\u0002\u000e!I\u00111\u0005\u0001\u0012\u0002\u0013\u0005\u0011Q\u0005\u0005\n\u0003S\u0001\u0011\u0011!C!\u0003WA\u0011\"!\u0010\u0001\u0003\u0003%\t!a\u0010\t\u0013\u0005\u001d\u0003!!A\u0005\u0002\u0005%\u0003\"CA+\u0001\u0005\u0005I\u0011IA,\u0011%\t)\u0007AA\u0001\n\u0003\t9\u0007C\u0005\u0002r\u0001\t\t\u0011\"\u0011\u0002t!I\u0011q\u000f\u0001\u0002\u0002\u0013\u0005\u0013\u0011P\u0004\n\u0003{R\u0012\u0011!E\u0001\u0003\u007f2\u0001\"\u0007\u000e\u0002\u0002#\u0005\u0011\u0011\u0011\u0005\u00077N!\t!!'\t\u0013\u0005m5#!A\u0005F\u0005u\u0005\"CAP'\u0005\u0005I\u0011QAQ\u0011%\t9kEA\u0001\n\u0003\u000bI\u000bC\u0005\u0002<N\t\t\u0011\"\u0003\u0002>\nY\u0012\t\u001c;feR\u000b'\r\\3BI\u0012\u001cu\u000e\\;n]N\u001cu.\\7b]\u0012T!a\u0007\u000f\u0002\u000f\r|W.\\1oI*\u0011QDH\u0001\nKb,7-\u001e;j_:T!a\b\u0011\u0002\u0007M\fHN\u0003\u0002\"E\u0005)1\u000f]1sW*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u00153mq\u0002\"!\u000b\u0019\u000e\u0003)R!a\u000b\u0017\u0002\u000f1|w-[2bY*\u0011QFL\u0001\u0006a2\fgn\u001d\u0006\u0003_y\t\u0001bY1uC2L8\u000f^\u0005\u0003c)\u00121\u0002T8hS\u000e\fG\u000e\u00157b]B\u00111\u0007N\u0007\u00025%\u0011QG\u0007\u0002\u0014\u0019\u0016\fgMU;o]\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\b!J|G-^2u!\tiTI\u0004\u0002?\u0007:\u0011qHQ\u0007\u0002\u0001*\u0011\u0011IJ\u0001\u0007yI|w\u000e\u001e \n\u0003eJ!\u0001\u0012\u001d\u0002\u000fA\f7m[1hK&\u0011ai\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\tb\nQ\u0001^1cY\u0016,\u0012A\u0013\t\u0003\u00172k\u0011AL\u0005\u0003\u001b:\u0012q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM]\u0001\u0007i\u0006\u0014G.\u001a\u0011\u0002\u0013\r|Gn\u001d+p\u0003\u0012$W#A)\u0011\u0007u\u0012F+\u0003\u0002T\u000f\n\u00191+Z9\u0011\u0005UCV\"\u0001,\u000b\u0005]s\u0012!\u0002;za\u0016\u001c\u0018BA-W\u0005-\u0019FO];di\u001aKW\r\u001c3\u0002\u0015\r|Gn\u001d+p\u0003\u0012$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004;z{\u0006CA\u001a\u0001\u0011\u0015AU\u00011\u0001K\u0011\u0015yU\u00011\u0001R\u0003\r\u0011XO\u001c\u000b\u0003E\u001e\u00042!\u0010*d!\t!W-D\u0001\u001f\u0013\t1gDA\u0002S_^DQ\u0001\u001b\u0004A\u0002%\fAb\u001d9be.\u001cVm]:j_:\u0004\"\u0001\u001a6\n\u0005-t\"\u0001D*qCJ\\7+Z:tS>t\u0017!\u0007<fe&4\u00170\u00117uKJ$\u0016M\u00197f\u0003\u0012$7i\u001c7v[:$RA\u001c;}\u0003\u0003\u0001\"a\u001c:\u000e\u0003AT!!\u001d\u0018\u0002\u000f\r\fG/\u00197pO&\u00111\u000f\u001d\u0002\r\u0007\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a\u0005\u0006k\u001e\u0001\rA^\u0001\u0005G>tg\r\u0005\u0002xu6\t\u0001P\u0003\u0002z=\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002|q\n91+\u0015'D_:4\u0007\"B9\b\u0001\u0004i\bCA8\u007f\u0013\ty\bO\u0001\bTKN\u001c\u0018n\u001c8DCR\fGn\\4\t\u000b!;\u0001\u0019\u0001&\u0002\t\r|\u0007/\u001f\u000b\u0006;\u0006\u001d\u0011\u0011\u0002\u0005\b\u0011\"\u0001\n\u00111\u0001K\u0011\u001dy\u0005\u0002%AA\u0002E\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0010)\u001a!*!\u0005,\u0005\u0005M\u0001\u0003BA\u000b\u0003?i!!a\u0006\u000b\t\u0005e\u00111D\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\b9\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003C\t9BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002()\u001a\u0011+!\u0005\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ti\u0003\u0005\u0003\u00020\u0005eRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\t1\fgn\u001a\u0006\u0003\u0003o\tAA[1wC&!\u00111HA\u0019\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\t\t\u0004o\u0005\r\u0013bAA#q\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111JA)!\r9\u0014QJ\u0005\u0004\u0003\u001fB$aA!os\"I\u00111K\u0007\u0002\u0002\u0003\u0007\u0011\u0011I\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005e\u0003CBA.\u0003C\nY%\u0004\u0002\u0002^)\u0019\u0011q\f\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002d\u0005u#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u001b\u0002pA\u0019q'a\u001b\n\u0007\u00055\u0004HA\u0004C_>dW-\u00198\t\u0013\u0005Ms\"!AA\u0002\u0005-\u0013A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!\f\u0002v!I\u00111\u000b\t\u0002\u0002\u0003\u0007\u0011\u0011I\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005%\u00141\u0010\u0005\n\u0003'\n\u0012\u0011!a\u0001\u0003\u0017\n1$\u00117uKJ$\u0016M\u00197f\u0003\u0012$7i\u001c7v[:\u001c8i\\7nC:$\u0007CA\u001a\u0014'\u0015\u0019\u00121QAH!\u001d\t))a#K#vk!!a\"\u000b\u0007\u0005%\u0005(A\u0004sk:$\u0018.\\3\n\t\u00055\u0015q\u0011\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BAI\u0003/k!!a%\u000b\t\u0005U\u0015QG\u0001\u0003S>L1ARAJ)\t\ty(\u0001\u0005u_N#(/\u001b8h)\t\ti#A\u0003baBd\u0017\u0010F\u0003^\u0003G\u000b)\u000bC\u0003I-\u0001\u0007!\nC\u0003P-\u0001\u0007\u0011+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005-\u0016q\u0017\t\u0006o\u00055\u0016\u0011W\u0005\u0004\u0003_C$AB(qi&|g\u000eE\u00038\u0003gS\u0015+C\u0002\u00026b\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CA]/\u0005\u0005\t\u0019A/\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002@B!\u0011qFAa\u0013\u0011\t\u0019-!\r\u0003\r=\u0013'.Z2u\u0001")
public class AlterTableAddColumnsCommand
extends LogicalPlan
implements LeafRunnableCommand,
Serializable {
    private final TableIdentifier table;
    private final Seq<StructField> colsToAdd;
    private Map<String, SQLMetric> metrics;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<TableIdentifier, Seq<StructField>>> unapply(AlterTableAddColumnsCommand x$0) {
        return AlterTableAddColumnsCommand$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<TableIdentifier, Seq<StructField>>, AlterTableAddColumnsCommand> tupled() {
        return AlterTableAddColumnsCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Seq<StructField>, AlterTableAddColumnsCommand>> curried() {
        return AlterTableAddColumnsCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableAddColumnsCommand alterTableAddColumnsCommand = this;
        synchronized (alterTableAddColumnsCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        if (!this.bitmap$0) {
            return this.metrics$lzycompute();
        }
        return this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier table() {
        return this.table;
    }

    public Seq<StructField> colsToAdd() {
        return this.colsToAdd;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable catalogTable = this.verifyAlterTableAddColumn(sparkSession.sessionState().conf(), catalog, this.table());
        ResolveDefaultColumns$.MODULE$.validateTableProviderForDefaultValue(StructType$.MODULE$.apply(this.colsToAdd()), catalogTable.provider(), "ALTER TABLE ADD COLUMNS", true);
        CommandUtils$.MODULE$.uncacheTableOrView(ClassicConversions$.MODULE$.castToImpl(sparkSession), this.table());
        catalog.refreshTable(this.table());
        SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq)((IterableOps)this.colsToAdd().$plus$plus((IterableOnce)catalogTable.schema())).map((Function1 & Serializable)x$2 -> x$2.name()), sparkSession.sessionState().conf().caseSensitiveAnalysis());
        if (!this.conf().allowCollationsInMapKeys()) {
            this.colsToAdd().foreach((Function1 & Serializable)col -> {
                SchemaUtils$.MODULE$.checkNoCollationsInMapKeys(col.dataType());
                return BoxedUnit.UNIT;
            });
        }
        DDLUtils$.MODULE$.checkTableColumns(catalogTable, StructType$.MODULE$.apply(this.colsToAdd()));
        StructType existingDataSchema = CharVarcharUtils$.MODULE$.getRawSchema(catalogTable.dataSchema());
        catalog.alterTableSchema(this.table(), StructType$.MODULE$.apply((Seq)((IterableOps)existingDataSchema.$plus$plus(this.colsToAdd())).$plus$plus((IterableOnce)catalogTable.partitionSchema())));
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private CatalogTable verifyAlterTableAddColumn(SQLConf conf, SessionCatalog catalog, TableIdentifier table) {
        CatalogTable catalogTable = catalog.getTempViewOrPermanentTableMetadata(table);
        CatalogTableType catalogTableType = catalogTable.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw QueryCompilationErrors$.MODULE$.alterAddColNotSupportViewError(table);
        }
        if (DDLUtils$.MODULE$.isDatasourceTable(catalogTable)) {
            Object obj = DataSource$.MODULE$.lookupDataSource((String)catalogTable.provider().get(), conf).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (obj instanceof CSVFileFormat ? true : (obj instanceof JsonFileFormat ? true : obj instanceof ParquetFileFormat)) {
            } else if (obj instanceof JsonDataSourceV2 ? true : (obj instanceof CSVDataSourceV2 ? true : (obj instanceof OrcDataSourceV2 ? true : obj instanceof ParquetDataSourceV2))) {
            } else if (obj.getClass().getCanonicalName().endsWith("OrcFileFormat")) {
            } else {
                throw QueryCompilationErrors$.MODULE$.alterAddColNotSupportDatasourceTableError(obj, table);
            }
        }
        return catalogTable;
    }

    public AlterTableAddColumnsCommand copy(TableIdentifier table, Seq<StructField> colsToAdd) {
        return new AlterTableAddColumnsCommand(table, colsToAdd);
    }

    public TableIdentifier copy$default$1() {
        return this.table();
    }

    public Seq<StructField> copy$default$2() {
        return this.colsToAdd();
    }

    public String productPrefix() {
        return "AlterTableAddColumnsCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.table();
            }
            case 1: {
                return this.colsToAdd();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableAddColumnsCommand;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "table";
            }
            case 1: {
                return "colsToAdd";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableAddColumnsCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableAddColumnsCommand alterTableAddColumnsCommand = (AlterTableAddColumnsCommand)x$1;
        TableIdentifier tableIdentifier = this.table();
        TableIdentifier tableIdentifier2 = alterTableAddColumnsCommand.table();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Seq<StructField> seq = this.colsToAdd();
        Seq<StructField> seq2 = alterTableAddColumnsCommand.colsToAdd();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!alterTableAddColumnsCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableAddColumnsCommand(TableIdentifier table, Seq<StructField> colsToAdd) {
        this.table = table;
        this.colsToAdd = colsToAdd;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
        Statics.releaseFence();
    }
}

