/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Add$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.Multiply$;
import org.apache.spark.sql.catalyst.expressions.RDG;
import org.apache.spark.sql.catalyst.expressions.Rand$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.Subtract$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.Uniform$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.UpCastRule$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(min, max[, seed]) - Returns a random value with independent and identically\n      distributed (i.i.d.) values with the specified range of numbers. The random seed is optional.\n      The provided numbers specifying the minimum and maximum values of the range must be constant.\n      If both of these numbers are integers, then the result will also be an integer. Otherwise if\n      one or both of these are floating-point numbers, then the result will also be a floating-point\n      number.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(10, 20, 0) > 0 AS result;\n      true\n  ", since="4.0.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\tEf\u0001B\u001a5\u0001\u0006C\u0001B\u001b\u0001\u0003\u0016\u0004%\ta\u001b\u0005\tY\u0002\u0011\t\u0012)A\u0005\u0005\"AQ\u000e\u0001BK\u0002\u0013\u00051\u000e\u0003\u0005o\u0001\tE\t\u0015!\u0003C\u0011!y\u0007A!f\u0001\n\u0003Y\u0007\u0002\u00039\u0001\u0005#\u0005\u000b\u0011\u0002\"\t\u0011E\u0004!Q3A\u0005\u0002ID\u0001B\u001e\u0001\u0003\u0012\u0003\u0006Ia\u001d\u0005\to\u0002\u0011)\u001a!C\u0001q\"I\u0011\u0011\u0002\u0001\u0003\u0012\u0003\u0006I!\u001f\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0011\u001d\tY\u0001\u0001C\u0001\u00037Aq!a\u0003\u0001\t\u0003\t\t\u0003C\u0005\u0002*\u0001A)\u0019!C#e\"9\u00111\u0006\u0001\u0005B\u00055\u0002bBA.\u0001\u0011\u0005\u0013Q\f\u0005\b\u0003[\u0002A\u0011IA8\u0011\u0019I\u0004\u0001\"\u0011\u0002x!9\u0011\u0011\u0010\u0001\u0005B\u0005m\u0004BBAE\u0001\u0011\u00053\u000e\u0003\u0004\u0002\f\u0002!\te\u001b\u0005\u0007\u0003\u001b\u0003A\u0011I6\t\u000f\u0005=\u0005\u0001\"\u0011\u0002\u0012\"9\u0011Q\u0014\u0001\u0005B\u0005}\u0005bBAS\u0001\u0011\u0005\u0013q\u0015\u0005\u0007\u0003k\u0003A\u0011I6\t\u000f\u0005]\u0006\u0001\"\u0011\u0002:\"I\u0011Q\u0018\u0001\u0002\u0002\u0013\u0005\u0011q\u0018\u0005\n\u0003\u0017\u0004\u0011\u0013!C\u0001\u0003\u001bD\u0011\"a9\u0001#\u0003%\t!!4\t\u0013\u0005\u0015\b!%A\u0005\u0002\u00055\u0007\"CAt\u0001E\u0005I\u0011AAu\u0011%\ti\u000fAI\u0001\n\u0003\ty\u000fC\u0005\u0002t\u0002\t\t\u0011\"\u0011\u0002v\"I!Q\u0001\u0001\u0002\u0002\u0013\u0005!q\u0001\u0005\n\u0005\u001f\u0001\u0011\u0011!C\u0001\u0005#A\u0011B!\b\u0001\u0003\u0003%\tEa\b\t\u0013\t5\u0002!!A\u0005\u0002\t=\u0002\"\u0003B\u001a\u0001\u0005\u0005I\u0011\tB\u001b\u0011%\u0011I\u0004AA\u0001\n\u0003\u0012YdB\u0004\u0003`QB\tA!\u0019\u0007\rM\"\u0004\u0012\u0001B2\u0011\u001d\tYA\u000bC\u0001\u0005kBqAa\u001e+\t\u0003\u0011I\bC\u0004\u0003x)\"\tAa \t\u0013\t]$&!A\u0005\u0002\n\u001d\u0005\"\u0003BJUE\u0005I\u0011AAx\u0011%\u0011)JKA\u0001\n\u0003\u00139\nC\u0005\u0003&*\n\n\u0011\"\u0001\u0002p\"I!q\u0015\u0016\u0002\u0002\u0013%!\u0011\u0016\u0002\b+:Lgm\u001c:n\u0015\t)d'A\u0006fqB\u0014Xm]:j_:\u001c(BA\u001c9\u0003!\u0019\u0017\r^1msN$(BA\u001d;\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003wq\nQa\u001d9be.T!!\u0010 \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0014aA8sO\u000e\u00011#\u0003\u0001C\r&{%+\u0016-_!\t\u0019E)D\u00015\u0013\t)EG\u0001\u0006FqB\u0014Xm]:j_:\u0004\"aQ$\n\u0005!#$A\u0005*v]RLW.\u001a*fa2\f7-Z1cY\u0016\u00042AS'C\u001b\u0005Y%B\u0001'7\u0003\u0015!(/Z3t\u0013\tq5JA\u0006UKJt\u0017M]=MS.,\u0007CA\"Q\u0013\t\tFGA\u0002S\t\u001e\u0003\"aQ*\n\u0005Q#$!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u00111IV\u0005\u0003/R\u0012q\u0003V5nKj{g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005ecV\"\u0001.\u000b\u0003m\u000bQa]2bY\u0006L!!\u0018.\u0003\u000fA\u0013x\u000eZ;diB\u0011ql\u001a\b\u0003A\u0016t!!\u00193\u000e\u0003\tT!a\u0019!\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0016B\u00014[\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001[5\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\u0019T\u0016aA7j]V\t!)\u0001\u0003nS:\u0004\u0013aA7bq\u0006!Q.\u0019=!\u00039\u0019X-\u001a3FqB\u0014Xm]:j_:\fqb]3fI\u0016C\bO]3tg&|g\u000eI\u0001\tQ&$WmU3fIV\t1\u000f\u0005\u0002Zi&\u0011QO\u0017\u0002\b\u0005>|G.Z1o\u0003%A\u0017\u000eZ3TK\u0016$\u0007%\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\u0012!\u001f\t\u00043jd\u0018BA>[\u0005\u0019y\u0005\u000f^5p]B\u0019Q0a\u0001\u000f\u0005y|\bCA1[\u0013\r\t\tAW\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0011q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005!,A\u0006uS6,'l\u001c8f\u0013\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0007\u0002\u0010\u0005E\u00111CA\u000b\u0003/\tI\u0002\u0005\u0002D\u0001!)!n\u0003a\u0001\u0005\")Qn\u0003a\u0001\u0005\")qn\u0003a\u0001\u0005\")\u0011o\u0003a\u0001g\"9qo\u0003I\u0001\u0002\u0004IHCBA\b\u0003;\ty\u0002C\u0003k\u0019\u0001\u0007!\tC\u0003n\u0019\u0001\u0007!\t\u0006\u0005\u0002\u0010\u0005\r\u0012QEA\u0014\u0011\u0015QW\u00021\u0001C\u0011\u0015iW\u00021\u0001C\u0011\u0015yW\u00021\u0001C\u00035!W\r^3s[&t\u0017n\u001d;jG\u0006!bn\u001c3f!\u0006$H/\u001a:og&sG/\u001a:oC2$\"!a\f\u0011\u000b}\u000b\t$!\u000e\n\u0007\u0005M\u0012NA\u0002TKF\u0004B!a\u000e\u0002V9!\u0011\u0011HA)\u001d\u0011\tY$a\u0014\u000f\t\u0005u\u0012Q\n\b\u0005\u0003\u007f\tYE\u0004\u0003\u0002B\u0005%c\u0002BA\"\u0003\u000fr1!YA#\u0013\u0005y\u0014BA\u001f?\u0013\tYD(\u0003\u0002:u%\u0011q\u0007O\u0005\u0003\u0019ZJ1!a\u0015L\u0003-!&/Z3QCR$XM\u001d8\n\t\u0005]\u0013\u0011\f\u0002\f)J,W\rU1ui\u0016\u0014hNC\u0002\u0002T-\u000b!\"\u001b8qkR$\u0016\u0010]3t+\t\ty\u0006E\u0003`\u0003c\t\t\u0007\u0005\u0003\u0002d\u0005%TBAA3\u0015\r\t9\u0007O\u0001\u0006if\u0004Xm]\u0005\u0005\u0003W\n)G\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0002rA!\u00111MA:\u0013\u0011\t)(!\u001a\u0003\u0011\u0011\u000bG/\u0019+za\u0016,\u0012\u0001`\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003{\u0002B!a \u0002\u00066\u0011\u0011\u0011\u0011\u0006\u0004\u0003\u00073\u0014\u0001C1oC2L8/[:\n\t\u0005\u001d\u0015\u0011\u0011\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006)a-\u001b:ti\u000611/Z2p]\u0012\fQ\u0001\u001e5je\u0012\f1b^5uQ:+woU3fIR\u0019!)a%\t\u000f\u0005Uu\u00031\u0001\u0002\u0018\u00069a.Z<TK\u0016$\u0007cA-\u0002\u001a&\u0019\u00111\u0014.\u0003\t1{gnZ\u0001\u0010o&$\bn\u00155jMR,GmU3fIR\u0019!)!)\t\u000f\u0005\r\u0006\u00041\u0001\u0002\u0018\u0006)1\u000f[5gi\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\b\u0005\u0006%\u0016QVAY\u0011\u0019\tY+\u0007a\u0001\u0005\u0006Aa.Z<GSJ\u001cH\u000f\u0003\u0004\u00020f\u0001\rAQ\u0001\n]\u0016<8+Z2p]\u0012Da!a-\u001a\u0001\u0004\u0011\u0015\u0001\u00038foRC\u0017N\u001d3\u0002\u0017I,\u0007\u000f\\1dK6,g\u000e^\u0001\ro&$\b\u000eV5nKj{g.\u001a\u000b\u0004+\u0006m\u0006\"B<\u001c\u0001\u0004a\u0018\u0001B2paf$B\"a\u0004\u0002B\u0006\r\u0017QYAd\u0003\u0013DqA\u001b\u000f\u0011\u0002\u0003\u0007!\tC\u0004n9A\u0005\t\u0019\u0001\"\t\u000f=d\u0002\u0013!a\u0001\u0005\"9\u0011\u000f\bI\u0001\u0002\u0004\u0019\bbB<\u001d!\u0003\u0005\r!_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyMK\u0002C\u0003#\\#!a5\u0011\t\u0005U\u0017q\\\u0007\u0003\u0003/TA!!7\u0002\\\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003;T\u0016AC1o]>$\u0018\r^5p]&!\u0011\u0011]Al\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002l*\u001a1/!5\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011\u0011\u001f\u0016\u0004s\u0006E\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002xB!\u0011\u0011 B\u0002\u001b\t\tYP\u0003\u0003\u0002~\u0006}\u0018\u0001\u00027b]\u001eT!A!\u0001\u0002\t)\fg/Y\u0005\u0005\u0003\u000b\tY0\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0003\nA\u0019\u0011La\u0003\n\u0007\t5!LA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003\u0014\te\u0001cA-\u0003\u0016%\u0019!q\u0003.\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003\u001c\u0011\n\t\u00111\u0001\u0003\n\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\t\u0011\r\t\r\"\u0011\u0006B\n\u001b\t\u0011)CC\u0002\u0003(i\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011YC!\n\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004g\nE\u0002\"\u0003B\u000eM\u0005\u0005\t\u0019\u0001B\n\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005](q\u0007\u0005\n\u000579\u0013\u0011!a\u0001\u0005\u0013\ta!Z9vC2\u001cHcA:\u0003>!I!1\u0004\u0015\u0002\u0002\u0003\u0007!1\u0003\u0015\u0014\u0001\t\u0005#q\tB%\u0005\u001b\u0012yEa\u0015\u0003V\te#1\f\t\u0004\u0007\n\r\u0013b\u0001B#i\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001B&\u0003\rE(\u0002\t\u0011!A}3UKT\"`Q5Lg\u000e\f\u0011nCb\\F\u0006I:fK\u0012l\u0016\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u0004#/\u00198e_6\u0004c/\u00197vK\u0002:\u0018\u000e\u001e5!S:$W\r]3oI\u0016tG\u000fI1oI\u0002JG-\u001a8uS\u000e\fG\u000e\\=\u000bA\u0001\u0002\u0003\u0005\t\u0011eSN$(/\u001b2vi\u0016$\u0007\u0005K5/S:\"g&\u000b\u0011wC2,Xm\u001d\u0011xSRD\u0007\u0005\u001e5fAM\u0004XmY5gS\u0016$\u0007E]1oO\u0016\u0004sN\u001a\u0011ok6\u0014WM]:/AQCW\r\t:b]\u0012|W\u000eI:fK\u0012\u0004\u0013n\u001d\u0011paRLwN\\1m])\u0001\u0003\u0005\t\u0011!AQCW\r\t9s_ZLG-\u001a3!]Vl'-\u001a:tAM\u0004XmY5gs&tw\r\t;iK\u0002j\u0017N\\5nk6\u0004\u0013M\u001c3![\u0006D\u0018.\\;nAY\fG.^3tA=4\u0007\u0005\u001e5fAI\fgnZ3![V\u001cH\u000f\t2fA\r|gn\u001d;b]Rt#\u0002\t\u0011!A\u0001\u0002\u0013J\u001a\u0011c_RD\u0007e\u001c4!i\",7/\u001a\u0011ok6\u0014WM]:!CJ,\u0007%\u001b8uK\u001e,'o\u001d\u0017!i\",g\u000e\t;iK\u0002\u0012Xm];mi\u0002:\u0018\u000e\u001c7!C2\u001cx\u000e\t2fA\u0005t\u0007%\u001b8uK\u001e,'O\f\u0011Pi\",'o^5tK\u0002JgM\u0003\u0011!A\u0001\u0002\u0003e\u001c8fA=\u0014\bEY8uQ\u0002zg\r\t;iKN,\u0007%\u0019:fA\u0019dw.\u0019;j]\u001el\u0003o\\5oi\u0002rW/\u001c2feNd\u0003\u0005\u001e5f]\u0002\"\b.\u001a\u0011sKN,H\u000e\u001e\u0011xS2d\u0007%\u00197t_\u0002\u0012W\rI1!M2|\u0017\r^5oO6\u0002x.\u001b8u\u0015\u0001\u0002\u0003\u0005\t\u0011!]Vl'-\u001a:/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\tE\u0013\u0001\u0014\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)cAb\u0003E\r\u0019-AAJ\u0003E\u0010\u00111A\u0005\u001b\u0006E]3tk2$8H\u0003\u0011!A\u0001\u0002\u0003\u0005\u001e:vK*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0003X\u0005)AG\f\u0019/a\u0005)qM]8va\u0006\u0012!QL\u0001\u000b[\u0006$\bn\u00184v]\u000e\u001c\u0018aB+oS\u001a|'/\u001c\t\u0003\u0007*\u001aRA\u000bB3\u0005W\u00022!\u0017B4\u0013\r\u0011IG\u0017\u0002\u0007\u0003:L(+\u001a4\u0011\t\t5$1O\u0007\u0003\u0005_RAA!\u001d\u0002\u0000\u0006\u0011\u0011n\\\u0005\u0004Q\n=DC\u0001B1\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\tyAa\u001f\u0003~!)!\u000e\fa\u0001\u0005\")Q\u000e\fa\u0001\u0005RA\u0011q\u0002BA\u0005\u0007\u0013)\tC\u0003k[\u0001\u0007!\tC\u0003n[\u0001\u0007!\tC\u0003p[\u0001\u0007!\t\u0006\u0007\u0002\u0010\t%%1\u0012BG\u0005\u001f\u0013\t\nC\u0003k]\u0001\u0007!\tC\u0003n]\u0001\u0007!\tC\u0003p]\u0001\u0007!\tC\u0003r]\u0001\u00071\u000fC\u0004x]A\u0005\t\u0019A=\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIU\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u001a\n\u0005\u0006\u0003B-{\u00057\u0003\u0002\"\u0017BO\u0005\n\u00135/_\u0005\u0004\u0005?S&A\u0002+va2,W\u0007C\u0005\u0003$B\n\t\u00111\u0001\u0002\u0010\u0005\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011Y\u000b\u0005\u0003\u0002z\n5\u0016\u0002\u0002BX\u0003w\u0014aa\u00142kK\u000e$\b")
public class Uniform
extends Expression
implements RuntimeReplaceable,
TernaryLike<Expression>,
RDG,
ExpectsInputTypes,
TimeZoneAwareExpression,
Serializable {
    private boolean deterministic;
    private final Expression min;
    private final Expression max;
    private final Expression seedExpression;
    private final boolean hideSeed;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private transient XORShiftRandom rng;
    private transient long seed;
    private transient Seq<Expression> children;
    private Expression canonicalized;
    private volatile transient byte bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<String> $lessinit$greater$default$5() {
        return Uniform$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<Tuple5<Expression, Expression, Expression, Object, Option<String>>> unapply(Uniform x$0) {
        return Uniform$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$5() {
        return Uniform$.MODULE$.apply$default$5();
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    @Override
    public boolean stateful() {
        return RDG.stateful$(this);
    }

    @Override
    public boolean nullable() {
        return RDG.nullable$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        Uniform uniform = this;
        synchronized (uniform) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        Uniform uniform = this;
        synchronized (uniform) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public XORShiftRandom rng() {
        return this.rng;
    }

    @Override
    public void rng_$eq(XORShiftRandom x$1) {
        this.rng = x$1;
    }

    private long seed$lzycompute() {
        Uniform uniform = this;
        synchronized (uniform) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.seed = RDG.seed$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.seed;
    }

    @Override
    public long seed() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.seed$lzycompute();
        }
        return this.seed;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$ExpressionWithRandomSeed$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
    }

    private Seq<Expression> children$lzycompute() {
        Uniform uniform = this;
        synchronized (uniform) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    private Expression canonicalized$lzycompute() {
        Uniform uniform = this;
        synchronized (uniform) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
    }

    public Expression min() {
        return this.min;
    }

    public Expression max() {
        return this.max;
    }

    @Override
    public Expression seedExpression() {
        return this.seedExpression;
    }

    public boolean hideSeed() {
        return this.hideSeed;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    private boolean deterministic$lzycompute() {
        Uniform uniform = this;
        synchronized (uniform) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.deterministic = false;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.deterministic$lzycompute();
        }
        return this.deterministic;
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return new .colon.colon((Object)TreePattern$.MODULE$.RUNTIME_REPLACEABLE(), (List)new .colon.colon((Object)TreePattern$.MODULE$.EXPRESSION_WITH_RANDOM_SEED(), (List)Nil$.MODULE$));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        TypeCollection randomSeedTypes = TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegerType$.MODULE$, LongType$.MODULE$}));
        return new .colon.colon((Object)NumericType$.MODULE$, (List)new .colon.colon((Object)NumericType$.MODULE$, (List)new .colon.colon((Object)randomSeedTypes, (List)Nil$.MODULE$)));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public DataType dataType() {
        block20: {
            block19: {
                var4_1 = new Tuple2((Object)this.min().dataType(), (Object)this.max().dataType());
                if (!this.seedExpression().resolved()) break block19;
                v0 = this.seedExpression().dataType();
                var5_2 = NullType$.MODULE$;
                if (v0 != null ? v0.equals(var5_2) == false : var5_2 != null) break block20;
            }
            return NullType$.MODULE$;
        }
        if (var4_1 != null) {
            left = (DataType)var4_1._1();
            right = (DataType)var4_1._2();
            if (left instanceof IntegralType) {
                var8_5 = (IntegralType)left;
                if (right instanceof IntegralType) {
                    var9_6 = (IntegralType)right;
                    if (UpCastRule$.MODULE$.legalNumericPrecedence((DataType)var8_5, (DataType)var9_6)) {
                        return var9_6;
                    }
                    return var8_5;
                }
            }
        }
        if (var4_1 == null) ** GOTO lbl-1000
        var10_7 = (DataType)var4_1._2();
        if (var4_1._1() instanceof NumericType && DoubleType$.MODULE$.equals(var10_7)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = var4_1 != null && DoubleType$.MODULE$.equals(var11_8 = (DataType)var4_1._1()) != false && var4_1._2() instanceof NumericType != false;
        }
        if (v1) {
            return DoubleType$.MODULE$;
        }
        if (var4_1 == null) ** GOTO lbl-1000
        var12_9 = (DataType)var4_1._2();
        if (var4_1._1() instanceof NumericType && FloatType$.MODULE$.equals(var12_9)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = var4_1 != null && FloatType$.MODULE$.equals(var13_10 = (DataType)var4_1._1()) != false && var4_1._2() instanceof NumericType != false;
        }
        if (v2) {
            return FloatType$.MODULE$;
        }
        if (var4_1 != null) {
            lhs = (DataType)var4_1._1();
            rhs = (DataType)var4_1._2();
            if (lhs instanceof DecimalType) {
                var16_13 = (DecimalType)lhs;
                if (rhs instanceof DecimalType) {
                    var17_14 = (DecimalType)rhs;
                    if (var16_13.isWiderThan((DataType)var17_14)) {
                        return var16_13;
                    }
                    return var17_14;
                }
            }
        }
        if (var4_1 != null && (d = (DataType)var4_1._2()) instanceof DecimalType) {
            var19_16 = (DecimalType)d;
            return var19_16;
        }
        if (var4_1 != null && (d = (DataType)var4_1._1()) instanceof DecimalType) {
            var21_18 = (DecimalType)d;
            return var21_18;
        }
        throw SparkException$.MODULE$.internalError("Unexpected argument data types: " + this.min().dataType() + ", " + this.max().dataType());
    }

    @Override
    public String sql() {
        return "uniform(" + this.min().sql() + ", " + this.max().sql() + (this.hideSeed() ? "" : ", " + this.seedExpression().sql()) + ")";
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        ObjectRef result = ObjectRef.create((Object)ExpectsInputTypes.checkInputDataTypes$(this));
        new .colon.colon((Object)new Tuple2((Object)this.min(), (Object)"min"), (List)new .colon.colon((Object)new Tuple2((Object)this.max(), (Object)"max"), (List)new .colon.colon((Object)new Tuple2((Object)this.seedExpression(), (Object)"seed"), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)x0$1 -> {
            Uniform.$anonfun$checkInputDataTypes$1(result, x0$1);
            return BoxedUnit.UNIT;
        });
        return (TypeCheckResult)result.elem;
    }

    @Override
    public Expression first() {
        return this.min();
    }

    @Override
    public Expression second() {
        return this.max();
    }

    @Override
    public Expression third() {
        return this.seedExpression();
    }

    @Override
    public Expression withNewSeed(long newSeed) {
        return new Uniform(this.min(), this.max(), new Literal(BoxesRunTime.boxToLong((long)newSeed), (DataType)LongType$.MODULE$), this.hideSeed(), Uniform$.MODULE$.apply$default$5());
    }

    @Override
    public Expression withShiftedSeed(long shift) {
        return new Uniform(this.min(), this.max(), new Literal(BoxesRunTime.boxToLong((long)(this.seed() + shift)), (DataType)LongType$.MODULE$), this.hideSeed(), Uniform$.MODULE$.apply$default$5());
    }

    @Override
    public Expression withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return new Uniform(newFirst, newSecond, newThird, this.hideSeed(), Uniform$.MODULE$.apply$default$5());
    }

    @Override
    public Expression replacement() {
        if (new .colon.colon((Object)this.min(), (List)new .colon.colon((Object)this.max(), (List)new .colon.colon((Object)this.seedExpression(), (List)Nil$.MODULE$))).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Uniform.$anonfun$replacement$1(x$2)))) {
            return Literal$.MODULE$.apply(null);
        }
        return this.cast$1(new Add(this.cast$1(this.min(), (DataType)DoubleType$.MODULE$), new Multiply(new Subtract(this.cast$1(this.max(), (DataType)DoubleType$.MODULE$), this.cast$1(this.min(), (DataType)DoubleType$.MODULE$), Subtract$.MODULE$.apply$default$3()), Rand$.MODULE$.apply(this.seed()), Multiply$.MODULE$.apply$default$3()), Add$.MODULE$.apply$default$3()), this.dataType());
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Some x$1 = new Some((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        boolean x$5 = this.copy$default$4();
        return this.copy(x$2, x$3, x$4, x$5, (Option<String>)x$1);
    }

    public Uniform copy(Expression min, Expression max, Expression seedExpression, boolean hideSeed, Option<String> timeZoneId) {
        return new Uniform(min, max, seedExpression, hideSeed, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.min();
    }

    public Expression copy$default$2() {
        return this.max();
    }

    public Expression copy$default$3() {
        return this.seedExpression();
    }

    public boolean copy$default$4() {
        return this.hideSeed();
    }

    public Option<String> copy$default$5() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "Uniform";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.min();
            }
            case 1: {
                return this.max();
            }
            case 2: {
                return this.seedExpression();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.hideSeed());
            }
            case 4: {
                return this.timeZoneId();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Uniform;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "min";
            }
            case 1: {
                return "max";
            }
            case 2: {
                return "seedExpression";
            }
            case 3: {
                return "hideSeed";
            }
            case 4: {
                return "timeZoneId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Uniform)) return false;
        boolean bl = true;
        if (!bl) return false;
        Uniform uniform = (Uniform)x$1;
        if (this.hideSeed() != uniform.hideSeed()) return false;
        Expression expression = this.min();
        Expression expression2 = uniform.min();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.max();
        Expression expression4 = uniform.max();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.seedExpression();
        Expression expression6 = uniform.seedExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = uniform.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!uniform.canEqual(this)) return false;
        return true;
    }

    private static final String requiredType$1() {
        return "integer or floating-point";
    }

    public static final /* synthetic */ void $anonfun$checkInputDataTypes$1(ObjectRef result$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Expression expr = (Expression)tuple2._1();
            String name = (String)tuple2._2();
            if (expr != null) {
                Expression expression = expr;
                if (name != null) {
                    String string = name;
                    TypeCheckResult typeCheckResult = (TypeCheckResult)result$1.elem;
                    TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
                    if (!(typeCheckResult != null ? !typeCheckResult.equals(typeCheckResult$TypeCheckSuccess$) : typeCheckResult$TypeCheckSuccess$ != null) && !expression.foldable()) {
                        result$1.elem = new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)ExpectsInputTypes$.MODULE$.toSQLId(string)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Uniform.requiredType$1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)ExpectsInputTypes$.MODULE$.toSQLExpr(expression))}))));
                        return;
                    }
                    return;
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$replacement$1(Expression x$2) {
        DataType dataType = x$2.dataType();
        NullType$ nullType$ = NullType$.MODULE$;
        return !(dataType != null ? !dataType.equals(nullType$) : nullType$ != null);
    }

    private final Expression cast$1(Expression e, DataType to) {
        DataType dataType = e.dataType();
        DataType dataType2 = to;
        if (!(dataType != null ? !dataType.equals(dataType2) : dataType2 != null)) {
            return e;
        }
        return new Cast(e, to, this.timeZoneId(), Cast$.MODULE$.apply$default$4());
    }

    public Uniform(Expression min, Expression max, Expression seedExpression, boolean hideSeed, Option<String> timeZoneId) {
        this.min = min;
        this.max = max;
        this.seedExpression = seedExpression;
        this.hideSeed = hideSeed;
        this.timeZoneId = timeZoneId;
        RuntimeReplaceable.$init$(this);
        TernaryLike.$init$(this);
        ExpressionWithRandomSeed.$init$(this);
        RDG.$init$(this);
        ExpectsInputTypes.$init$(this);
        TimeZoneAwareExpression.$init$(this);
        Statics.releaseFence();
    }

    public Uniform(Expression min, Expression max) {
        this(min, max, UnresolvedSeed$.MODULE$, true, Uniform$.MODULE$.$lessinit$greater$default$5());
    }

    public Uniform(Expression min, Expression max, Expression seedExpression) {
        this(min, max, seedExpression, false, Uniform$.MODULE$.$lessinit$greater$default$5());
    }
}

