/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.AttachedVolume;
import io.fabric8.kubernetes.api.model.AttachedVolumeBuilder;
import io.fabric8.kubernetes.api.model.AttachedVolumeFluent;
import io.fabric8.kubernetes.api.model.ContainerImage;
import io.fabric8.kubernetes.api.model.ContainerImageBuilder;
import io.fabric8.kubernetes.api.model.ContainerImageFluent;
import io.fabric8.kubernetes.api.model.NodeAddress;
import io.fabric8.kubernetes.api.model.NodeAddressBuilder;
import io.fabric8.kubernetes.api.model.NodeAddressFluent;
import io.fabric8.kubernetes.api.model.NodeCondition;
import io.fabric8.kubernetes.api.model.NodeConditionBuilder;
import io.fabric8.kubernetes.api.model.NodeConditionFluent;
import io.fabric8.kubernetes.api.model.NodeConfigStatus;
import io.fabric8.kubernetes.api.model.NodeConfigStatusBuilder;
import io.fabric8.kubernetes.api.model.NodeConfigStatusFluent;
import io.fabric8.kubernetes.api.model.NodeDaemonEndpoints;
import io.fabric8.kubernetes.api.model.NodeDaemonEndpointsBuilder;
import io.fabric8.kubernetes.api.model.NodeDaemonEndpointsFluent;
import io.fabric8.kubernetes.api.model.NodeFeatures;
import io.fabric8.kubernetes.api.model.NodeFeaturesBuilder;
import io.fabric8.kubernetes.api.model.NodeFeaturesFluent;
import io.fabric8.kubernetes.api.model.NodeRuntimeHandler;
import io.fabric8.kubernetes.api.model.NodeRuntimeHandlerBuilder;
import io.fabric8.kubernetes.api.model.NodeRuntimeHandlerFluent;
import io.fabric8.kubernetes.api.model.NodeStatus;
import io.fabric8.kubernetes.api.model.NodeSystemInfo;
import io.fabric8.kubernetes.api.model.NodeSystemInfoBuilder;
import io.fabric8.kubernetes.api.model.NodeSystemInfoFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class NodeStatusFluent<A extends NodeStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<NodeAddressBuilder> addresses = new ArrayList();
    private Map<String, Quantity> allocatable;
    private Map<String, Quantity> capacity;
    private ArrayList<NodeConditionBuilder> conditions = new ArrayList();
    private NodeConfigStatusBuilder config;
    private NodeDaemonEndpointsBuilder daemonEndpoints;
    private NodeFeaturesBuilder features;
    private ArrayList<ContainerImageBuilder> images = new ArrayList();
    private NodeSystemInfoBuilder nodeInfo;
    private String phase;
    private ArrayList<NodeRuntimeHandlerBuilder> runtimeHandlers = new ArrayList();
    private ArrayList<AttachedVolumeBuilder> volumesAttached = new ArrayList();
    private List<String> volumesInUse = new ArrayList<String>();

    public NodeStatusFluent() {
    }

    public NodeStatusFluent(NodeStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToAddresses(Collection<NodeAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (NodeAddress item : items) {
            NodeAddressBuilder builder = new NodeAddressBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<NodeCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (NodeCondition item : items) {
            NodeConditionBuilder builder = new NodeConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToImages(Collection<ContainerImage> items) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        for (ContainerImage item : items) {
            ContainerImageBuilder builder = new ContainerImageBuilder(item);
            this._visitables.get((Object)"images").add(builder);
            this.images.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRuntimeHandlers(Collection<NodeRuntimeHandler> items) {
        if (this.runtimeHandlers == null) {
            this.runtimeHandlers = new ArrayList();
        }
        for (NodeRuntimeHandler item : items) {
            NodeRuntimeHandlerBuilder builder = new NodeRuntimeHandlerBuilder(item);
            this._visitables.get((Object)"runtimeHandlers").add(builder);
            this.runtimeHandlers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumesAttached(Collection<AttachedVolume> items) {
        if (this.volumesAttached == null) {
            this.volumesAttached = new ArrayList();
        }
        for (AttachedVolume item : items) {
            AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);
            this._visitables.get((Object)"volumesAttached").add(builder);
            this.volumesAttached.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumesInUse(Collection<String> items) {
        if (this.volumesInUse == null) {
            this.volumesInUse = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumesInUse.add(item);
        }
        return (A)((Object)this);
    }

    public AddressesNested<A> addNewAddress() {
        return new AddressesNested(-1, null);
    }

    public A addNewAddress(String address, String type) {
        return this.addToAddresses(new NodeAddress(address, type));
    }

    public AddressesNested<A> addNewAddressLike(NodeAddress item) {
        return new AddressesNested(-1, item);
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(NodeCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ImagesNested<A> addNewImage() {
        return new ImagesNested(-1, null);
    }

    public ImagesNested<A> addNewImageLike(ContainerImage item) {
        return new ImagesNested(-1, item);
    }

    public RuntimeHandlersNested<A> addNewRuntimeHandler() {
        return new RuntimeHandlersNested(-1, null);
    }

    public RuntimeHandlersNested<A> addNewRuntimeHandlerLike(NodeRuntimeHandler item) {
        return new RuntimeHandlersNested(-1, item);
    }

    public VolumesAttachedNested<A> addNewVolumesAttached() {
        return new VolumesAttachedNested(-1, null);
    }

    public A addNewVolumesAttached(String devicePath, String name) {
        return this.addToVolumesAttached(new AttachedVolume(devicePath, name));
    }

    public VolumesAttachedNested<A> addNewVolumesAttachedLike(AttachedVolume item) {
        return new VolumesAttachedNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(NodeAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (NodeAddress item : items) {
            NodeAddressBuilder builder = new NodeAddressBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(int index, NodeAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        NodeAddressBuilder builder = new NodeAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAllocatable(Map<String, Quantity> map) {
        if (this.allocatable == null && map != null) {
            this.allocatable = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.allocatable.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAllocatable(String key, Quantity value) {
        if (this.allocatable == null && key != null && value != null) {
            this.allocatable = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.allocatable.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToCapacity(Map<String, Quantity> map) {
        if (this.capacity == null && map != null) {
            this.capacity = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.capacity.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToCapacity(String key, Quantity value) {
        if (this.capacity == null && key != null && value != null) {
            this.capacity = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.capacity.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConditions(NodeCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (NodeCondition item : items) {
            NodeConditionBuilder builder = new NodeConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(int index, NodeCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        NodeConditionBuilder builder = new NodeConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToImages(ContainerImage ... items) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        for (ContainerImage item : items) {
            ContainerImageBuilder builder = new ContainerImageBuilder(item);
            this._visitables.get((Object)"images").add(builder);
            this.images.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToImages(int index, ContainerImage item) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        ContainerImageBuilder builder = new ContainerImageBuilder(item);
        if (index < 0 || index >= this.images.size()) {
            this._visitables.get((Object)"images").add(builder);
            this.images.add(builder);
        } else {
            this._visitables.get((Object)"images").add(builder);
            this.images.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRuntimeHandlers(NodeRuntimeHandler ... items) {
        if (this.runtimeHandlers == null) {
            this.runtimeHandlers = new ArrayList();
        }
        for (NodeRuntimeHandler item : items) {
            NodeRuntimeHandlerBuilder builder = new NodeRuntimeHandlerBuilder(item);
            this._visitables.get((Object)"runtimeHandlers").add(builder);
            this.runtimeHandlers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToRuntimeHandlers(int index, NodeRuntimeHandler item) {
        if (this.runtimeHandlers == null) {
            this.runtimeHandlers = new ArrayList();
        }
        NodeRuntimeHandlerBuilder builder = new NodeRuntimeHandlerBuilder(item);
        if (index < 0 || index >= this.runtimeHandlers.size()) {
            this._visitables.get((Object)"runtimeHandlers").add(builder);
            this.runtimeHandlers.add(builder);
        } else {
            this._visitables.get((Object)"runtimeHandlers").add(builder);
            this.runtimeHandlers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumesAttached(AttachedVolume ... items) {
        if (this.volumesAttached == null) {
            this.volumesAttached = new ArrayList();
        }
        for (AttachedVolume item : items) {
            AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);
            this._visitables.get((Object)"volumesAttached").add(builder);
            this.volumesAttached.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumesAttached(int index, AttachedVolume item) {
        if (this.volumesAttached == null) {
            this.volumesAttached = new ArrayList();
        }
        AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);
        if (index < 0 || index >= this.volumesAttached.size()) {
            this._visitables.get((Object)"volumesAttached").add(builder);
            this.volumesAttached.add(builder);
        } else {
            this._visitables.get((Object)"volumesAttached").add(builder);
            this.volumesAttached.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumesInUse(String ... items) {
        if (this.volumesInUse == null) {
            this.volumesInUse = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumesInUse.add(item);
        }
        return (A)((Object)this);
    }

    public A addToVolumesInUse(int index, String item) {
        if (this.volumesInUse == null) {
            this.volumesInUse = new ArrayList<String>();
        }
        this.volumesInUse.add(index, item);
        return (A)((Object)this);
    }

    public NodeAddress buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    public List<NodeAddress> buildAddresses() {
        return this.addresses != null ? NodeStatusFluent.build(this.addresses) : null;
    }

    public NodeCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public List<NodeCondition> buildConditions() {
        return this.conditions != null ? NodeStatusFluent.build(this.conditions) : null;
    }

    public NodeConfigStatus buildConfig() {
        return this.config != null ? this.config.build() : null;
    }

    public NodeDaemonEndpoints buildDaemonEndpoints() {
        return this.daemonEndpoints != null ? this.daemonEndpoints.build() : null;
    }

    public NodeFeatures buildFeatures() {
        return this.features != null ? this.features.build() : null;
    }

    public NodeAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    public NodeCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public ContainerImage buildFirstImage() {
        return this.images.get(0).build();
    }

    public NodeRuntimeHandler buildFirstRuntimeHandler() {
        return this.runtimeHandlers.get(0).build();
    }

    public AttachedVolume buildFirstVolumesAttached() {
        return this.volumesAttached.get(0).build();
    }

    public ContainerImage buildImage(int index) {
        return this.images.get(index).build();
    }

    public List<ContainerImage> buildImages() {
        return this.images != null ? NodeStatusFluent.build(this.images) : null;
    }

    public NodeAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    public NodeCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public ContainerImage buildLastImage() {
        return this.images.get(this.images.size() - 1).build();
    }

    public NodeRuntimeHandler buildLastRuntimeHandler() {
        return this.runtimeHandlers.get(this.runtimeHandlers.size() - 1).build();
    }

    public AttachedVolume buildLastVolumesAttached() {
        return this.volumesAttached.get(this.volumesAttached.size() - 1).build();
    }

    public NodeAddress buildMatchingAddress(Predicate<NodeAddressBuilder> predicate) {
        for (NodeAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public NodeCondition buildMatchingCondition(Predicate<NodeConditionBuilder> predicate) {
        for (NodeConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public ContainerImage buildMatchingImage(Predicate<ContainerImageBuilder> predicate) {
        for (ContainerImageBuilder item : this.images) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public NodeRuntimeHandler buildMatchingRuntimeHandler(Predicate<NodeRuntimeHandlerBuilder> predicate) {
        for (NodeRuntimeHandlerBuilder item : this.runtimeHandlers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public AttachedVolume buildMatchingVolumesAttached(Predicate<AttachedVolumeBuilder> predicate) {
        for (AttachedVolumeBuilder item : this.volumesAttached) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public NodeSystemInfo buildNodeInfo() {
        return this.nodeInfo != null ? this.nodeInfo.build() : null;
    }

    public NodeRuntimeHandler buildRuntimeHandler(int index) {
        return this.runtimeHandlers.get(index).build();
    }

    public List<NodeRuntimeHandler> buildRuntimeHandlers() {
        return this.runtimeHandlers != null ? NodeStatusFluent.build(this.runtimeHandlers) : null;
    }

    public List<AttachedVolume> buildVolumesAttached() {
        return this.volumesAttached != null ? NodeStatusFluent.build(this.volumesAttached) : null;
    }

    public AttachedVolume buildVolumesAttached(int index) {
        return this.volumesAttached.get(index).build();
    }

    protected void copyInstance(NodeStatus instance) {
        NodeStatus nodeStatus = instance = instance != null ? instance : new NodeStatus();
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withAllocatable(instance.getAllocatable());
            this.withCapacity(instance.getCapacity());
            this.withConditions(instance.getConditions());
            this.withConfig(instance.getConfig());
            this.withDaemonEndpoints(instance.getDaemonEndpoints());
            this.withFeatures(instance.getFeatures());
            this.withImages(instance.getImages());
            this.withNodeInfo(instance.getNodeInfo());
            this.withPhase(instance.getPhase());
            this.withRuntimeHandlers(instance.getRuntimeHandlers());
            this.withVolumesAttached(instance.getVolumesAttached());
            this.withVolumesInUse(instance.getVolumesInUse());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "addresses"));
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConfigNested<A> editConfig() {
        return this.withNewConfigLike(Optional.ofNullable(this.buildConfig()).orElse(null));
    }

    public DaemonEndpointsNested<A> editDaemonEndpoints() {
        return this.withNewDaemonEndpointsLike(Optional.ofNullable(this.buildDaemonEndpoints()).orElse(null));
    }

    public FeaturesNested<A> editFeatures() {
        return this.withNewFeaturesLike(Optional.ofNullable(this.buildFeatures()).orElse(null));
    }

    public AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "addresses"));
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ImagesNested<A> editFirstImage() {
        if (this.images.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "images"));
        }
        return this.setNewImageLike(0, this.buildImage(0));
    }

    public RuntimeHandlersNested<A> editFirstRuntimeHandler() {
        if (this.runtimeHandlers.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "runtimeHandlers"));
        }
        return this.setNewRuntimeHandlerLike(0, this.buildRuntimeHandler(0));
    }

    public VolumesAttachedNested<A> editFirstVolumesAttached() {
        if (this.volumesAttached.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "volumesAttached"));
        }
        return this.setNewVolumesAttachedLike(0, this.buildVolumesAttached(0));
    }

    public ImagesNested<A> editImage(int index) {
        if (this.images.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "images"));
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    public AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "addresses"));
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ImagesNested<A> editLastImage() {
        int index = this.images.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "images"));
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    public RuntimeHandlersNested<A> editLastRuntimeHandler() {
        int index = this.runtimeHandlers.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "runtimeHandlers"));
        }
        return this.setNewRuntimeHandlerLike(index, this.buildRuntimeHandler(index));
    }

    public VolumesAttachedNested<A> editLastVolumesAttached() {
        int index = this.volumesAttached.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "volumesAttached"));
        }
        return this.setNewVolumesAttachedLike(index, this.buildVolumesAttached(index));
    }

    public AddressesNested<A> editMatchingAddress(Predicate<NodeAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "addresses"));
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<NodeConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ImagesNested<A> editMatchingImage(Predicate<ContainerImageBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.images.size(); ++i) {
            if (!predicate.test(this.images.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "images"));
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    public RuntimeHandlersNested<A> editMatchingRuntimeHandler(Predicate<NodeRuntimeHandlerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.runtimeHandlers.size(); ++i) {
            if (!predicate.test(this.runtimeHandlers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "runtimeHandlers"));
        }
        return this.setNewRuntimeHandlerLike(index, this.buildRuntimeHandler(index));
    }

    public VolumesAttachedNested<A> editMatchingVolumesAttached(Predicate<AttachedVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumesAttached.size(); ++i) {
            if (!predicate.test(this.volumesAttached.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "volumesAttached"));
        }
        return this.setNewVolumesAttachedLike(index, this.buildVolumesAttached(index));
    }

    public NodeInfoNested<A> editNodeInfo() {
        return this.withNewNodeInfoLike(Optional.ofNullable(this.buildNodeInfo()).orElse(null));
    }

    public ConfigNested<A> editOrNewConfig() {
        return this.withNewConfigLike(Optional.ofNullable(this.buildConfig()).orElse(new NodeConfigStatusBuilder().build()));
    }

    public ConfigNested<A> editOrNewConfigLike(NodeConfigStatus item) {
        return this.withNewConfigLike(Optional.ofNullable(this.buildConfig()).orElse(item));
    }

    public DaemonEndpointsNested<A> editOrNewDaemonEndpoints() {
        return this.withNewDaemonEndpointsLike(Optional.ofNullable(this.buildDaemonEndpoints()).orElse(new NodeDaemonEndpointsBuilder().build()));
    }

    public DaemonEndpointsNested<A> editOrNewDaemonEndpointsLike(NodeDaemonEndpoints item) {
        return this.withNewDaemonEndpointsLike(Optional.ofNullable(this.buildDaemonEndpoints()).orElse(item));
    }

    public FeaturesNested<A> editOrNewFeatures() {
        return this.withNewFeaturesLike(Optional.ofNullable(this.buildFeatures()).orElse(new NodeFeaturesBuilder().build()));
    }

    public FeaturesNested<A> editOrNewFeaturesLike(NodeFeatures item) {
        return this.withNewFeaturesLike(Optional.ofNullable(this.buildFeatures()).orElse(item));
    }

    public NodeInfoNested<A> editOrNewNodeInfo() {
        return this.withNewNodeInfoLike(Optional.ofNullable(this.buildNodeInfo()).orElse(new NodeSystemInfoBuilder().build()));
    }

    public NodeInfoNested<A> editOrNewNodeInfoLike(NodeSystemInfo item) {
        return this.withNewNodeInfoLike(Optional.ofNullable(this.buildNodeInfo()).orElse(item));
    }

    public RuntimeHandlersNested<A> editRuntimeHandler(int index) {
        if (this.runtimeHandlers.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "runtimeHandlers"));
        }
        return this.setNewRuntimeHandlerLike(index, this.buildRuntimeHandler(index));
    }

    public VolumesAttachedNested<A> editVolumesAttached(int index) {
        if (this.volumesAttached.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "volumesAttached"));
        }
        return this.setNewVolumesAttachedLike(index, this.buildVolumesAttached(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeStatusFluent that = (NodeStatusFluent)((Object)o);
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.allocatable, that.allocatable)) {
            return false;
        }
        if (!Objects.equals(this.capacity, that.capacity)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals((Object)this.config, (Object)that.config)) {
            return false;
        }
        if (!Objects.equals((Object)this.daemonEndpoints, (Object)that.daemonEndpoints)) {
            return false;
        }
        if (!Objects.equals((Object)this.features, (Object)that.features)) {
            return false;
        }
        if (!Objects.equals(this.images, that.images)) {
            return false;
        }
        if (!Objects.equals((Object)this.nodeInfo, (Object)that.nodeInfo)) {
            return false;
        }
        if (!Objects.equals(this.phase, that.phase)) {
            return false;
        }
        if (!Objects.equals(this.runtimeHandlers, that.runtimeHandlers)) {
            return false;
        }
        if (!Objects.equals(this.volumesAttached, that.volumesAttached)) {
            return false;
        }
        if (!Objects.equals(this.volumesInUse, that.volumesInUse)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Map<String, Quantity> getAllocatable() {
        return this.allocatable;
    }

    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    public String getFirstVolumesInUse() {
        return this.volumesInUse.get(0);
    }

    public String getLastVolumesInUse() {
        return this.volumesInUse.get(this.volumesInUse.size() - 1);
    }

    public String getMatchingVolumesInUse(Predicate<String> predicate) {
        for (String item : this.volumesInUse) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getPhase() {
        return this.phase;
    }

    public List<String> getVolumesInUse() {
        return this.volumesInUse;
    }

    public String getVolumesInUse(int index) {
        return this.volumesInUse.get(index);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public boolean hasAllocatable() {
        return this.allocatable != null;
    }

    public boolean hasCapacity() {
        return this.capacity != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public boolean hasDaemonEndpoints() {
        return this.daemonEndpoints != null;
    }

    public boolean hasFeatures() {
        return this.features != null;
    }

    public boolean hasImages() {
        return this.images != null && !this.images.isEmpty();
    }

    public boolean hasMatchingAddress(Predicate<NodeAddressBuilder> predicate) {
        for (NodeAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingCondition(Predicate<NodeConditionBuilder> predicate) {
        for (NodeConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingImage(Predicate<ContainerImageBuilder> predicate) {
        for (ContainerImageBuilder item : this.images) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingRuntimeHandler(Predicate<NodeRuntimeHandlerBuilder> predicate) {
        for (NodeRuntimeHandlerBuilder item : this.runtimeHandlers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingVolumesAttached(Predicate<AttachedVolumeBuilder> predicate) {
        for (AttachedVolumeBuilder item : this.volumesAttached) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingVolumesInUse(Predicate<String> predicate) {
        for (String item : this.volumesInUse) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNodeInfo() {
        return this.nodeInfo != null;
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public boolean hasRuntimeHandlers() {
        return this.runtimeHandlers != null && !this.runtimeHandlers.isEmpty();
    }

    public boolean hasVolumesAttached() {
        return this.volumesAttached != null && !this.volumesAttached.isEmpty();
    }

    public boolean hasVolumesInUse() {
        return this.volumesInUse != null && !this.volumesInUse.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addresses, this.allocatable, this.capacity, this.conditions, this.config, this.daemonEndpoints, this.features, this.images, this.nodeInfo, this.phase, this.runtimeHandlers, this.volumesAttached, this.volumesInUse, this.additionalProperties});
    }

    public A removeAllFromAddresses(Collection<NodeAddress> items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (NodeAddress item : items) {
            NodeAddressBuilder builder = new NodeAddressBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<NodeCondition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (NodeCondition item : items) {
            NodeConditionBuilder builder = new NodeConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromImages(Collection<ContainerImage> items) {
        if (this.images == null) {
            return (A)((Object)this);
        }
        for (ContainerImage item : items) {
            ContainerImageBuilder builder = new ContainerImageBuilder(item);
            this._visitables.get((Object)"images").remove((Object)builder);
            this.images.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRuntimeHandlers(Collection<NodeRuntimeHandler> items) {
        if (this.runtimeHandlers == null) {
            return (A)((Object)this);
        }
        for (NodeRuntimeHandler item : items) {
            NodeRuntimeHandlerBuilder builder = new NodeRuntimeHandlerBuilder(item);
            this._visitables.get((Object)"runtimeHandlers").remove((Object)builder);
            this.runtimeHandlers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumesAttached(Collection<AttachedVolume> items) {
        if (this.volumesAttached == null) {
            return (A)((Object)this);
        }
        for (AttachedVolume item : items) {
            AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);
            this._visitables.get((Object)"volumesAttached").remove((Object)builder);
            this.volumesAttached.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumesInUse(Collection<String> items) {
        if (this.volumesInUse == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.volumesInUse.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromAddresses(NodeAddress ... items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (NodeAddress item : items) {
            NodeAddressBuilder builder = new NodeAddressBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAllocatable(String key) {
        if (this.allocatable == null) {
            return (A)((Object)this);
        }
        if (key != null && this.allocatable != null) {
            this.allocatable.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAllocatable(Map<String, Quantity> map) {
        if (this.allocatable == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.allocatable == null) continue;
                this.allocatable.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromCapacity(String key) {
        if (this.capacity == null) {
            return (A)((Object)this);
        }
        if (key != null && this.capacity != null) {
            this.capacity.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromCapacity(Map<String, Quantity> map) {
        if (this.capacity == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.capacity == null) continue;
                this.capacity.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(NodeCondition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (NodeCondition item : items) {
            NodeConditionBuilder builder = new NodeConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromImages(ContainerImage ... items) {
        if (this.images == null) {
            return (A)((Object)this);
        }
        for (ContainerImage item : items) {
            ContainerImageBuilder builder = new ContainerImageBuilder(item);
            this._visitables.get((Object)"images").remove((Object)builder);
            this.images.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRuntimeHandlers(NodeRuntimeHandler ... items) {
        if (this.runtimeHandlers == null) {
            return (A)((Object)this);
        }
        for (NodeRuntimeHandler item : items) {
            NodeRuntimeHandlerBuilder builder = new NodeRuntimeHandlerBuilder(item);
            this._visitables.get((Object)"runtimeHandlers").remove((Object)builder);
            this.runtimeHandlers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumesAttached(AttachedVolume ... items) {
        if (this.volumesAttached == null) {
            return (A)((Object)this);
        }
        for (AttachedVolume item : items) {
            AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);
            this._visitables.get((Object)"volumesAttached").remove((Object)builder);
            this.volumesAttached.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumesInUse(String ... items) {
        if (this.volumesInUse == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.volumesInUse.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAddresses(Predicate<NodeAddressBuilder> predicate) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        Iterator<NodeAddressBuilder> each = this.addresses.iterator();
        List visitables = this._visitables.get((Object)"addresses");
        while (each.hasNext()) {
            NodeAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<NodeConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<NodeConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            NodeConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromImages(Predicate<ContainerImageBuilder> predicate) {
        if (this.images == null) {
            return (A)((Object)this);
        }
        Iterator<ContainerImageBuilder> each = this.images.iterator();
        List visitables = this._visitables.get((Object)"images");
        while (each.hasNext()) {
            ContainerImageBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRuntimeHandlers(Predicate<NodeRuntimeHandlerBuilder> predicate) {
        if (this.runtimeHandlers == null) {
            return (A)((Object)this);
        }
        Iterator<NodeRuntimeHandlerBuilder> each = this.runtimeHandlers.iterator();
        List visitables = this._visitables.get((Object)"runtimeHandlers");
        while (each.hasNext()) {
            NodeRuntimeHandlerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromVolumesAttached(Predicate<AttachedVolumeBuilder> predicate) {
        if (this.volumesAttached == null) {
            return (A)((Object)this);
        }
        Iterator<AttachedVolumeBuilder> each = this.volumesAttached.iterator();
        List visitables = this._visitables.get((Object)"volumesAttached");
        while (each.hasNext()) {
            AttachedVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public AddressesNested<A> setNewAddressLike(int index, NodeAddress item) {
        return new AddressesNested(index, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, NodeCondition item) {
        return new ConditionsNested(index, item);
    }

    public ImagesNested<A> setNewImageLike(int index, ContainerImage item) {
        return new ImagesNested(index, item);
    }

    public RuntimeHandlersNested<A> setNewRuntimeHandlerLike(int index, NodeRuntimeHandler item) {
        return new RuntimeHandlersNested(index, item);
    }

    public VolumesAttachedNested<A> setNewVolumesAttachedLike(int index, AttachedVolume item) {
        return new VolumesAttachedNested(index, item);
    }

    public A setToAddresses(int index, NodeAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        NodeAddressBuilder builder = new NodeAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, NodeCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        NodeConditionBuilder builder = new NodeConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToImages(int index, ContainerImage item) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        ContainerImageBuilder builder = new ContainerImageBuilder(item);
        if (index < 0 || index >= this.images.size()) {
            this._visitables.get((Object)"images").add(builder);
            this.images.add(builder);
        } else {
            this._visitables.get((Object)"images").add(builder);
            this.images.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRuntimeHandlers(int index, NodeRuntimeHandler item) {
        if (this.runtimeHandlers == null) {
            this.runtimeHandlers = new ArrayList();
        }
        NodeRuntimeHandlerBuilder builder = new NodeRuntimeHandlerBuilder(item);
        if (index < 0 || index >= this.runtimeHandlers.size()) {
            this._visitables.get((Object)"runtimeHandlers").add(builder);
            this.runtimeHandlers.add(builder);
        } else {
            this._visitables.get((Object)"runtimeHandlers").add(builder);
            this.runtimeHandlers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToVolumesAttached(int index, AttachedVolume item) {
        if (this.volumesAttached == null) {
            this.volumesAttached = new ArrayList();
        }
        AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);
        if (index < 0 || index >= this.volumesAttached.size()) {
            this._visitables.get((Object)"volumesAttached").add(builder);
            this.volumesAttached.add(builder);
        } else {
            this._visitables.get((Object)"volumesAttached").add(builder);
            this.volumesAttached.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToVolumesInUse(int index, String item) {
        if (this.volumesInUse == null) {
            this.volumesInUse = new ArrayList<String>();
        }
        this.volumesInUse.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses);
            sb.append(",");
        }
        if (this.allocatable != null && !this.allocatable.isEmpty()) {
            sb.append("allocatable:");
            sb.append(this.allocatable);
            sb.append(",");
        }
        if (this.capacity != null && !this.capacity.isEmpty()) {
            sb.append("capacity:");
            sb.append(this.capacity);
            sb.append(",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.config != null) {
            sb.append("config:");
            sb.append((Object)this.config);
            sb.append(",");
        }
        if (this.daemonEndpoints != null) {
            sb.append("daemonEndpoints:");
            sb.append((Object)this.daemonEndpoints);
            sb.append(",");
        }
        if (this.features != null) {
            sb.append("features:");
            sb.append((Object)this.features);
            sb.append(",");
        }
        if (this.images != null && !this.images.isEmpty()) {
            sb.append("images:");
            sb.append(this.images);
            sb.append(",");
        }
        if (this.nodeInfo != null) {
            sb.append("nodeInfo:");
            sb.append((Object)this.nodeInfo);
            sb.append(",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase);
            sb.append(",");
        }
        if (this.runtimeHandlers != null && !this.runtimeHandlers.isEmpty()) {
            sb.append("runtimeHandlers:");
            sb.append(this.runtimeHandlers);
            sb.append(",");
        }
        if (this.volumesAttached != null && !this.volumesAttached.isEmpty()) {
            sb.append("volumesAttached:");
            sb.append(this.volumesAttached);
            sb.append(",");
        }
        if (this.volumesInUse != null && !this.volumesInUse.isEmpty()) {
            sb.append("volumesInUse:");
            sb.append(this.volumesInUse);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAddresses(List<NodeAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.get((Object)"addresses").clear();
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (NodeAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)((Object)this);
    }

    public A withAddresses(NodeAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove((Object)"addresses");
        }
        if (addresses != null) {
            for (NodeAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public <K, V> A withAllocatable(Map<String, Quantity> allocatable) {
        this.allocatable = allocatable == null ? null : new LinkedHashMap<String, Quantity>(allocatable);
        return (A)((Object)this);
    }

    public <K, V> A withCapacity(Map<String, Quantity> capacity) {
        this.capacity = capacity == null ? null : new LinkedHashMap<String, Quantity>(capacity);
        return (A)((Object)this);
    }

    public A withConditions(List<NodeCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (NodeCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(NodeCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (NodeCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withConfig(NodeConfigStatus config) {
        this._visitables.remove((Object)"config");
        if (config != null) {
            this.config = new NodeConfigStatusBuilder(config);
            this._visitables.get((Object)"config").add(this.config);
        } else {
            this.config = null;
            this._visitables.get((Object)"config").remove((Object)this.config);
        }
        return (A)((Object)this);
    }

    public A withDaemonEndpoints(NodeDaemonEndpoints daemonEndpoints) {
        this._visitables.remove((Object)"daemonEndpoints");
        if (daemonEndpoints != null) {
            this.daemonEndpoints = new NodeDaemonEndpointsBuilder(daemonEndpoints);
            this._visitables.get((Object)"daemonEndpoints").add(this.daemonEndpoints);
        } else {
            this.daemonEndpoints = null;
            this._visitables.get((Object)"daemonEndpoints").remove((Object)this.daemonEndpoints);
        }
        return (A)((Object)this);
    }

    public A withFeatures(NodeFeatures features) {
        this._visitables.remove((Object)"features");
        if (features != null) {
            this.features = new NodeFeaturesBuilder(features);
            this._visitables.get((Object)"features").add(this.features);
        } else {
            this.features = null;
            this._visitables.get((Object)"features").remove((Object)this.features);
        }
        return (A)((Object)this);
    }

    public A withImages(List<ContainerImage> images) {
        if (this.images != null) {
            this._visitables.get((Object)"images").clear();
        }
        if (images != null) {
            this.images = new ArrayList();
            for (ContainerImage item : images) {
                this.addToImages(item);
            }
        } else {
            this.images = null;
        }
        return (A)((Object)this);
    }

    public A withImages(ContainerImage ... images) {
        if (this.images != null) {
            this.images.clear();
            this._visitables.remove((Object)"images");
        }
        if (images != null) {
            for (ContainerImage item : images) {
                this.addToImages(item);
            }
        }
        return (A)((Object)this);
    }

    public ConfigNested<A> withNewConfig() {
        return new ConfigNested(null);
    }

    public ConfigNested<A> withNewConfigLike(NodeConfigStatus item) {
        return new ConfigNested(item);
    }

    public DaemonEndpointsNested<A> withNewDaemonEndpoints() {
        return new DaemonEndpointsNested(null);
    }

    public DaemonEndpointsNested<A> withNewDaemonEndpointsLike(NodeDaemonEndpoints item) {
        return new DaemonEndpointsNested(item);
    }

    public FeaturesNested<A> withNewFeatures() {
        return new FeaturesNested(null);
    }

    public A withNewFeatures(Boolean supplementalGroupsPolicy) {
        return this.withFeatures(new NodeFeatures(supplementalGroupsPolicy));
    }

    public FeaturesNested<A> withNewFeaturesLike(NodeFeatures item) {
        return new FeaturesNested(item);
    }

    public NodeInfoNested<A> withNewNodeInfo() {
        return new NodeInfoNested(null);
    }

    public NodeInfoNested<A> withNewNodeInfoLike(NodeSystemInfo item) {
        return new NodeInfoNested(item);
    }

    public A withNodeInfo(NodeSystemInfo nodeInfo) {
        this._visitables.remove((Object)"nodeInfo");
        if (nodeInfo != null) {
            this.nodeInfo = new NodeSystemInfoBuilder(nodeInfo);
            this._visitables.get((Object)"nodeInfo").add(this.nodeInfo);
        } else {
            this.nodeInfo = null;
            this._visitables.get((Object)"nodeInfo").remove((Object)this.nodeInfo);
        }
        return (A)((Object)this);
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)((Object)this);
    }

    public A withRuntimeHandlers(List<NodeRuntimeHandler> runtimeHandlers) {
        if (this.runtimeHandlers != null) {
            this._visitables.get((Object)"runtimeHandlers").clear();
        }
        if (runtimeHandlers != null) {
            this.runtimeHandlers = new ArrayList();
            for (NodeRuntimeHandler item : runtimeHandlers) {
                this.addToRuntimeHandlers(item);
            }
        } else {
            this.runtimeHandlers = null;
        }
        return (A)((Object)this);
    }

    public A withRuntimeHandlers(NodeRuntimeHandler ... runtimeHandlers) {
        if (this.runtimeHandlers != null) {
            this.runtimeHandlers.clear();
            this._visitables.remove((Object)"runtimeHandlers");
        }
        if (runtimeHandlers != null) {
            for (NodeRuntimeHandler item : runtimeHandlers) {
                this.addToRuntimeHandlers(item);
            }
        }
        return (A)((Object)this);
    }

    public A withVolumesAttached(List<AttachedVolume> volumesAttached) {
        if (this.volumesAttached != null) {
            this._visitables.get((Object)"volumesAttached").clear();
        }
        if (volumesAttached != null) {
            this.volumesAttached = new ArrayList();
            for (AttachedVolume item : volumesAttached) {
                this.addToVolumesAttached(item);
            }
        } else {
            this.volumesAttached = null;
        }
        return (A)((Object)this);
    }

    public A withVolumesAttached(AttachedVolume ... volumesAttached) {
        if (this.volumesAttached != null) {
            this.volumesAttached.clear();
            this._visitables.remove((Object)"volumesAttached");
        }
        if (volumesAttached != null) {
            for (AttachedVolume item : volumesAttached) {
                this.addToVolumesAttached(item);
            }
        }
        return (A)((Object)this);
    }

    public A withVolumesInUse(List<String> volumesInUse) {
        if (volumesInUse != null) {
            this.volumesInUse = new ArrayList<String>();
            for (String item : volumesInUse) {
                this.addToVolumesInUse(item);
            }
        } else {
            this.volumesInUse = null;
        }
        return (A)((Object)this);
    }

    public A withVolumesInUse(String ... volumesInUse) {
        if (this.volumesInUse != null) {
            this.volumesInUse.clear();
            this._visitables.remove((Object)"volumesInUse");
        }
        if (volumesInUse != null) {
            for (String item : volumesInUse) {
                this.addToVolumesInUse(item);
            }
        }
        return (A)((Object)this);
    }

    public class VolumesAttachedNested<N>
    extends AttachedVolumeFluent<VolumesAttachedNested<N>>
    implements Nested<N> {
        AttachedVolumeBuilder builder;
        int index;

        VolumesAttachedNested(int index, AttachedVolume item) {
            this.index = index;
            this.builder = new AttachedVolumeBuilder(this, item);
        }

        public N and() {
            return (N)NodeStatusFluent.this.setToVolumesAttached(this.index, this.builder.build());
        }

        public N endVolumesAttached() {
            return this.and();
        }
    }

    public class RuntimeHandlersNested<N>
    extends NodeRuntimeHandlerFluent<RuntimeHandlersNested<N>>
    implements Nested<N> {
        NodeRuntimeHandlerBuilder builder;
        int index;

        RuntimeHandlersNested(int index, NodeRuntimeHandler item) {
            this.index = index;
            this.builder = new NodeRuntimeHandlerBuilder(this, item);
        }

        public N and() {
            return (N)NodeStatusFluent.this.setToRuntimeHandlers(this.index, this.builder.build());
        }

        public N endRuntimeHandler() {
            return this.and();
        }
    }

    public class NodeInfoNested<N>
    extends NodeSystemInfoFluent<NodeInfoNested<N>>
    implements Nested<N> {
        NodeSystemInfoBuilder builder;

        NodeInfoNested(NodeSystemInfo item) {
            this.builder = new NodeSystemInfoBuilder(this, item);
        }

        public N and() {
            return (N)NodeStatusFluent.this.withNodeInfo(this.builder.build());
        }

        public N endNodeInfo() {
            return this.and();
        }
    }

    public class ImagesNested<N>
    extends ContainerImageFluent<ImagesNested<N>>
    implements Nested<N> {
        ContainerImageBuilder builder;
        int index;

        ImagesNested(int index, ContainerImage item) {
            this.index = index;
            this.builder = new ContainerImageBuilder(this, item);
        }

        public N and() {
            return (N)NodeStatusFluent.this.setToImages(this.index, this.builder.build());
        }

        public N endImage() {
            return this.and();
        }
    }

    public class FeaturesNested<N>
    extends NodeFeaturesFluent<FeaturesNested<N>>
    implements Nested<N> {
        NodeFeaturesBuilder builder;

        FeaturesNested(NodeFeatures item) {
            this.builder = new NodeFeaturesBuilder(this, item);
        }

        public N and() {
            return (N)NodeStatusFluent.this.withFeatures(this.builder.build());
        }

        public N endFeatures() {
            return this.and();
        }
    }

    public class DaemonEndpointsNested<N>
    extends NodeDaemonEndpointsFluent<DaemonEndpointsNested<N>>
    implements Nested<N> {
        NodeDaemonEndpointsBuilder builder;

        DaemonEndpointsNested(NodeDaemonEndpoints item) {
            this.builder = new NodeDaemonEndpointsBuilder(this, item);
        }

        public N and() {
            return (N)NodeStatusFluent.this.withDaemonEndpoints(this.builder.build());
        }

        public N endDaemonEndpoints() {
            return this.and();
        }
    }

    public class ConfigNested<N>
    extends NodeConfigStatusFluent<ConfigNested<N>>
    implements Nested<N> {
        NodeConfigStatusBuilder builder;

        ConfigNested(NodeConfigStatus item) {
            this.builder = new NodeConfigStatusBuilder(this, item);
        }

        public N and() {
            return (N)NodeStatusFluent.this.withConfig(this.builder.build());
        }

        public N endConfig() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends NodeConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        NodeConditionBuilder builder;
        int index;

        ConditionsNested(int index, NodeCondition item) {
            this.index = index;
            this.builder = new NodeConditionBuilder(this, item);
        }

        public N and() {
            return (N)NodeStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class AddressesNested<N>
    extends NodeAddressFluent<AddressesNested<N>>
    implements Nested<N> {
        NodeAddressBuilder builder;
        int index;

        AddressesNested(int index, NodeAddress item) {
            this.index = index;
            this.builder = new NodeAddressBuilder(this, item);
        }

        public N and() {
            return (N)NodeStatusFluent.this.setToAddresses(this.index, this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }
}

