/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.BitSet;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.rdbms.mapping.MappingCallbacks;
import org.datanucleus.store.rdbms.mapping.datastore.BlobImpl;
import org.datanucleus.store.rdbms.mapping.datastore.OracleBlobRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.java.BitSetMapping;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.TypeConversionHelper;

public class OracleBitSetMapping
extends BitSetMapping
implements MappingCallbacks {
    @Override
    public void insertPostProcessing(ObjectProvider op) {
        Object value = op.provideField(this.mmd.getAbsoluteFieldNumber());
        if (value == null) {
            return;
        }
        byte[] bytes = new byte[]{};
        try {
            if (this.mmd.isSerialized()) {
                if (!(value instanceof Serializable)) {
                    throw new NucleusDataStoreException(Localiser.msg((String)"055005", (Object[])new Object[]{value.getClass().getName()}));
                }
                BlobImpl b = new BlobImpl(value);
                bytes = b.getBytes(0L, (int)b.length());
            } else if (value instanceof BitSet) {
                bytes = TypeConversionHelper.getByteArrayFromBooleanArray((Object)TypeConversionHelper.getBooleanArrayFromBitSet((BitSet)((BitSet)value)));
            } else {
                if (!(value instanceof Serializable)) {
                    throw new NucleusDataStoreException(Localiser.msg((String)"055005", (Object[])new Object[]{value.getClass().getName()}));
                }
                BlobImpl b = new BlobImpl(value);
                bytes = b.getBytes(0L, (int)b.length());
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"Object", "" + value, this.mmd, e.getMessage()}), (Throwable)e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        OracleBlobRDBMSMapping.updateBlobColumn(op, this.getTable(), this.getDatastoreMapping(0), bytes);
    }

    @Override
    public void postInsert(ObjectProvider op) {
    }

    @Override
    public void postUpdate(ObjectProvider op) {
        this.insertPostProcessing(op);
    }

    public void deleteDependent(ObjectProvider op) {
    }

    @Override
    public void postFetch(ObjectProvider op) {
    }

    @Override
    public void preDelete(ObjectProvider op) {
    }
}

