// DO NOT EDIT.
// swift-format-ignore-file
// swiftlint:disable all
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: spark/connect/commands.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

//
// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import Foundation
import SwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: SwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: SwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

/// The enum used for client side streaming query listener event
/// There is no QueryStartedEvent defined here,
/// it is added as a field in WriteStreamOperationStartResult
enum Spark_Connect_StreamingQueryEventType: SwiftProtobuf.Enum, Swift.CaseIterable {
  typealias RawValue = Int
  case queryProgressUnspecified // = 0
  case queryProgressEvent // = 1
  case queryTerminatedEvent // = 2
  case queryIdleEvent // = 3
  case UNRECOGNIZED(Int)

  init() {
    self = .queryProgressUnspecified
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .queryProgressUnspecified
    case 1: self = .queryProgressEvent
    case 2: self = .queryTerminatedEvent
    case 3: self = .queryIdleEvent
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .queryProgressUnspecified: return 0
    case .queryProgressEvent: return 1
    case .queryTerminatedEvent: return 2
    case .queryIdleEvent: return 3
    case .UNRECOGNIZED(let i): return i
    }
  }

  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static let allCases: [Spark_Connect_StreamingQueryEventType] = [
    .queryProgressUnspecified,
    .queryProgressEvent,
    .queryTerminatedEvent,
    .queryIdleEvent,
  ]

}

/// A [[Command]] is an operation that is executed by the server that does not directly consume or
/// produce a relational result.
struct Spark_Connect_Command: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var commandType: Spark_Connect_Command.OneOf_CommandType? = nil

  var registerFunction: Spark_Connect_CommonInlineUserDefinedFunction {
    get {
      if case .registerFunction(let v)? = commandType {return v}
      return Spark_Connect_CommonInlineUserDefinedFunction()
    }
    set {commandType = .registerFunction(newValue)}
  }

  var writeOperation: Spark_Connect_WriteOperation {
    get {
      if case .writeOperation(let v)? = commandType {return v}
      return Spark_Connect_WriteOperation()
    }
    set {commandType = .writeOperation(newValue)}
  }

  var createDataframeView: Spark_Connect_CreateDataFrameViewCommand {
    get {
      if case .createDataframeView(let v)? = commandType {return v}
      return Spark_Connect_CreateDataFrameViewCommand()
    }
    set {commandType = .createDataframeView(newValue)}
  }

  var writeOperationV2: Spark_Connect_WriteOperationV2 {
    get {
      if case .writeOperationV2(let v)? = commandType {return v}
      return Spark_Connect_WriteOperationV2()
    }
    set {commandType = .writeOperationV2(newValue)}
  }

  var sqlCommand: Spark_Connect_SqlCommand {
    get {
      if case .sqlCommand(let v)? = commandType {return v}
      return Spark_Connect_SqlCommand()
    }
    set {commandType = .sqlCommand(newValue)}
  }

  var writeStreamOperationStart: Spark_Connect_WriteStreamOperationStart {
    get {
      if case .writeStreamOperationStart(let v)? = commandType {return v}
      return Spark_Connect_WriteStreamOperationStart()
    }
    set {commandType = .writeStreamOperationStart(newValue)}
  }

  var streamingQueryCommand: Spark_Connect_StreamingQueryCommand {
    get {
      if case .streamingQueryCommand(let v)? = commandType {return v}
      return Spark_Connect_StreamingQueryCommand()
    }
    set {commandType = .streamingQueryCommand(newValue)}
  }

  var getResourcesCommand: Spark_Connect_GetResourcesCommand {
    get {
      if case .getResourcesCommand(let v)? = commandType {return v}
      return Spark_Connect_GetResourcesCommand()
    }
    set {commandType = .getResourcesCommand(newValue)}
  }

  var streamingQueryManagerCommand: Spark_Connect_StreamingQueryManagerCommand {
    get {
      if case .streamingQueryManagerCommand(let v)? = commandType {return v}
      return Spark_Connect_StreamingQueryManagerCommand()
    }
    set {commandType = .streamingQueryManagerCommand(newValue)}
  }

  var registerTableFunction: Spark_Connect_CommonInlineUserDefinedTableFunction {
    get {
      if case .registerTableFunction(let v)? = commandType {return v}
      return Spark_Connect_CommonInlineUserDefinedTableFunction()
    }
    set {commandType = .registerTableFunction(newValue)}
  }

  var streamingQueryListenerBusCommand: Spark_Connect_StreamingQueryListenerBusCommand {
    get {
      if case .streamingQueryListenerBusCommand(let v)? = commandType {return v}
      return Spark_Connect_StreamingQueryListenerBusCommand()
    }
    set {commandType = .streamingQueryListenerBusCommand(newValue)}
  }

  var registerDataSource: Spark_Connect_CommonInlineUserDefinedDataSource {
    get {
      if case .registerDataSource(let v)? = commandType {return v}
      return Spark_Connect_CommonInlineUserDefinedDataSource()
    }
    set {commandType = .registerDataSource(newValue)}
  }

  var createResourceProfileCommand: Spark_Connect_CreateResourceProfileCommand {
    get {
      if case .createResourceProfileCommand(let v)? = commandType {return v}
      return Spark_Connect_CreateResourceProfileCommand()
    }
    set {commandType = .createResourceProfileCommand(newValue)}
  }

  var checkpointCommand: Spark_Connect_CheckpointCommand {
    get {
      if case .checkpointCommand(let v)? = commandType {return v}
      return Spark_Connect_CheckpointCommand()
    }
    set {commandType = .checkpointCommand(newValue)}
  }

  var removeCachedRemoteRelationCommand: Spark_Connect_RemoveCachedRemoteRelationCommand {
    get {
      if case .removeCachedRemoteRelationCommand(let v)? = commandType {return v}
      return Spark_Connect_RemoveCachedRemoteRelationCommand()
    }
    set {commandType = .removeCachedRemoteRelationCommand(newValue)}
  }

  var mergeIntoTableCommand: Spark_Connect_MergeIntoTableCommand {
    get {
      if case .mergeIntoTableCommand(let v)? = commandType {return v}
      return Spark_Connect_MergeIntoTableCommand()
    }
    set {commandType = .mergeIntoTableCommand(newValue)}
  }

  var mlCommand: Spark_Connect_MlCommand {
    get {
      if case .mlCommand(let v)? = commandType {return v}
      return Spark_Connect_MlCommand()
    }
    set {commandType = .mlCommand(newValue)}
  }

  var executeExternalCommand: Spark_Connect_ExecuteExternalCommand {
    get {
      if case .executeExternalCommand(let v)? = commandType {return v}
      return Spark_Connect_ExecuteExternalCommand()
    }
    set {commandType = .executeExternalCommand(newValue)}
  }

  var pipelineCommand: Spark_Connect_PipelineCommand {
    get {
      if case .pipelineCommand(let v)? = commandType {return v}
      return Spark_Connect_PipelineCommand()
    }
    set {commandType = .pipelineCommand(newValue)}
  }

  /// This field is used to mark extensions to the protocol. When plugins generate arbitrary
  /// Commands they can add them here. During the planning the correct resolution is done.
  var `extension`: SwiftProtobuf.Google_Protobuf_Any {
    get {
      if case .extension(let v)? = commandType {return v}
      return SwiftProtobuf.Google_Protobuf_Any()
    }
    set {commandType = .extension(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_CommandType: Equatable, Sendable {
    case registerFunction(Spark_Connect_CommonInlineUserDefinedFunction)
    case writeOperation(Spark_Connect_WriteOperation)
    case createDataframeView(Spark_Connect_CreateDataFrameViewCommand)
    case writeOperationV2(Spark_Connect_WriteOperationV2)
    case sqlCommand(Spark_Connect_SqlCommand)
    case writeStreamOperationStart(Spark_Connect_WriteStreamOperationStart)
    case streamingQueryCommand(Spark_Connect_StreamingQueryCommand)
    case getResourcesCommand(Spark_Connect_GetResourcesCommand)
    case streamingQueryManagerCommand(Spark_Connect_StreamingQueryManagerCommand)
    case registerTableFunction(Spark_Connect_CommonInlineUserDefinedTableFunction)
    case streamingQueryListenerBusCommand(Spark_Connect_StreamingQueryListenerBusCommand)
    case registerDataSource(Spark_Connect_CommonInlineUserDefinedDataSource)
    case createResourceProfileCommand(Spark_Connect_CreateResourceProfileCommand)
    case checkpointCommand(Spark_Connect_CheckpointCommand)
    case removeCachedRemoteRelationCommand(Spark_Connect_RemoveCachedRemoteRelationCommand)
    case mergeIntoTableCommand(Spark_Connect_MergeIntoTableCommand)
    case mlCommand(Spark_Connect_MlCommand)
    case executeExternalCommand(Spark_Connect_ExecuteExternalCommand)
    case pipelineCommand(Spark_Connect_PipelineCommand)
    /// This field is used to mark extensions to the protocol. When plugins generate arbitrary
    /// Commands they can add them here. During the planning the correct resolution is done.
    case `extension`(SwiftProtobuf.Google_Protobuf_Any)

  }

  init() {}
}

/// A SQL Command is used to trigger the eager evaluation of SQL commands in Spark.
///
/// When the SQL provide as part of the message is a command it will be immediately evaluated
/// and the result will be collected and returned as part of a LocalRelation. If the result is
/// not a command, the operation will simply return a SQL Relation. This allows the client to be
/// almost oblivious to the server-side behavior.
struct Spark_Connect_SqlCommand: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) SQL Query.
  ///
  /// NOTE: This field was marked as deprecated in the .proto file.
  var sql: String = String()

  /// (Optional) A map of parameter names to literal expressions.
  ///
  /// NOTE: This field was marked as deprecated in the .proto file.
  var args: Dictionary<String,Spark_Connect_Expression.Literal> = [:]

  /// (Optional) A sequence of literal expressions for positional parameters in the SQL query text.
  ///
  /// NOTE: This field was marked as deprecated in the .proto file.
  var posArgs: [Spark_Connect_Expression.Literal] = []

  /// (Optional) A map of parameter names to expressions.
  /// It cannot coexist with `pos_arguments`.
  ///
  /// NOTE: This field was marked as deprecated in the .proto file.
  var namedArguments: Dictionary<String,Spark_Connect_Expression> = [:]

  /// (Optional) A sequence of expressions for positional parameters in the SQL query text.
  /// It cannot coexist with `named_arguments`.
  ///
  /// NOTE: This field was marked as deprecated in the .proto file.
  var posArguments: [Spark_Connect_Expression] = []

  /// (Optional) The relation that this SQL command will be built on.
  var input: Spark_Connect_Relation {
    get {return _input ?? Spark_Connect_Relation()}
    set {_input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return self._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {self._input = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _input: Spark_Connect_Relation? = nil
}

/// A command that can create DataFrame global temp view or local temp view.
struct Spark_Connect_CreateDataFrameViewCommand: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The relation that this view will be built on.
  var input: Spark_Connect_Relation {
    get {return _input ?? Spark_Connect_Relation()}
    set {_input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return self._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {self._input = nil}

  /// (Required) View name.
  var name: String = String()

  /// (Required) Whether this is global temp view or local temp view.
  var isGlobal: Bool = false

  /// (Required)
  ///
  /// If true, and if the view already exists, updates it; if false, and if the view
  /// already exists, throws exception.
  var replace: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _input: Spark_Connect_Relation? = nil
}

/// As writes are not directly handled during analysis and planning, they are modeled as commands.
struct Spark_Connect_WriteOperation: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The output of the `input` relation will be persisted according to the options.
  var input: Spark_Connect_Relation {
    get {return _input ?? Spark_Connect_Relation()}
    set {_input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return self._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {self._input = nil}

  /// (Optional) Format value according to the Spark documentation. Examples are: text, parquet, delta.
  var source: String {
    get {return _source ?? String()}
    set {_source = newValue}
  }
  /// Returns true if `source` has been explicitly set.
  var hasSource: Bool {return self._source != nil}
  /// Clears the value of `source`. Subsequent reads from it will return its default value.
  mutating func clearSource() {self._source = nil}

  /// (Optional)
  ///
  /// The destination of the write operation can be either a path or a table.
  /// If the destination is neither a path nor a table, such as jdbc and noop,
  /// the `save_type` should not be set.
  var saveType: Spark_Connect_WriteOperation.OneOf_SaveType? = nil

  var path: String {
    get {
      if case .path(let v)? = saveType {return v}
      return String()
    }
    set {saveType = .path(newValue)}
  }

  var table: Spark_Connect_WriteOperation.SaveTable {
    get {
      if case .table(let v)? = saveType {return v}
      return Spark_Connect_WriteOperation.SaveTable()
    }
    set {saveType = .table(newValue)}
  }

  /// (Required) the save mode.
  var mode: Spark_Connect_WriteOperation.SaveMode = .unspecified

  /// (Optional) List of columns to sort the output by.
  var sortColumnNames: [String] = []

  /// (Optional) List of columns for partitioning.
  var partitioningColumns: [String] = []

  /// (Optional) Bucketing specification. Bucketing must set the number of buckets and the columns
  /// to bucket by.
  var bucketBy: Spark_Connect_WriteOperation.BucketBy {
    get {return _bucketBy ?? Spark_Connect_WriteOperation.BucketBy()}
    set {_bucketBy = newValue}
  }
  /// Returns true if `bucketBy` has been explicitly set.
  var hasBucketBy: Bool {return self._bucketBy != nil}
  /// Clears the value of `bucketBy`. Subsequent reads from it will return its default value.
  mutating func clearBucketBy() {self._bucketBy = nil}

  /// (Optional) A list of configuration options.
  var options: Dictionary<String,String> = [:]

  /// (Optional) Columns used for clustering the table.
  var clusteringColumns: [String] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  /// (Optional)
  ///
  /// The destination of the write operation can be either a path or a table.
  /// If the destination is neither a path nor a table, such as jdbc and noop,
  /// the `save_type` should not be set.
  enum OneOf_SaveType: Equatable, Sendable {
    case path(String)
    case table(Spark_Connect_WriteOperation.SaveTable)

  }

  enum SaveMode: SwiftProtobuf.Enum, Swift.CaseIterable {
    typealias RawValue = Int
    case unspecified // = 0
    case append // = 1
    case overwrite // = 2
    case errorIfExists // = 3
    case ignore // = 4
    case UNRECOGNIZED(Int)

    init() {
      self = .unspecified
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .unspecified
      case 1: self = .append
      case 2: self = .overwrite
      case 3: self = .errorIfExists
      case 4: self = .ignore
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .unspecified: return 0
      case .append: return 1
      case .overwrite: return 2
      case .errorIfExists: return 3
      case .ignore: return 4
      case .UNRECOGNIZED(let i): return i
      }
    }

    // The compiler won't synthesize support with the UNRECOGNIZED case.
    static let allCases: [Spark_Connect_WriteOperation.SaveMode] = [
      .unspecified,
      .append,
      .overwrite,
      .errorIfExists,
      .ignore,
    ]

  }

  struct SaveTable: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The table name.
    var tableName: String = String()

    /// (Required) The method to be called to write to the table.
    var saveMethod: Spark_Connect_WriteOperation.SaveTable.TableSaveMethod = .unspecified

    var unknownFields = SwiftProtobuf.UnknownStorage()

    enum TableSaveMethod: SwiftProtobuf.Enum, Swift.CaseIterable {
      typealias RawValue = Int
      case unspecified // = 0
      case saveAsTable // = 1
      case insertInto // = 2
      case UNRECOGNIZED(Int)

      init() {
        self = .unspecified
      }

      init?(rawValue: Int) {
        switch rawValue {
        case 0: self = .unspecified
        case 1: self = .saveAsTable
        case 2: self = .insertInto
        default: self = .UNRECOGNIZED(rawValue)
        }
      }

      var rawValue: Int {
        switch self {
        case .unspecified: return 0
        case .saveAsTable: return 1
        case .insertInto: return 2
        case .UNRECOGNIZED(let i): return i
        }
      }

      // The compiler won't synthesize support with the UNRECOGNIZED case.
      static let allCases: [Spark_Connect_WriteOperation.SaveTable.TableSaveMethod] = [
        .unspecified,
        .saveAsTable,
        .insertInto,
      ]

    }

    init() {}
  }

  struct BucketBy: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var bucketColumnNames: [String] = []

    var numBuckets: Int32 = 0

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}

  fileprivate var _input: Spark_Connect_Relation? = nil
  fileprivate var _source: String? = nil
  fileprivate var _bucketBy: Spark_Connect_WriteOperation.BucketBy? = nil
}

/// As writes are not directly handled during analysis and planning, they are modeled as commands.
struct Spark_Connect_WriteOperationV2: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The output of the `input` relation will be persisted according to the options.
  var input: Spark_Connect_Relation {
    get {return _input ?? Spark_Connect_Relation()}
    set {_input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return self._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {self._input = nil}

  /// (Required) The destination of the write operation must be either a path or a table.
  var tableName: String = String()

  /// (Optional) A provider for the underlying output data source. Spark's default catalog supports
  /// "parquet", "json", etc.
  var provider: String {
    get {return _provider ?? String()}
    set {_provider = newValue}
  }
  /// Returns true if `provider` has been explicitly set.
  var hasProvider: Bool {return self._provider != nil}
  /// Clears the value of `provider`. Subsequent reads from it will return its default value.
  mutating func clearProvider() {self._provider = nil}

  /// (Optional) List of columns for partitioning for output table created by `create`,
  /// `createOrReplace`, or `replace`
  var partitioningColumns: [Spark_Connect_Expression] = []

  /// (Optional) A list of configuration options.
  var options: Dictionary<String,String> = [:]

  /// (Optional) A list of table properties.
  var tableProperties: Dictionary<String,String> = [:]

  /// (Required) Write mode.
  var mode: Spark_Connect_WriteOperationV2.Mode = .unspecified

  /// (Optional) A condition for overwrite saving mode
  var overwriteCondition: Spark_Connect_Expression {
    get {return _overwriteCondition ?? Spark_Connect_Expression()}
    set {_overwriteCondition = newValue}
  }
  /// Returns true if `overwriteCondition` has been explicitly set.
  var hasOverwriteCondition: Bool {return self._overwriteCondition != nil}
  /// Clears the value of `overwriteCondition`. Subsequent reads from it will return its default value.
  mutating func clearOverwriteCondition() {self._overwriteCondition = nil}

  /// (Optional) Columns used for clustering the table.
  var clusteringColumns: [String] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum Mode: SwiftProtobuf.Enum, Swift.CaseIterable {
    typealias RawValue = Int
    case unspecified // = 0
    case create // = 1
    case overwrite // = 2
    case overwritePartitions // = 3
    case append // = 4
    case replace // = 5
    case createOrReplace // = 6
    case UNRECOGNIZED(Int)

    init() {
      self = .unspecified
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .unspecified
      case 1: self = .create
      case 2: self = .overwrite
      case 3: self = .overwritePartitions
      case 4: self = .append
      case 5: self = .replace
      case 6: self = .createOrReplace
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .unspecified: return 0
      case .create: return 1
      case .overwrite: return 2
      case .overwritePartitions: return 3
      case .append: return 4
      case .replace: return 5
      case .createOrReplace: return 6
      case .UNRECOGNIZED(let i): return i
      }
    }

    // The compiler won't synthesize support with the UNRECOGNIZED case.
    static let allCases: [Spark_Connect_WriteOperationV2.Mode] = [
      .unspecified,
      .create,
      .overwrite,
      .overwritePartitions,
      .append,
      .replace,
      .createOrReplace,
    ]

  }

  init() {}

  fileprivate var _input: Spark_Connect_Relation? = nil
  fileprivate var _provider: String? = nil
  fileprivate var _overwriteCondition: Spark_Connect_Expression? = nil
}

/// Starts write stream operation as streaming query. Query ID and Run ID of the streaming
/// query are returned.
struct Spark_Connect_WriteStreamOperationStart: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The output of the `input` streaming relation will be written.
  var input: Spark_Connect_Relation {
    get {return _storage._input ?? Spark_Connect_Relation()}
    set {_uniqueStorage()._input = newValue}
  }
  /// Returns true if `input` has been explicitly set.
  var hasInput: Bool {return _storage._input != nil}
  /// Clears the value of `input`. Subsequent reads from it will return its default value.
  mutating func clearInput() {_uniqueStorage()._input = nil}

  var format: String {
    get {return _storage._format}
    set {_uniqueStorage()._format = newValue}
  }

  var options: Dictionary<String,String> {
    get {return _storage._options}
    set {_uniqueStorage()._options = newValue}
  }

  var partitioningColumnNames: [String] {
    get {return _storage._partitioningColumnNames}
    set {_uniqueStorage()._partitioningColumnNames = newValue}
  }

  var trigger: OneOf_Trigger? {
    get {return _storage._trigger}
    set {_uniqueStorage()._trigger = newValue}
  }

  var processingTimeInterval: String {
    get {
      if case .processingTimeInterval(let v)? = _storage._trigger {return v}
      return String()
    }
    set {_uniqueStorage()._trigger = .processingTimeInterval(newValue)}
  }

  var availableNow: Bool {
    get {
      if case .availableNow(let v)? = _storage._trigger {return v}
      return false
    }
    set {_uniqueStorage()._trigger = .availableNow(newValue)}
  }

  var once: Bool {
    get {
      if case .once(let v)? = _storage._trigger {return v}
      return false
    }
    set {_uniqueStorage()._trigger = .once(newValue)}
  }

  var continuousCheckpointInterval: String {
    get {
      if case .continuousCheckpointInterval(let v)? = _storage._trigger {return v}
      return String()
    }
    set {_uniqueStorage()._trigger = .continuousCheckpointInterval(newValue)}
  }

  var outputMode: String {
    get {return _storage._outputMode}
    set {_uniqueStorage()._outputMode = newValue}
  }

  var queryName: String {
    get {return _storage._queryName}
    set {_uniqueStorage()._queryName = newValue}
  }

  /// The destination is optional. When set, it can be a path or a table name.
  var sinkDestination: OneOf_SinkDestination? {
    get {return _storage._sinkDestination}
    set {_uniqueStorage()._sinkDestination = newValue}
  }

  var path: String {
    get {
      if case .path(let v)? = _storage._sinkDestination {return v}
      return String()
    }
    set {_uniqueStorage()._sinkDestination = .path(newValue)}
  }

  var tableName: String {
    get {
      if case .tableName(let v)? = _storage._sinkDestination {return v}
      return String()
    }
    set {_uniqueStorage()._sinkDestination = .tableName(newValue)}
  }

  var foreachWriter: Spark_Connect_StreamingForeachFunction {
    get {return _storage._foreachWriter ?? Spark_Connect_StreamingForeachFunction()}
    set {_uniqueStorage()._foreachWriter = newValue}
  }
  /// Returns true if `foreachWriter` has been explicitly set.
  var hasForeachWriter: Bool {return _storage._foreachWriter != nil}
  /// Clears the value of `foreachWriter`. Subsequent reads from it will return its default value.
  mutating func clearForeachWriter() {_uniqueStorage()._foreachWriter = nil}

  var foreachBatch: Spark_Connect_StreamingForeachFunction {
    get {return _storage._foreachBatch ?? Spark_Connect_StreamingForeachFunction()}
    set {_uniqueStorage()._foreachBatch = newValue}
  }
  /// Returns true if `foreachBatch` has been explicitly set.
  var hasForeachBatch: Bool {return _storage._foreachBatch != nil}
  /// Clears the value of `foreachBatch`. Subsequent reads from it will return its default value.
  mutating func clearForeachBatch() {_uniqueStorage()._foreachBatch = nil}

  /// (Optional) Columns used for clustering the table.
  var clusteringColumnNames: [String] {
    get {return _storage._clusteringColumnNames}
    set {_uniqueStorage()._clusteringColumnNames = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_Trigger: Equatable, Sendable {
    case processingTimeInterval(String)
    case availableNow(Bool)
    case once(Bool)
    case continuousCheckpointInterval(String)

  }

  /// The destination is optional. When set, it can be a path or a table name.
  enum OneOf_SinkDestination: Equatable, Sendable {
    case path(String)
    case tableName(String)

  }

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

struct Spark_Connect_StreamingForeachFunction: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var function: Spark_Connect_StreamingForeachFunction.OneOf_Function? = nil

  var pythonFunction: Spark_Connect_PythonUDF {
    get {
      if case .pythonFunction(let v)? = function {return v}
      return Spark_Connect_PythonUDF()
    }
    set {function = .pythonFunction(newValue)}
  }

  var scalaFunction: Spark_Connect_ScalarScalaUDF {
    get {
      if case .scalaFunction(let v)? = function {return v}
      return Spark_Connect_ScalarScalaUDF()
    }
    set {function = .scalaFunction(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_Function: Equatable, Sendable {
    case pythonFunction(Spark_Connect_PythonUDF)
    case scalaFunction(Spark_Connect_ScalarScalaUDF)

  }

  init() {}
}

struct Spark_Connect_WriteStreamOperationStartResult: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Query instance. See `StreamingQueryInstanceId`.
  var queryID: Spark_Connect_StreamingQueryInstanceId {
    get {return _queryID ?? Spark_Connect_StreamingQueryInstanceId()}
    set {_queryID = newValue}
  }
  /// Returns true if `queryID` has been explicitly set.
  var hasQueryID: Bool {return self._queryID != nil}
  /// Clears the value of `queryID`. Subsequent reads from it will return its default value.
  mutating func clearQueryID() {self._queryID = nil}

  /// An optional query name.
  var name: String = String()

  /// Optional query started event if there is any listener registered on the client side.
  var queryStartedEventJson: String {
    get {return _queryStartedEventJson ?? String()}
    set {_queryStartedEventJson = newValue}
  }
  /// Returns true if `queryStartedEventJson` has been explicitly set.
  var hasQueryStartedEventJson: Bool {return self._queryStartedEventJson != nil}
  /// Clears the value of `queryStartedEventJson`. Subsequent reads from it will return its default value.
  mutating func clearQueryStartedEventJson() {self._queryStartedEventJson = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _queryID: Spark_Connect_StreamingQueryInstanceId? = nil
  fileprivate var _queryStartedEventJson: String? = nil
}

/// A tuple that uniquely identifies an instance of streaming query run. It consists of `id` that
/// persists across the streaming runs and `run_id` that changes between each run of the
/// streaming query that resumes from the checkpoint.
struct Spark_Connect_StreamingQueryInstanceId: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The unique id of this query that persists across restarts from checkpoint data.
  /// That is, this id is generated when a query is started for the first time, and
  /// will be the same every time it is restarted from checkpoint data.
  var id: String = String()

  /// (Required) The unique id of this run of the query. That is, every start/restart of a query
  /// will generate a unique run_id. Therefore, every time a query is restarted from
  /// checkpoint, it will have the same `id` but different `run_id`s.
  var runID: String = String()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

/// Commands for a streaming query.
struct Spark_Connect_StreamingQueryCommand: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Query instance. See `StreamingQueryInstanceId`.
  var queryID: Spark_Connect_StreamingQueryInstanceId {
    get {return _queryID ?? Spark_Connect_StreamingQueryInstanceId()}
    set {_queryID = newValue}
  }
  /// Returns true if `queryID` has been explicitly set.
  var hasQueryID: Bool {return self._queryID != nil}
  /// Clears the value of `queryID`. Subsequent reads from it will return its default value.
  mutating func clearQueryID() {self._queryID = nil}

  /// See documentation for the corresponding API method in StreamingQuery.
  var command: Spark_Connect_StreamingQueryCommand.OneOf_Command? = nil

  /// status() API.
  var status: Bool {
    get {
      if case .status(let v)? = command {return v}
      return false
    }
    set {command = .status(newValue)}
  }

  /// lastProgress() API.
  var lastProgress: Bool {
    get {
      if case .lastProgress(let v)? = command {return v}
      return false
    }
    set {command = .lastProgress(newValue)}
  }

  /// recentProgress() API.
  var recentProgress: Bool {
    get {
      if case .recentProgress(let v)? = command {return v}
      return false
    }
    set {command = .recentProgress(newValue)}
  }

  /// stop() API. Stops the query.
  var stop: Bool {
    get {
      if case .stop(let v)? = command {return v}
      return false
    }
    set {command = .stop(newValue)}
  }

  /// processAllAvailable() API. Waits till all the available data is processed
  var processAllAvailable: Bool {
    get {
      if case .processAllAvailable(let v)? = command {return v}
      return false
    }
    set {command = .processAllAvailable(newValue)}
  }

  /// explain() API. Returns logical and physical plans.
  var explain: Spark_Connect_StreamingQueryCommand.ExplainCommand {
    get {
      if case .explain(let v)? = command {return v}
      return Spark_Connect_StreamingQueryCommand.ExplainCommand()
    }
    set {command = .explain(newValue)}
  }

  /// exception() API. Returns the exception in the query if any.
  var exception: Bool {
    get {
      if case .exception(let v)? = command {return v}
      return false
    }
    set {command = .exception(newValue)}
  }

  /// awaitTermination() API. Waits for the termination of the query.
  var awaitTermination: Spark_Connect_StreamingQueryCommand.AwaitTerminationCommand {
    get {
      if case .awaitTermination(let v)? = command {return v}
      return Spark_Connect_StreamingQueryCommand.AwaitTerminationCommand()
    }
    set {command = .awaitTermination(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  /// See documentation for the corresponding API method in StreamingQuery.
  enum OneOf_Command: Equatable, Sendable {
    /// status() API.
    case status(Bool)
    /// lastProgress() API.
    case lastProgress(Bool)
    /// recentProgress() API.
    case recentProgress(Bool)
    /// stop() API. Stops the query.
    case stop(Bool)
    /// processAllAvailable() API. Waits till all the available data is processed
    case processAllAvailable(Bool)
    /// explain() API. Returns logical and physical plans.
    case explain(Spark_Connect_StreamingQueryCommand.ExplainCommand)
    /// exception() API. Returns the exception in the query if any.
    case exception(Bool)
    /// awaitTermination() API. Waits for the termination of the query.
    case awaitTermination(Spark_Connect_StreamingQueryCommand.AwaitTerminationCommand)

  }

  struct ExplainCommand: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// TODO: Consider reusing Explain from AnalyzePlanRequest message.
    ///       We can not do this right now since it base.proto imports this file.
    var extended: Bool = false

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct AwaitTerminationCommand: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var timeoutMs: Int64 {
      get {return _timeoutMs ?? 0}
      set {_timeoutMs = newValue}
    }
    /// Returns true if `timeoutMs` has been explicitly set.
    var hasTimeoutMs: Bool {return self._timeoutMs != nil}
    /// Clears the value of `timeoutMs`. Subsequent reads from it will return its default value.
    mutating func clearTimeoutMs() {self._timeoutMs = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _timeoutMs: Int64? = nil
  }

  init() {}

  fileprivate var _queryID: Spark_Connect_StreamingQueryInstanceId? = nil
}

/// Response for commands on a streaming query.
struct Spark_Connect_StreamingQueryCommandResult: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Query instance id. See `StreamingQueryInstanceId`.
  var queryID: Spark_Connect_StreamingQueryInstanceId {
    get {return _queryID ?? Spark_Connect_StreamingQueryInstanceId()}
    set {_queryID = newValue}
  }
  /// Returns true if `queryID` has been explicitly set.
  var hasQueryID: Bool {return self._queryID != nil}
  /// Clears the value of `queryID`. Subsequent reads from it will return its default value.
  mutating func clearQueryID() {self._queryID = nil}

  var resultType: Spark_Connect_StreamingQueryCommandResult.OneOf_ResultType? = nil

  var status: Spark_Connect_StreamingQueryCommandResult.StatusResult {
    get {
      if case .status(let v)? = resultType {return v}
      return Spark_Connect_StreamingQueryCommandResult.StatusResult()
    }
    set {resultType = .status(newValue)}
  }

  var recentProgress: Spark_Connect_StreamingQueryCommandResult.RecentProgressResult {
    get {
      if case .recentProgress(let v)? = resultType {return v}
      return Spark_Connect_StreamingQueryCommandResult.RecentProgressResult()
    }
    set {resultType = .recentProgress(newValue)}
  }

  var explain: Spark_Connect_StreamingQueryCommandResult.ExplainResult {
    get {
      if case .explain(let v)? = resultType {return v}
      return Spark_Connect_StreamingQueryCommandResult.ExplainResult()
    }
    set {resultType = .explain(newValue)}
  }

  var exception: Spark_Connect_StreamingQueryCommandResult.ExceptionResult {
    get {
      if case .exception(let v)? = resultType {return v}
      return Spark_Connect_StreamingQueryCommandResult.ExceptionResult()
    }
    set {resultType = .exception(newValue)}
  }

  var awaitTermination: Spark_Connect_StreamingQueryCommandResult.AwaitTerminationResult {
    get {
      if case .awaitTermination(let v)? = resultType {return v}
      return Spark_Connect_StreamingQueryCommandResult.AwaitTerminationResult()
    }
    set {resultType = .awaitTermination(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_ResultType: Equatable, Sendable {
    case status(Spark_Connect_StreamingQueryCommandResult.StatusResult)
    case recentProgress(Spark_Connect_StreamingQueryCommandResult.RecentProgressResult)
    case explain(Spark_Connect_StreamingQueryCommandResult.ExplainResult)
    case exception(Spark_Connect_StreamingQueryCommandResult.ExceptionResult)
    case awaitTermination(Spark_Connect_StreamingQueryCommandResult.AwaitTerminationResult)

  }

  struct StatusResult: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// See documentation for these Scala 'StreamingQueryStatus' struct
    var statusMessage: String = String()

    var isDataAvailable: Bool = false

    var isTriggerActive: Bool = false

    var isActive: Bool = false

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct RecentProgressResult: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// Progress reports as an array of json strings.
    var recentProgressJson: [String] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct ExplainResult: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// Logical and physical plans as string
    var result: String = String()

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct ExceptionResult: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Optional) Exception message as string, maps to the return value of original
    /// StreamingQueryException's toString method
    var exceptionMessage: String {
      get {return _exceptionMessage ?? String()}
      set {_exceptionMessage = newValue}
    }
    /// Returns true if `exceptionMessage` has been explicitly set.
    var hasExceptionMessage: Bool {return self._exceptionMessage != nil}
    /// Clears the value of `exceptionMessage`. Subsequent reads from it will return its default value.
    mutating func clearExceptionMessage() {self._exceptionMessage = nil}

    /// (Optional) Exception error class as string
    var errorClass: String {
      get {return _errorClass ?? String()}
      set {_errorClass = newValue}
    }
    /// Returns true if `errorClass` has been explicitly set.
    var hasErrorClass: Bool {return self._errorClass != nil}
    /// Clears the value of `errorClass`. Subsequent reads from it will return its default value.
    mutating func clearErrorClass() {self._errorClass = nil}

    /// (Optional) Exception stack trace as string
    var stackTrace: String {
      get {return _stackTrace ?? String()}
      set {_stackTrace = newValue}
    }
    /// Returns true if `stackTrace` has been explicitly set.
    var hasStackTrace: Bool {return self._stackTrace != nil}
    /// Clears the value of `stackTrace`. Subsequent reads from it will return its default value.
    mutating func clearStackTrace() {self._stackTrace = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _exceptionMessage: String? = nil
    fileprivate var _errorClass: String? = nil
    fileprivate var _stackTrace: String? = nil
  }

  struct AwaitTerminationResult: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var terminated: Bool = false

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}

  fileprivate var _queryID: Spark_Connect_StreamingQueryInstanceId? = nil
}

/// Commands for the streaming query manager.
struct Spark_Connect_StreamingQueryManagerCommand: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// See documentation for the corresponding API method in StreamingQueryManager.
  var command: Spark_Connect_StreamingQueryManagerCommand.OneOf_Command? = nil

  /// active() API, returns a list of active queries.
  var active: Bool {
    get {
      if case .active(let v)? = command {return v}
      return false
    }
    set {command = .active(newValue)}
  }

  /// get() API, returns the StreamingQuery identified by id.
  var getQuery: String {
    get {
      if case .getQuery(let v)? = command {return v}
      return String()
    }
    set {command = .getQuery(newValue)}
  }

  /// awaitAnyTermination() API, wait until any query terminates or timeout.
  var awaitAnyTermination: Spark_Connect_StreamingQueryManagerCommand.AwaitAnyTerminationCommand {
    get {
      if case .awaitAnyTermination(let v)? = command {return v}
      return Spark_Connect_StreamingQueryManagerCommand.AwaitAnyTerminationCommand()
    }
    set {command = .awaitAnyTermination(newValue)}
  }

  /// resetTerminated() API.
  var resetTerminated: Bool {
    get {
      if case .resetTerminated(let v)? = command {return v}
      return false
    }
    set {command = .resetTerminated(newValue)}
  }

  /// addListener API.
  var addListener: Spark_Connect_StreamingQueryManagerCommand.StreamingQueryListenerCommand {
    get {
      if case .addListener(let v)? = command {return v}
      return Spark_Connect_StreamingQueryManagerCommand.StreamingQueryListenerCommand()
    }
    set {command = .addListener(newValue)}
  }

  /// removeListener API.
  var removeListener: Spark_Connect_StreamingQueryManagerCommand.StreamingQueryListenerCommand {
    get {
      if case .removeListener(let v)? = command {return v}
      return Spark_Connect_StreamingQueryManagerCommand.StreamingQueryListenerCommand()
    }
    set {command = .removeListener(newValue)}
  }

  /// listListeners() API, returns a list of streaming query listeners.
  var listListeners: Bool {
    get {
      if case .listListeners(let v)? = command {return v}
      return false
    }
    set {command = .listListeners(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  /// See documentation for the corresponding API method in StreamingQueryManager.
  enum OneOf_Command: Equatable, Sendable {
    /// active() API, returns a list of active queries.
    case active(Bool)
    /// get() API, returns the StreamingQuery identified by id.
    case getQuery(String)
    /// awaitAnyTermination() API, wait until any query terminates or timeout.
    case awaitAnyTermination(Spark_Connect_StreamingQueryManagerCommand.AwaitAnyTerminationCommand)
    /// resetTerminated() API.
    case resetTerminated(Bool)
    /// addListener API.
    case addListener(Spark_Connect_StreamingQueryManagerCommand.StreamingQueryListenerCommand)
    /// removeListener API.
    case removeListener(Spark_Connect_StreamingQueryManagerCommand.StreamingQueryListenerCommand)
    /// listListeners() API, returns a list of streaming query listeners.
    case listListeners(Bool)

  }

  struct AwaitAnyTerminationCommand: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Optional) The waiting time in milliseconds to wait for any query to terminate.
    var timeoutMs: Int64 {
      get {return _timeoutMs ?? 0}
      set {_timeoutMs = newValue}
    }
    /// Returns true if `timeoutMs` has been explicitly set.
    var hasTimeoutMs: Bool {return self._timeoutMs != nil}
    /// Clears the value of `timeoutMs`. Subsequent reads from it will return its default value.
    mutating func clearTimeoutMs() {self._timeoutMs = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _timeoutMs: Int64? = nil
  }

  struct StreamingQueryListenerCommand: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var listenerPayload: Data = Data()

    var pythonListenerPayload: Spark_Connect_PythonUDF {
      get {return _pythonListenerPayload ?? Spark_Connect_PythonUDF()}
      set {_pythonListenerPayload = newValue}
    }
    /// Returns true if `pythonListenerPayload` has been explicitly set.
    var hasPythonListenerPayload: Bool {return self._pythonListenerPayload != nil}
    /// Clears the value of `pythonListenerPayload`. Subsequent reads from it will return its default value.
    mutating func clearPythonListenerPayload() {self._pythonListenerPayload = nil}

    var id: String = String()

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _pythonListenerPayload: Spark_Connect_PythonUDF? = nil
  }

  init() {}
}

/// Response for commands on the streaming query manager.
struct Spark_Connect_StreamingQueryManagerCommandResult: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var resultType: Spark_Connect_StreamingQueryManagerCommandResult.OneOf_ResultType? = nil

  var active: Spark_Connect_StreamingQueryManagerCommandResult.ActiveResult {
    get {
      if case .active(let v)? = resultType {return v}
      return Spark_Connect_StreamingQueryManagerCommandResult.ActiveResult()
    }
    set {resultType = .active(newValue)}
  }

  var query: Spark_Connect_StreamingQueryManagerCommandResult.StreamingQueryInstance {
    get {
      if case .query(let v)? = resultType {return v}
      return Spark_Connect_StreamingQueryManagerCommandResult.StreamingQueryInstance()
    }
    set {resultType = .query(newValue)}
  }

  var awaitAnyTermination: Spark_Connect_StreamingQueryManagerCommandResult.AwaitAnyTerminationResult {
    get {
      if case .awaitAnyTermination(let v)? = resultType {return v}
      return Spark_Connect_StreamingQueryManagerCommandResult.AwaitAnyTerminationResult()
    }
    set {resultType = .awaitAnyTermination(newValue)}
  }

  var resetTerminated: Bool {
    get {
      if case .resetTerminated(let v)? = resultType {return v}
      return false
    }
    set {resultType = .resetTerminated(newValue)}
  }

  var addListener: Bool {
    get {
      if case .addListener(let v)? = resultType {return v}
      return false
    }
    set {resultType = .addListener(newValue)}
  }

  var removeListener: Bool {
    get {
      if case .removeListener(let v)? = resultType {return v}
      return false
    }
    set {resultType = .removeListener(newValue)}
  }

  var listListeners: Spark_Connect_StreamingQueryManagerCommandResult.ListStreamingQueryListenerResult {
    get {
      if case .listListeners(let v)? = resultType {return v}
      return Spark_Connect_StreamingQueryManagerCommandResult.ListStreamingQueryListenerResult()
    }
    set {resultType = .listListeners(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_ResultType: Equatable, Sendable {
    case active(Spark_Connect_StreamingQueryManagerCommandResult.ActiveResult)
    case query(Spark_Connect_StreamingQueryManagerCommandResult.StreamingQueryInstance)
    case awaitAnyTermination(Spark_Connect_StreamingQueryManagerCommandResult.AwaitAnyTerminationResult)
    case resetTerminated(Bool)
    case addListener(Bool)
    case removeListener(Bool)
    case listListeners(Spark_Connect_StreamingQueryManagerCommandResult.ListStreamingQueryListenerResult)

  }

  struct ActiveResult: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var activeQueries: [Spark_Connect_StreamingQueryManagerCommandResult.StreamingQueryInstance] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct StreamingQueryInstance: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The id and runId of this query.
    var id: Spark_Connect_StreamingQueryInstanceId {
      get {return _id ?? Spark_Connect_StreamingQueryInstanceId()}
      set {_id = newValue}
    }
    /// Returns true if `id` has been explicitly set.
    var hasID: Bool {return self._id != nil}
    /// Clears the value of `id`. Subsequent reads from it will return its default value.
    mutating func clearID() {self._id = nil}

    /// (Optional) The name of this query.
    var name: String {
      get {return _name ?? String()}
      set {_name = newValue}
    }
    /// Returns true if `name` has been explicitly set.
    var hasName: Bool {return self._name != nil}
    /// Clears the value of `name`. Subsequent reads from it will return its default value.
    mutating func clearName() {self._name = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _id: Spark_Connect_StreamingQueryInstanceId? = nil
    fileprivate var _name: String? = nil
  }

  struct AwaitAnyTerminationResult: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var terminated: Bool = false

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct StreamingQueryListenerInstance: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var listenerPayload: Data = Data()

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct ListStreamingQueryListenerResult: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) Reference IDs of listener instances.
    var listenerIds: [String] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}
}

/// The protocol for client-side StreamingQueryListener.
/// This command will only be set when either the first listener is added to the client, or the last
/// listener is removed from the client.
/// The add_listener_bus_listener command will only be set true in the first case.
/// The remove_listener_bus_listener command will only be set true in the second case.
struct Spark_Connect_StreamingQueryListenerBusCommand: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var command: Spark_Connect_StreamingQueryListenerBusCommand.OneOf_Command? = nil

  var addListenerBusListener: Bool {
    get {
      if case .addListenerBusListener(let v)? = command {return v}
      return false
    }
    set {command = .addListenerBusListener(newValue)}
  }

  var removeListenerBusListener: Bool {
    get {
      if case .removeListenerBusListener(let v)? = command {return v}
      return false
    }
    set {command = .removeListenerBusListener(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_Command: Equatable, Sendable {
    case addListenerBusListener(Bool)
    case removeListenerBusListener(Bool)

  }

  init() {}
}

/// The protocol for the returned events in the long-running response channel.
struct Spark_Connect_StreamingQueryListenerEvent: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The json serialized event, all StreamingQueryListener events have a json method
  var eventJson: String = String()

  /// (Required) Query event type used by client to decide how to deserialize the event_json
  var eventType: Spark_Connect_StreamingQueryEventType = .queryProgressUnspecified

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

struct Spark_Connect_StreamingQueryListenerEventsResult: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var events: [Spark_Connect_StreamingQueryListenerEvent] = []

  var listenerBusListenerAdded: Bool {
    get {return _listenerBusListenerAdded ?? false}
    set {_listenerBusListenerAdded = newValue}
  }
  /// Returns true if `listenerBusListenerAdded` has been explicitly set.
  var hasListenerBusListenerAdded: Bool {return self._listenerBusListenerAdded != nil}
  /// Clears the value of `listenerBusListenerAdded`. Subsequent reads from it will return its default value.
  mutating func clearListenerBusListenerAdded() {self._listenerBusListenerAdded = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _listenerBusListenerAdded: Bool? = nil
}

/// Command to get the output of 'SparkContext.resources'
struct Spark_Connect_GetResourcesCommand: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

/// Response for command 'GetResourcesCommand'.
struct Spark_Connect_GetResourcesCommandResult: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var resources: Dictionary<String,Spark_Connect_ResourceInformation> = [:]

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

/// Command to create ResourceProfile
struct Spark_Connect_CreateResourceProfileCommand: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The ResourceProfile to be built on the server-side.
  var profile: Spark_Connect_ResourceProfile {
    get {return _profile ?? Spark_Connect_ResourceProfile()}
    set {_profile = newValue}
  }
  /// Returns true if `profile` has been explicitly set.
  var hasProfile: Bool {return self._profile != nil}
  /// Clears the value of `profile`. Subsequent reads from it will return its default value.
  mutating func clearProfile() {self._profile = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _profile: Spark_Connect_ResourceProfile? = nil
}

/// Response for command 'CreateResourceProfileCommand'.
struct Spark_Connect_CreateResourceProfileCommandResult: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Server-side generated resource profile id.
  var profileID: Int32 = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

/// Command to remove `CashedRemoteRelation`
struct Spark_Connect_RemoveCachedRemoteRelationCommand: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The remote to be related
  var relation: Spark_Connect_CachedRemoteRelation {
    get {return _relation ?? Spark_Connect_CachedRemoteRelation()}
    set {_relation = newValue}
  }
  /// Returns true if `relation` has been explicitly set.
  var hasRelation: Bool {return self._relation != nil}
  /// Clears the value of `relation`. Subsequent reads from it will return its default value.
  mutating func clearRelation() {self._relation = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _relation: Spark_Connect_CachedRemoteRelation? = nil
}

struct Spark_Connect_CheckpointCommand: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The logical plan to checkpoint.
  var relation: Spark_Connect_Relation {
    get {return _relation ?? Spark_Connect_Relation()}
    set {_relation = newValue}
  }
  /// Returns true if `relation` has been explicitly set.
  var hasRelation: Bool {return self._relation != nil}
  /// Clears the value of `relation`. Subsequent reads from it will return its default value.
  mutating func clearRelation() {self._relation = nil}

  /// (Required) Locally checkpoint using a local temporary
  /// directory in Spark Connect server (Spark Driver)
  var local: Bool = false

  /// (Required) Whether to checkpoint this dataframe immediately.
  var eager: Bool = false

  /// (Optional) For local checkpoint, the storage level to use.
  var storageLevel: Spark_Connect_StorageLevel {
    get {return _storageLevel ?? Spark_Connect_StorageLevel()}
    set {_storageLevel = newValue}
  }
  /// Returns true if `storageLevel` has been explicitly set.
  var hasStorageLevel: Bool {return self._storageLevel != nil}
  /// Clears the value of `storageLevel`. Subsequent reads from it will return its default value.
  mutating func clearStorageLevel() {self._storageLevel = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _relation: Spark_Connect_Relation? = nil
  fileprivate var _storageLevel: Spark_Connect_StorageLevel? = nil
}

struct Spark_Connect_MergeIntoTableCommand: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The name of the target table.
  var targetTableName: String = String()

  /// (Required) The relation of the source table.
  var sourceTablePlan: Spark_Connect_Relation {
    get {return _sourceTablePlan ?? Spark_Connect_Relation()}
    set {_sourceTablePlan = newValue}
  }
  /// Returns true if `sourceTablePlan` has been explicitly set.
  var hasSourceTablePlan: Bool {return self._sourceTablePlan != nil}
  /// Clears the value of `sourceTablePlan`. Subsequent reads from it will return its default value.
  mutating func clearSourceTablePlan() {self._sourceTablePlan = nil}

  /// (Required) The condition to match the source and target.
  var mergeCondition: Spark_Connect_Expression {
    get {return _mergeCondition ?? Spark_Connect_Expression()}
    set {_mergeCondition = newValue}
  }
  /// Returns true if `mergeCondition` has been explicitly set.
  var hasMergeCondition: Bool {return self._mergeCondition != nil}
  /// Clears the value of `mergeCondition`. Subsequent reads from it will return its default value.
  mutating func clearMergeCondition() {self._mergeCondition = nil}

  /// (Optional) The actions to be taken when the condition is matched.
  var matchActions: [Spark_Connect_Expression] = []

  /// (Optional) The actions to be taken when the condition is not matched.
  var notMatchedActions: [Spark_Connect_Expression] = []

  /// (Optional) The actions to be taken when the condition is not matched by source.
  var notMatchedBySourceActions: [Spark_Connect_Expression] = []

  /// (Required) Whether to enable schema evolution.
  var withSchemaEvolution: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _sourceTablePlan: Spark_Connect_Relation? = nil
  fileprivate var _mergeCondition: Spark_Connect_Expression? = nil
}

/// Execute an arbitrary string command inside an external execution engine
struct Spark_Connect_ExecuteExternalCommand: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The class name of the runner that implements `ExternalCommandRunner`
  var runner: String = String()

  /// (Required) The target command to be executed.
  var command: String = String()

  /// (Optional) The options for the runner.
  var options: Dictionary<String,String> = [:]

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

fileprivate let _protobuf_package = "spark.connect"

extension Spark_Connect_StreamingQueryEventType: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{2}\0QUERY_PROGRESS_UNSPECIFIED\0\u{1}QUERY_PROGRESS_EVENT\0\u{1}QUERY_TERMINATED_EVENT\0\u{1}QUERY_IDLE_EVENT\0")
}

extension Spark_Connect_Command: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Command"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{3}register_function\0\u{3}write_operation\0\u{3}create_dataframe_view\0\u{3}write_operation_v2\0\u{3}sql_command\0\u{3}write_stream_operation_start\0\u{3}streaming_query_command\0\u{3}get_resources_command\0\u{3}streaming_query_manager_command\0\u{3}register_table_function\0\u{3}streaming_query_listener_bus_command\0\u{3}register_data_source\0\u{3}create_resource_profile_command\0\u{3}checkpoint_command\0\u{3}remove_cached_remote_relation_command\0\u{3}merge_into_table_command\0\u{3}ml_command\0\u{3}execute_external_command\0\u{3}pipeline_command\0\u{2}T\u{f}extension\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: Spark_Connect_CommonInlineUserDefinedFunction?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .registerFunction(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .registerFunction(v)
        }
      }()
      case 2: try {
        var v: Spark_Connect_WriteOperation?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .writeOperation(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .writeOperation(v)
        }
      }()
      case 3: try {
        var v: Spark_Connect_CreateDataFrameViewCommand?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .createDataframeView(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .createDataframeView(v)
        }
      }()
      case 4: try {
        var v: Spark_Connect_WriteOperationV2?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .writeOperationV2(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .writeOperationV2(v)
        }
      }()
      case 5: try {
        var v: Spark_Connect_SqlCommand?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .sqlCommand(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .sqlCommand(v)
        }
      }()
      case 6: try {
        var v: Spark_Connect_WriteStreamOperationStart?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .writeStreamOperationStart(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .writeStreamOperationStart(v)
        }
      }()
      case 7: try {
        var v: Spark_Connect_StreamingQueryCommand?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .streamingQueryCommand(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .streamingQueryCommand(v)
        }
      }()
      case 8: try {
        var v: Spark_Connect_GetResourcesCommand?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .getResourcesCommand(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .getResourcesCommand(v)
        }
      }()
      case 9: try {
        var v: Spark_Connect_StreamingQueryManagerCommand?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .streamingQueryManagerCommand(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .streamingQueryManagerCommand(v)
        }
      }()
      case 10: try {
        var v: Spark_Connect_CommonInlineUserDefinedTableFunction?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .registerTableFunction(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .registerTableFunction(v)
        }
      }()
      case 11: try {
        var v: Spark_Connect_StreamingQueryListenerBusCommand?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .streamingQueryListenerBusCommand(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .streamingQueryListenerBusCommand(v)
        }
      }()
      case 12: try {
        var v: Spark_Connect_CommonInlineUserDefinedDataSource?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .registerDataSource(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .registerDataSource(v)
        }
      }()
      case 13: try {
        var v: Spark_Connect_CreateResourceProfileCommand?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .createResourceProfileCommand(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .createResourceProfileCommand(v)
        }
      }()
      case 14: try {
        var v: Spark_Connect_CheckpointCommand?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .checkpointCommand(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .checkpointCommand(v)
        }
      }()
      case 15: try {
        var v: Spark_Connect_RemoveCachedRemoteRelationCommand?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .removeCachedRemoteRelationCommand(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .removeCachedRemoteRelationCommand(v)
        }
      }()
      case 16: try {
        var v: Spark_Connect_MergeIntoTableCommand?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .mergeIntoTableCommand(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .mergeIntoTableCommand(v)
        }
      }()
      case 17: try {
        var v: Spark_Connect_MlCommand?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .mlCommand(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .mlCommand(v)
        }
      }()
      case 18: try {
        var v: Spark_Connect_ExecuteExternalCommand?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .executeExternalCommand(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .executeExternalCommand(v)
        }
      }()
      case 19: try {
        var v: Spark_Connect_PipelineCommand?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .pipelineCommand(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .pipelineCommand(v)
        }
      }()
      case 999: try {
        var v: SwiftProtobuf.Google_Protobuf_Any?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .extension(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .extension(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.commandType {
    case .registerFunction?: try {
      guard case .registerFunction(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    }()
    case .writeOperation?: try {
      guard case .writeOperation(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    }()
    case .createDataframeView?: try {
      guard case .createDataframeView(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    }()
    case .writeOperationV2?: try {
      guard case .writeOperationV2(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    }()
    case .sqlCommand?: try {
      guard case .sqlCommand(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
    }()
    case .writeStreamOperationStart?: try {
      guard case .writeStreamOperationStart(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 6)
    }()
    case .streamingQueryCommand?: try {
      guard case .streamingQueryCommand(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 7)
    }()
    case .getResourcesCommand?: try {
      guard case .getResourcesCommand(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 8)
    }()
    case .streamingQueryManagerCommand?: try {
      guard case .streamingQueryManagerCommand(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 9)
    }()
    case .registerTableFunction?: try {
      guard case .registerTableFunction(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 10)
    }()
    case .streamingQueryListenerBusCommand?: try {
      guard case .streamingQueryListenerBusCommand(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 11)
    }()
    case .registerDataSource?: try {
      guard case .registerDataSource(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 12)
    }()
    case .createResourceProfileCommand?: try {
      guard case .createResourceProfileCommand(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 13)
    }()
    case .checkpointCommand?: try {
      guard case .checkpointCommand(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 14)
    }()
    case .removeCachedRemoteRelationCommand?: try {
      guard case .removeCachedRemoteRelationCommand(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 15)
    }()
    case .mergeIntoTableCommand?: try {
      guard case .mergeIntoTableCommand(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 16)
    }()
    case .mlCommand?: try {
      guard case .mlCommand(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 17)
    }()
    case .executeExternalCommand?: try {
      guard case .executeExternalCommand(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 18)
    }()
    case .pipelineCommand?: try {
      guard case .pipelineCommand(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 19)
    }()
    case .extension?: try {
      guard case .extension(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 999)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Command, rhs: Spark_Connect_Command) -> Bool {
    if lhs.commandType != rhs.commandType {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_SqlCommand: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SqlCommand"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{1}sql\0\u{1}args\0\u{3}pos_args\0\u{3}named_arguments\0\u{3}pos_arguments\0\u{1}input\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.sql) }()
      case 2: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,Spark_Connect_Expression.Literal>.self, value: &self.args) }()
      case 3: try { try decoder.decodeRepeatedMessageField(value: &self.posArgs) }()
      case 4: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,Spark_Connect_Expression>.self, value: &self.namedArguments) }()
      case 5: try { try decoder.decodeRepeatedMessageField(value: &self.posArguments) }()
      case 6: try { try decoder.decodeSingularMessageField(value: &self._input) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.sql.isEmpty {
      try visitor.visitSingularStringField(value: self.sql, fieldNumber: 1)
    }
    if !self.args.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,Spark_Connect_Expression.Literal>.self, value: self.args, fieldNumber: 2)
    }
    if !self.posArgs.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.posArgs, fieldNumber: 3)
    }
    if !self.namedArguments.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,Spark_Connect_Expression>.self, value: self.namedArguments, fieldNumber: 4)
    }
    if !self.posArguments.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.posArguments, fieldNumber: 5)
    }
    try { if let v = self._input {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 6)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_SqlCommand, rhs: Spark_Connect_SqlCommand) -> Bool {
    if lhs.sql != rhs.sql {return false}
    if lhs.args != rhs.args {return false}
    if lhs.posArgs != rhs.posArgs {return false}
    if lhs.namedArguments != rhs.namedArguments {return false}
    if lhs.posArguments != rhs.posArguments {return false}
    if lhs._input != rhs._input {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_CreateDataFrameViewCommand: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CreateDataFrameViewCommand"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{1}input\0\u{1}name\0\u{3}is_global\0\u{1}replace\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._input) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.name) }()
      case 3: try { try decoder.decodeSingularBoolField(value: &self.isGlobal) }()
      case 4: try { try decoder.decodeSingularBoolField(value: &self.replace) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._input {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    if !self.name.isEmpty {
      try visitor.visitSingularStringField(value: self.name, fieldNumber: 2)
    }
    if self.isGlobal != false {
      try visitor.visitSingularBoolField(value: self.isGlobal, fieldNumber: 3)
    }
    if self.replace != false {
      try visitor.visitSingularBoolField(value: self.replace, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_CreateDataFrameViewCommand, rhs: Spark_Connect_CreateDataFrameViewCommand) -> Bool {
    if lhs._input != rhs._input {return false}
    if lhs.name != rhs.name {return false}
    if lhs.isGlobal != rhs.isGlobal {return false}
    if lhs.replace != rhs.replace {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_WriteOperation: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".WriteOperation"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{1}input\0\u{1}source\0\u{1}path\0\u{1}table\0\u{1}mode\0\u{3}sort_column_names\0\u{3}partitioning_columns\0\u{3}bucket_by\0\u{1}options\0\u{3}clustering_columns\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._input) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self._source) }()
      case 3: try {
        var v: String?
        try decoder.decodeSingularStringField(value: &v)
        if let v = v {
          if self.saveType != nil {try decoder.handleConflictingOneOf()}
          self.saveType = .path(v)
        }
      }()
      case 4: try {
        var v: Spark_Connect_WriteOperation.SaveTable?
        var hadOneofValue = false
        if let current = self.saveType {
          hadOneofValue = true
          if case .table(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.saveType = .table(v)
        }
      }()
      case 5: try { try decoder.decodeSingularEnumField(value: &self.mode) }()
      case 6: try { try decoder.decodeRepeatedStringField(value: &self.sortColumnNames) }()
      case 7: try { try decoder.decodeRepeatedStringField(value: &self.partitioningColumns) }()
      case 8: try { try decoder.decodeSingularMessageField(value: &self._bucketBy) }()
      case 9: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: &self.options) }()
      case 10: try { try decoder.decodeRepeatedStringField(value: &self.clusteringColumns) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._input {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._source {
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    } }()
    switch self.saveType {
    case .path?: try {
      guard case .path(let v)? = self.saveType else { preconditionFailure() }
      try visitor.visitSingularStringField(value: v, fieldNumber: 3)
    }()
    case .table?: try {
      guard case .table(let v)? = self.saveType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    }()
    case nil: break
    }
    if self.mode != .unspecified {
      try visitor.visitSingularEnumField(value: self.mode, fieldNumber: 5)
    }
    if !self.sortColumnNames.isEmpty {
      try visitor.visitRepeatedStringField(value: self.sortColumnNames, fieldNumber: 6)
    }
    if !self.partitioningColumns.isEmpty {
      try visitor.visitRepeatedStringField(value: self.partitioningColumns, fieldNumber: 7)
    }
    try { if let v = self._bucketBy {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 8)
    } }()
    if !self.options.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: self.options, fieldNumber: 9)
    }
    if !self.clusteringColumns.isEmpty {
      try visitor.visitRepeatedStringField(value: self.clusteringColumns, fieldNumber: 10)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_WriteOperation, rhs: Spark_Connect_WriteOperation) -> Bool {
    if lhs._input != rhs._input {return false}
    if lhs._source != rhs._source {return false}
    if lhs.saveType != rhs.saveType {return false}
    if lhs.mode != rhs.mode {return false}
    if lhs.sortColumnNames != rhs.sortColumnNames {return false}
    if lhs.partitioningColumns != rhs.partitioningColumns {return false}
    if lhs._bucketBy != rhs._bucketBy {return false}
    if lhs.options != rhs.options {return false}
    if lhs.clusteringColumns != rhs.clusteringColumns {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_WriteOperation.SaveMode: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{2}\0SAVE_MODE_UNSPECIFIED\0\u{1}SAVE_MODE_APPEND\0\u{1}SAVE_MODE_OVERWRITE\0\u{1}SAVE_MODE_ERROR_IF_EXISTS\0\u{1}SAVE_MODE_IGNORE\0")
}

extension Spark_Connect_WriteOperation.SaveTable: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_WriteOperation.protoMessageName + ".SaveTable"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{3}table_name\0\u{3}save_method\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.tableName) }()
      case 2: try { try decoder.decodeSingularEnumField(value: &self.saveMethod) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.tableName.isEmpty {
      try visitor.visitSingularStringField(value: self.tableName, fieldNumber: 1)
    }
    if self.saveMethod != .unspecified {
      try visitor.visitSingularEnumField(value: self.saveMethod, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_WriteOperation.SaveTable, rhs: Spark_Connect_WriteOperation.SaveTable) -> Bool {
    if lhs.tableName != rhs.tableName {return false}
    if lhs.saveMethod != rhs.saveMethod {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_WriteOperation.SaveTable.TableSaveMethod: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{2}\0TABLE_SAVE_METHOD_UNSPECIFIED\0\u{1}TABLE_SAVE_METHOD_SAVE_AS_TABLE\0\u{1}TABLE_SAVE_METHOD_INSERT_INTO\0")
}

extension Spark_Connect_WriteOperation.BucketBy: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_WriteOperation.protoMessageName + ".BucketBy"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{3}bucket_column_names\0\u{3}num_buckets\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedStringField(value: &self.bucketColumnNames) }()
      case 2: try { try decoder.decodeSingularInt32Field(value: &self.numBuckets) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.bucketColumnNames.isEmpty {
      try visitor.visitRepeatedStringField(value: self.bucketColumnNames, fieldNumber: 1)
    }
    if self.numBuckets != 0 {
      try visitor.visitSingularInt32Field(value: self.numBuckets, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_WriteOperation.BucketBy, rhs: Spark_Connect_WriteOperation.BucketBy) -> Bool {
    if lhs.bucketColumnNames != rhs.bucketColumnNames {return false}
    if lhs.numBuckets != rhs.numBuckets {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_WriteOperationV2: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".WriteOperationV2"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{1}input\0\u{3}table_name\0\u{1}provider\0\u{3}partitioning_columns\0\u{1}options\0\u{3}table_properties\0\u{1}mode\0\u{3}overwrite_condition\0\u{3}clustering_columns\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._input) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.tableName) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self._provider) }()
      case 4: try { try decoder.decodeRepeatedMessageField(value: &self.partitioningColumns) }()
      case 5: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: &self.options) }()
      case 6: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: &self.tableProperties) }()
      case 7: try { try decoder.decodeSingularEnumField(value: &self.mode) }()
      case 8: try { try decoder.decodeSingularMessageField(value: &self._overwriteCondition) }()
      case 9: try { try decoder.decodeRepeatedStringField(value: &self.clusteringColumns) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._input {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    if !self.tableName.isEmpty {
      try visitor.visitSingularStringField(value: self.tableName, fieldNumber: 2)
    }
    try { if let v = self._provider {
      try visitor.visitSingularStringField(value: v, fieldNumber: 3)
    } }()
    if !self.partitioningColumns.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.partitioningColumns, fieldNumber: 4)
    }
    if !self.options.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: self.options, fieldNumber: 5)
    }
    if !self.tableProperties.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: self.tableProperties, fieldNumber: 6)
    }
    if self.mode != .unspecified {
      try visitor.visitSingularEnumField(value: self.mode, fieldNumber: 7)
    }
    try { if let v = self._overwriteCondition {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 8)
    } }()
    if !self.clusteringColumns.isEmpty {
      try visitor.visitRepeatedStringField(value: self.clusteringColumns, fieldNumber: 9)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_WriteOperationV2, rhs: Spark_Connect_WriteOperationV2) -> Bool {
    if lhs._input != rhs._input {return false}
    if lhs.tableName != rhs.tableName {return false}
    if lhs._provider != rhs._provider {return false}
    if lhs.partitioningColumns != rhs.partitioningColumns {return false}
    if lhs.options != rhs.options {return false}
    if lhs.tableProperties != rhs.tableProperties {return false}
    if lhs.mode != rhs.mode {return false}
    if lhs._overwriteCondition != rhs._overwriteCondition {return false}
    if lhs.clusteringColumns != rhs.clusteringColumns {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_WriteOperationV2.Mode: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{2}\0MODE_UNSPECIFIED\0\u{1}MODE_CREATE\0\u{1}MODE_OVERWRITE\0\u{1}MODE_OVERWRITE_PARTITIONS\0\u{1}MODE_APPEND\0\u{1}MODE_REPLACE\0\u{1}MODE_CREATE_OR_REPLACE\0")
}

extension Spark_Connect_WriteStreamOperationStart: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".WriteStreamOperationStart"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{1}input\0\u{1}format\0\u{1}options\0\u{3}partitioning_column_names\0\u{3}processing_time_interval\0\u{3}available_now\0\u{1}once\0\u{3}continuous_checkpoint_interval\0\u{3}output_mode\0\u{3}query_name\0\u{1}path\0\u{3}table_name\0\u{3}foreach_writer\0\u{3}foreach_batch\0\u{3}clustering_column_names\0")

  fileprivate class _StorageClass {
    var _input: Spark_Connect_Relation? = nil
    var _format: String = String()
    var _options: Dictionary<String,String> = [:]
    var _partitioningColumnNames: [String] = []
    var _trigger: Spark_Connect_WriteStreamOperationStart.OneOf_Trigger?
    var _outputMode: String = String()
    var _queryName: String = String()
    var _sinkDestination: Spark_Connect_WriteStreamOperationStart.OneOf_SinkDestination?
    var _foreachWriter: Spark_Connect_StreamingForeachFunction? = nil
    var _foreachBatch: Spark_Connect_StreamingForeachFunction? = nil
    var _clusteringColumnNames: [String] = []

      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _input = source._input
      _format = source._format
      _options = source._options
      _partitioningColumnNames = source._partitioningColumnNames
      _trigger = source._trigger
      _outputMode = source._outputMode
      _queryName = source._queryName
      _sinkDestination = source._sinkDestination
      _foreachWriter = source._foreachWriter
      _foreachBatch = source._foreachBatch
      _clusteringColumnNames = source._clusteringColumnNames
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._input) }()
        case 2: try { try decoder.decodeSingularStringField(value: &_storage._format) }()
        case 3: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: &_storage._options) }()
        case 4: try { try decoder.decodeRepeatedStringField(value: &_storage._partitioningColumnNames) }()
        case 5: try {
          var v: String?
          try decoder.decodeSingularStringField(value: &v)
          if let v = v {
            if _storage._trigger != nil {try decoder.handleConflictingOneOf()}
            _storage._trigger = .processingTimeInterval(v)
          }
        }()
        case 6: try {
          var v: Bool?
          try decoder.decodeSingularBoolField(value: &v)
          if let v = v {
            if _storage._trigger != nil {try decoder.handleConflictingOneOf()}
            _storage._trigger = .availableNow(v)
          }
        }()
        case 7: try {
          var v: Bool?
          try decoder.decodeSingularBoolField(value: &v)
          if let v = v {
            if _storage._trigger != nil {try decoder.handleConflictingOneOf()}
            _storage._trigger = .once(v)
          }
        }()
        case 8: try {
          var v: String?
          try decoder.decodeSingularStringField(value: &v)
          if let v = v {
            if _storage._trigger != nil {try decoder.handleConflictingOneOf()}
            _storage._trigger = .continuousCheckpointInterval(v)
          }
        }()
        case 9: try { try decoder.decodeSingularStringField(value: &_storage._outputMode) }()
        case 10: try { try decoder.decodeSingularStringField(value: &_storage._queryName) }()
        case 11: try {
          var v: String?
          try decoder.decodeSingularStringField(value: &v)
          if let v = v {
            if _storage._sinkDestination != nil {try decoder.handleConflictingOneOf()}
            _storage._sinkDestination = .path(v)
          }
        }()
        case 12: try {
          var v: String?
          try decoder.decodeSingularStringField(value: &v)
          if let v = v {
            if _storage._sinkDestination != nil {try decoder.handleConflictingOneOf()}
            _storage._sinkDestination = .tableName(v)
          }
        }()
        case 13: try { try decoder.decodeSingularMessageField(value: &_storage._foreachWriter) }()
        case 14: try { try decoder.decodeSingularMessageField(value: &_storage._foreachBatch) }()
        case 15: try { try decoder.decodeRepeatedStringField(value: &_storage._clusteringColumnNames) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._input {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      if !_storage._format.isEmpty {
        try visitor.visitSingularStringField(value: _storage._format, fieldNumber: 2)
      }
      if !_storage._options.isEmpty {
        try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: _storage._options, fieldNumber: 3)
      }
      if !_storage._partitioningColumnNames.isEmpty {
        try visitor.visitRepeatedStringField(value: _storage._partitioningColumnNames, fieldNumber: 4)
      }
      switch _storage._trigger {
      case .processingTimeInterval?: try {
        guard case .processingTimeInterval(let v)? = _storage._trigger else { preconditionFailure() }
        try visitor.visitSingularStringField(value: v, fieldNumber: 5)
      }()
      case .availableNow?: try {
        guard case .availableNow(let v)? = _storage._trigger else { preconditionFailure() }
        try visitor.visitSingularBoolField(value: v, fieldNumber: 6)
      }()
      case .once?: try {
        guard case .once(let v)? = _storage._trigger else { preconditionFailure() }
        try visitor.visitSingularBoolField(value: v, fieldNumber: 7)
      }()
      case .continuousCheckpointInterval?: try {
        guard case .continuousCheckpointInterval(let v)? = _storage._trigger else { preconditionFailure() }
        try visitor.visitSingularStringField(value: v, fieldNumber: 8)
      }()
      case nil: break
      }
      if !_storage._outputMode.isEmpty {
        try visitor.visitSingularStringField(value: _storage._outputMode, fieldNumber: 9)
      }
      if !_storage._queryName.isEmpty {
        try visitor.visitSingularStringField(value: _storage._queryName, fieldNumber: 10)
      }
      switch _storage._sinkDestination {
      case .path?: try {
        guard case .path(let v)? = _storage._sinkDestination else { preconditionFailure() }
        try visitor.visitSingularStringField(value: v, fieldNumber: 11)
      }()
      case .tableName?: try {
        guard case .tableName(let v)? = _storage._sinkDestination else { preconditionFailure() }
        try visitor.visitSingularStringField(value: v, fieldNumber: 12)
      }()
      case nil: break
      }
      try { if let v = _storage._foreachWriter {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 13)
      } }()
      try { if let v = _storage._foreachBatch {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 14)
      } }()
      if !_storage._clusteringColumnNames.isEmpty {
        try visitor.visitRepeatedStringField(value: _storage._clusteringColumnNames, fieldNumber: 15)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_WriteStreamOperationStart, rhs: Spark_Connect_WriteStreamOperationStart) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._input != rhs_storage._input {return false}
        if _storage._format != rhs_storage._format {return false}
        if _storage._options != rhs_storage._options {return false}
        if _storage._partitioningColumnNames != rhs_storage._partitioningColumnNames {return false}
        if _storage._trigger != rhs_storage._trigger {return false}
        if _storage._outputMode != rhs_storage._outputMode {return false}
        if _storage._queryName != rhs_storage._queryName {return false}
        if _storage._sinkDestination != rhs_storage._sinkDestination {return false}
        if _storage._foreachWriter != rhs_storage._foreachWriter {return false}
        if _storage._foreachBatch != rhs_storage._foreachBatch {return false}
        if _storage._clusteringColumnNames != rhs_storage._clusteringColumnNames {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingForeachFunction: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".StreamingForeachFunction"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{3}python_function\0\u{3}scala_function\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: Spark_Connect_PythonUDF?
        var hadOneofValue = false
        if let current = self.function {
          hadOneofValue = true
          if case .pythonFunction(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.function = .pythonFunction(v)
        }
      }()
      case 2: try {
        var v: Spark_Connect_ScalarScalaUDF?
        var hadOneofValue = false
        if let current = self.function {
          hadOneofValue = true
          if case .scalaFunction(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.function = .scalaFunction(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.function {
    case .pythonFunction?: try {
      guard case .pythonFunction(let v)? = self.function else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    }()
    case .scalaFunction?: try {
      guard case .scalaFunction(let v)? = self.function else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingForeachFunction, rhs: Spark_Connect_StreamingForeachFunction) -> Bool {
    if lhs.function != rhs.function {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_WriteStreamOperationStartResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".WriteStreamOperationStartResult"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{3}query_id\0\u{1}name\0\u{3}query_started_event_json\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._queryID) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.name) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self._queryStartedEventJson) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._queryID {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    if !self.name.isEmpty {
      try visitor.visitSingularStringField(value: self.name, fieldNumber: 2)
    }
    try { if let v = self._queryStartedEventJson {
      try visitor.visitSingularStringField(value: v, fieldNumber: 3)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_WriteStreamOperationStartResult, rhs: Spark_Connect_WriteStreamOperationStartResult) -> Bool {
    if lhs._queryID != rhs._queryID {return false}
    if lhs.name != rhs.name {return false}
    if lhs._queryStartedEventJson != rhs._queryStartedEventJson {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingQueryInstanceId: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".StreamingQueryInstanceId"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{1}id\0\u{3}run_id\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.id) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.runID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.id.isEmpty {
      try visitor.visitSingularStringField(value: self.id, fieldNumber: 1)
    }
    if !self.runID.isEmpty {
      try visitor.visitSingularStringField(value: self.runID, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingQueryInstanceId, rhs: Spark_Connect_StreamingQueryInstanceId) -> Bool {
    if lhs.id != rhs.id {return false}
    if lhs.runID != rhs.runID {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingQueryCommand: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".StreamingQueryCommand"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{3}query_id\0\u{1}status\0\u{3}last_progress\0\u{3}recent_progress\0\u{1}stop\0\u{3}process_all_available\0\u{1}explain\0\u{1}exception\0\u{3}await_termination\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._queryID) }()
      case 2: try {
        var v: Bool?
        try decoder.decodeSingularBoolField(value: &v)
        if let v = v {
          if self.command != nil {try decoder.handleConflictingOneOf()}
          self.command = .status(v)
        }
      }()
      case 3: try {
        var v: Bool?
        try decoder.decodeSingularBoolField(value: &v)
        if let v = v {
          if self.command != nil {try decoder.handleConflictingOneOf()}
          self.command = .lastProgress(v)
        }
      }()
      case 4: try {
        var v: Bool?
        try decoder.decodeSingularBoolField(value: &v)
        if let v = v {
          if self.command != nil {try decoder.handleConflictingOneOf()}
          self.command = .recentProgress(v)
        }
      }()
      case 5: try {
        var v: Bool?
        try decoder.decodeSingularBoolField(value: &v)
        if let v = v {
          if self.command != nil {try decoder.handleConflictingOneOf()}
          self.command = .stop(v)
        }
      }()
      case 6: try {
        var v: Bool?
        try decoder.decodeSingularBoolField(value: &v)
        if let v = v {
          if self.command != nil {try decoder.handleConflictingOneOf()}
          self.command = .processAllAvailable(v)
        }
      }()
      case 7: try {
        var v: Spark_Connect_StreamingQueryCommand.ExplainCommand?
        var hadOneofValue = false
        if let current = self.command {
          hadOneofValue = true
          if case .explain(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.command = .explain(v)
        }
      }()
      case 8: try {
        var v: Bool?
        try decoder.decodeSingularBoolField(value: &v)
        if let v = v {
          if self.command != nil {try decoder.handleConflictingOneOf()}
          self.command = .exception(v)
        }
      }()
      case 9: try {
        var v: Spark_Connect_StreamingQueryCommand.AwaitTerminationCommand?
        var hadOneofValue = false
        if let current = self.command {
          hadOneofValue = true
          if case .awaitTermination(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.command = .awaitTermination(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._queryID {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    switch self.command {
    case .status?: try {
      guard case .status(let v)? = self.command else { preconditionFailure() }
      try visitor.visitSingularBoolField(value: v, fieldNumber: 2)
    }()
    case .lastProgress?: try {
      guard case .lastProgress(let v)? = self.command else { preconditionFailure() }
      try visitor.visitSingularBoolField(value: v, fieldNumber: 3)
    }()
    case .recentProgress?: try {
      guard case .recentProgress(let v)? = self.command else { preconditionFailure() }
      try visitor.visitSingularBoolField(value: v, fieldNumber: 4)
    }()
    case .stop?: try {
      guard case .stop(let v)? = self.command else { preconditionFailure() }
      try visitor.visitSingularBoolField(value: v, fieldNumber: 5)
    }()
    case .processAllAvailable?: try {
      guard case .processAllAvailable(let v)? = self.command else { preconditionFailure() }
      try visitor.visitSingularBoolField(value: v, fieldNumber: 6)
    }()
    case .explain?: try {
      guard case .explain(let v)? = self.command else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 7)
    }()
    case .exception?: try {
      guard case .exception(let v)? = self.command else { preconditionFailure() }
      try visitor.visitSingularBoolField(value: v, fieldNumber: 8)
    }()
    case .awaitTermination?: try {
      guard case .awaitTermination(let v)? = self.command else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 9)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingQueryCommand, rhs: Spark_Connect_StreamingQueryCommand) -> Bool {
    if lhs._queryID != rhs._queryID {return false}
    if lhs.command != rhs.command {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingQueryCommand.ExplainCommand: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_StreamingQueryCommand.protoMessageName + ".ExplainCommand"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{1}extended\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBoolField(value: &self.extended) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.extended != false {
      try visitor.visitSingularBoolField(value: self.extended, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingQueryCommand.ExplainCommand, rhs: Spark_Connect_StreamingQueryCommand.ExplainCommand) -> Bool {
    if lhs.extended != rhs.extended {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingQueryCommand.AwaitTerminationCommand: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_StreamingQueryCommand.protoMessageName + ".AwaitTerminationCommand"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{4}\u{2}timeout_ms\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 2: try { try decoder.decodeSingularInt64Field(value: &self._timeoutMs) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._timeoutMs {
      try visitor.visitSingularInt64Field(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingQueryCommand.AwaitTerminationCommand, rhs: Spark_Connect_StreamingQueryCommand.AwaitTerminationCommand) -> Bool {
    if lhs._timeoutMs != rhs._timeoutMs {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingQueryCommandResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".StreamingQueryCommandResult"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{3}query_id\0\u{1}status\0\u{3}recent_progress\0\u{1}explain\0\u{1}exception\0\u{3}await_termination\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._queryID) }()
      case 2: try {
        var v: Spark_Connect_StreamingQueryCommandResult.StatusResult?
        var hadOneofValue = false
        if let current = self.resultType {
          hadOneofValue = true
          if case .status(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.resultType = .status(v)
        }
      }()
      case 3: try {
        var v: Spark_Connect_StreamingQueryCommandResult.RecentProgressResult?
        var hadOneofValue = false
        if let current = self.resultType {
          hadOneofValue = true
          if case .recentProgress(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.resultType = .recentProgress(v)
        }
      }()
      case 4: try {
        var v: Spark_Connect_StreamingQueryCommandResult.ExplainResult?
        var hadOneofValue = false
        if let current = self.resultType {
          hadOneofValue = true
          if case .explain(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.resultType = .explain(v)
        }
      }()
      case 5: try {
        var v: Spark_Connect_StreamingQueryCommandResult.ExceptionResult?
        var hadOneofValue = false
        if let current = self.resultType {
          hadOneofValue = true
          if case .exception(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.resultType = .exception(v)
        }
      }()
      case 6: try {
        var v: Spark_Connect_StreamingQueryCommandResult.AwaitTerminationResult?
        var hadOneofValue = false
        if let current = self.resultType {
          hadOneofValue = true
          if case .awaitTermination(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.resultType = .awaitTermination(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._queryID {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    switch self.resultType {
    case .status?: try {
      guard case .status(let v)? = self.resultType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    }()
    case .recentProgress?: try {
      guard case .recentProgress(let v)? = self.resultType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    }()
    case .explain?: try {
      guard case .explain(let v)? = self.resultType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    }()
    case .exception?: try {
      guard case .exception(let v)? = self.resultType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
    }()
    case .awaitTermination?: try {
      guard case .awaitTermination(let v)? = self.resultType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 6)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingQueryCommandResult, rhs: Spark_Connect_StreamingQueryCommandResult) -> Bool {
    if lhs._queryID != rhs._queryID {return false}
    if lhs.resultType != rhs.resultType {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingQueryCommandResult.StatusResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_StreamingQueryCommandResult.protoMessageName + ".StatusResult"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{3}status_message\0\u{3}is_data_available\0\u{3}is_trigger_active\0\u{3}is_active\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.statusMessage) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.isDataAvailable) }()
      case 3: try { try decoder.decodeSingularBoolField(value: &self.isTriggerActive) }()
      case 4: try { try decoder.decodeSingularBoolField(value: &self.isActive) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.statusMessage.isEmpty {
      try visitor.visitSingularStringField(value: self.statusMessage, fieldNumber: 1)
    }
    if self.isDataAvailable != false {
      try visitor.visitSingularBoolField(value: self.isDataAvailable, fieldNumber: 2)
    }
    if self.isTriggerActive != false {
      try visitor.visitSingularBoolField(value: self.isTriggerActive, fieldNumber: 3)
    }
    if self.isActive != false {
      try visitor.visitSingularBoolField(value: self.isActive, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingQueryCommandResult.StatusResult, rhs: Spark_Connect_StreamingQueryCommandResult.StatusResult) -> Bool {
    if lhs.statusMessage != rhs.statusMessage {return false}
    if lhs.isDataAvailable != rhs.isDataAvailable {return false}
    if lhs.isTriggerActive != rhs.isTriggerActive {return false}
    if lhs.isActive != rhs.isActive {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingQueryCommandResult.RecentProgressResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_StreamingQueryCommandResult.protoMessageName + ".RecentProgressResult"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{4}\u{5}recent_progress_json\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 5: try { try decoder.decodeRepeatedStringField(value: &self.recentProgressJson) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.recentProgressJson.isEmpty {
      try visitor.visitRepeatedStringField(value: self.recentProgressJson, fieldNumber: 5)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingQueryCommandResult.RecentProgressResult, rhs: Spark_Connect_StreamingQueryCommandResult.RecentProgressResult) -> Bool {
    if lhs.recentProgressJson != rhs.recentProgressJson {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingQueryCommandResult.ExplainResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_StreamingQueryCommandResult.protoMessageName + ".ExplainResult"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{1}result\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.result) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.result.isEmpty {
      try visitor.visitSingularStringField(value: self.result, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingQueryCommandResult.ExplainResult, rhs: Spark_Connect_StreamingQueryCommandResult.ExplainResult) -> Bool {
    if lhs.result != rhs.result {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingQueryCommandResult.ExceptionResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_StreamingQueryCommandResult.protoMessageName + ".ExceptionResult"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{3}exception_message\0\u{3}error_class\0\u{3}stack_trace\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self._exceptionMessage) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self._errorClass) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self._stackTrace) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._exceptionMessage {
      try visitor.visitSingularStringField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._errorClass {
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    } }()
    try { if let v = self._stackTrace {
      try visitor.visitSingularStringField(value: v, fieldNumber: 3)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingQueryCommandResult.ExceptionResult, rhs: Spark_Connect_StreamingQueryCommandResult.ExceptionResult) -> Bool {
    if lhs._exceptionMessage != rhs._exceptionMessage {return false}
    if lhs._errorClass != rhs._errorClass {return false}
    if lhs._stackTrace != rhs._stackTrace {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingQueryCommandResult.AwaitTerminationResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_StreamingQueryCommandResult.protoMessageName + ".AwaitTerminationResult"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{1}terminated\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBoolField(value: &self.terminated) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.terminated != false {
      try visitor.visitSingularBoolField(value: self.terminated, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingQueryCommandResult.AwaitTerminationResult, rhs: Spark_Connect_StreamingQueryCommandResult.AwaitTerminationResult) -> Bool {
    if lhs.terminated != rhs.terminated {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingQueryManagerCommand: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".StreamingQueryManagerCommand"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{1}active\0\u{3}get_query\0\u{3}await_any_termination\0\u{3}reset_terminated\0\u{3}add_listener\0\u{3}remove_listener\0\u{3}list_listeners\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: Bool?
        try decoder.decodeSingularBoolField(value: &v)
        if let v = v {
          if self.command != nil {try decoder.handleConflictingOneOf()}
          self.command = .active(v)
        }
      }()
      case 2: try {
        var v: String?
        try decoder.decodeSingularStringField(value: &v)
        if let v = v {
          if self.command != nil {try decoder.handleConflictingOneOf()}
          self.command = .getQuery(v)
        }
      }()
      case 3: try {
        var v: Spark_Connect_StreamingQueryManagerCommand.AwaitAnyTerminationCommand?
        var hadOneofValue = false
        if let current = self.command {
          hadOneofValue = true
          if case .awaitAnyTermination(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.command = .awaitAnyTermination(v)
        }
      }()
      case 4: try {
        var v: Bool?
        try decoder.decodeSingularBoolField(value: &v)
        if let v = v {
          if self.command != nil {try decoder.handleConflictingOneOf()}
          self.command = .resetTerminated(v)
        }
      }()
      case 5: try {
        var v: Spark_Connect_StreamingQueryManagerCommand.StreamingQueryListenerCommand?
        var hadOneofValue = false
        if let current = self.command {
          hadOneofValue = true
          if case .addListener(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.command = .addListener(v)
        }
      }()
      case 6: try {
        var v: Spark_Connect_StreamingQueryManagerCommand.StreamingQueryListenerCommand?
        var hadOneofValue = false
        if let current = self.command {
          hadOneofValue = true
          if case .removeListener(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.command = .removeListener(v)
        }
      }()
      case 7: try {
        var v: Bool?
        try decoder.decodeSingularBoolField(value: &v)
        if let v = v {
          if self.command != nil {try decoder.handleConflictingOneOf()}
          self.command = .listListeners(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.command {
    case .active?: try {
      guard case .active(let v)? = self.command else { preconditionFailure() }
      try visitor.visitSingularBoolField(value: v, fieldNumber: 1)
    }()
    case .getQuery?: try {
      guard case .getQuery(let v)? = self.command else { preconditionFailure() }
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    }()
    case .awaitAnyTermination?: try {
      guard case .awaitAnyTermination(let v)? = self.command else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    }()
    case .resetTerminated?: try {
      guard case .resetTerminated(let v)? = self.command else { preconditionFailure() }
      try visitor.visitSingularBoolField(value: v, fieldNumber: 4)
    }()
    case .addListener?: try {
      guard case .addListener(let v)? = self.command else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
    }()
    case .removeListener?: try {
      guard case .removeListener(let v)? = self.command else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 6)
    }()
    case .listListeners?: try {
      guard case .listListeners(let v)? = self.command else { preconditionFailure() }
      try visitor.visitSingularBoolField(value: v, fieldNumber: 7)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingQueryManagerCommand, rhs: Spark_Connect_StreamingQueryManagerCommand) -> Bool {
    if lhs.command != rhs.command {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingQueryManagerCommand.AwaitAnyTerminationCommand: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_StreamingQueryManagerCommand.protoMessageName + ".AwaitAnyTerminationCommand"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{3}timeout_ms\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self._timeoutMs) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._timeoutMs {
      try visitor.visitSingularInt64Field(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingQueryManagerCommand.AwaitAnyTerminationCommand, rhs: Spark_Connect_StreamingQueryManagerCommand.AwaitAnyTerminationCommand) -> Bool {
    if lhs._timeoutMs != rhs._timeoutMs {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingQueryManagerCommand.StreamingQueryListenerCommand: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_StreamingQueryManagerCommand.protoMessageName + ".StreamingQueryListenerCommand"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{3}listener_payload\0\u{3}python_listener_payload\0\u{1}id\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.listenerPayload) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._pythonListenerPayload) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self.id) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.listenerPayload.isEmpty {
      try visitor.visitSingularBytesField(value: self.listenerPayload, fieldNumber: 1)
    }
    try { if let v = self._pythonListenerPayload {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    if !self.id.isEmpty {
      try visitor.visitSingularStringField(value: self.id, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingQueryManagerCommand.StreamingQueryListenerCommand, rhs: Spark_Connect_StreamingQueryManagerCommand.StreamingQueryListenerCommand) -> Bool {
    if lhs.listenerPayload != rhs.listenerPayload {return false}
    if lhs._pythonListenerPayload != rhs._pythonListenerPayload {return false}
    if lhs.id != rhs.id {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingQueryManagerCommandResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".StreamingQueryManagerCommandResult"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{1}active\0\u{1}query\0\u{3}await_any_termination\0\u{3}reset_terminated\0\u{3}add_listener\0\u{3}remove_listener\0\u{3}list_listeners\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: Spark_Connect_StreamingQueryManagerCommandResult.ActiveResult?
        var hadOneofValue = false
        if let current = self.resultType {
          hadOneofValue = true
          if case .active(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.resultType = .active(v)
        }
      }()
      case 2: try {
        var v: Spark_Connect_StreamingQueryManagerCommandResult.StreamingQueryInstance?
        var hadOneofValue = false
        if let current = self.resultType {
          hadOneofValue = true
          if case .query(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.resultType = .query(v)
        }
      }()
      case 3: try {
        var v: Spark_Connect_StreamingQueryManagerCommandResult.AwaitAnyTerminationResult?
        var hadOneofValue = false
        if let current = self.resultType {
          hadOneofValue = true
          if case .awaitAnyTermination(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.resultType = .awaitAnyTermination(v)
        }
      }()
      case 4: try {
        var v: Bool?
        try decoder.decodeSingularBoolField(value: &v)
        if let v = v {
          if self.resultType != nil {try decoder.handleConflictingOneOf()}
          self.resultType = .resetTerminated(v)
        }
      }()
      case 5: try {
        var v: Bool?
        try decoder.decodeSingularBoolField(value: &v)
        if let v = v {
          if self.resultType != nil {try decoder.handleConflictingOneOf()}
          self.resultType = .addListener(v)
        }
      }()
      case 6: try {
        var v: Bool?
        try decoder.decodeSingularBoolField(value: &v)
        if let v = v {
          if self.resultType != nil {try decoder.handleConflictingOneOf()}
          self.resultType = .removeListener(v)
        }
      }()
      case 7: try {
        var v: Spark_Connect_StreamingQueryManagerCommandResult.ListStreamingQueryListenerResult?
        var hadOneofValue = false
        if let current = self.resultType {
          hadOneofValue = true
          if case .listListeners(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.resultType = .listListeners(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.resultType {
    case .active?: try {
      guard case .active(let v)? = self.resultType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    }()
    case .query?: try {
      guard case .query(let v)? = self.resultType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    }()
    case .awaitAnyTermination?: try {
      guard case .awaitAnyTermination(let v)? = self.resultType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    }()
    case .resetTerminated?: try {
      guard case .resetTerminated(let v)? = self.resultType else { preconditionFailure() }
      try visitor.visitSingularBoolField(value: v, fieldNumber: 4)
    }()
    case .addListener?: try {
      guard case .addListener(let v)? = self.resultType else { preconditionFailure() }
      try visitor.visitSingularBoolField(value: v, fieldNumber: 5)
    }()
    case .removeListener?: try {
      guard case .removeListener(let v)? = self.resultType else { preconditionFailure() }
      try visitor.visitSingularBoolField(value: v, fieldNumber: 6)
    }()
    case .listListeners?: try {
      guard case .listListeners(let v)? = self.resultType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 7)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingQueryManagerCommandResult, rhs: Spark_Connect_StreamingQueryManagerCommandResult) -> Bool {
    if lhs.resultType != rhs.resultType {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingQueryManagerCommandResult.ActiveResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_StreamingQueryManagerCommandResult.protoMessageName + ".ActiveResult"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{3}active_queries\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.activeQueries) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.activeQueries.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.activeQueries, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingQueryManagerCommandResult.ActiveResult, rhs: Spark_Connect_StreamingQueryManagerCommandResult.ActiveResult) -> Bool {
    if lhs.activeQueries != rhs.activeQueries {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingQueryManagerCommandResult.StreamingQueryInstance: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_StreamingQueryManagerCommandResult.protoMessageName + ".StreamingQueryInstance"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{1}id\0\u{1}name\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._id) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self._name) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._id {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._name {
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingQueryManagerCommandResult.StreamingQueryInstance, rhs: Spark_Connect_StreamingQueryManagerCommandResult.StreamingQueryInstance) -> Bool {
    if lhs._id != rhs._id {return false}
    if lhs._name != rhs._name {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingQueryManagerCommandResult.AwaitAnyTerminationResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_StreamingQueryManagerCommandResult.protoMessageName + ".AwaitAnyTerminationResult"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{1}terminated\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBoolField(value: &self.terminated) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.terminated != false {
      try visitor.visitSingularBoolField(value: self.terminated, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingQueryManagerCommandResult.AwaitAnyTerminationResult, rhs: Spark_Connect_StreamingQueryManagerCommandResult.AwaitAnyTerminationResult) -> Bool {
    if lhs.terminated != rhs.terminated {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingQueryManagerCommandResult.StreamingQueryListenerInstance: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_StreamingQueryManagerCommandResult.protoMessageName + ".StreamingQueryListenerInstance"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{3}listener_payload\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.listenerPayload) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.listenerPayload.isEmpty {
      try visitor.visitSingularBytesField(value: self.listenerPayload, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingQueryManagerCommandResult.StreamingQueryListenerInstance, rhs: Spark_Connect_StreamingQueryManagerCommandResult.StreamingQueryListenerInstance) -> Bool {
    if lhs.listenerPayload != rhs.listenerPayload {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingQueryManagerCommandResult.ListStreamingQueryListenerResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_StreamingQueryManagerCommandResult.protoMessageName + ".ListStreamingQueryListenerResult"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{3}listener_ids\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedStringField(value: &self.listenerIds) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.listenerIds.isEmpty {
      try visitor.visitRepeatedStringField(value: self.listenerIds, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingQueryManagerCommandResult.ListStreamingQueryListenerResult, rhs: Spark_Connect_StreamingQueryManagerCommandResult.ListStreamingQueryListenerResult) -> Bool {
    if lhs.listenerIds != rhs.listenerIds {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingQueryListenerBusCommand: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".StreamingQueryListenerBusCommand"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{3}add_listener_bus_listener\0\u{3}remove_listener_bus_listener\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: Bool?
        try decoder.decodeSingularBoolField(value: &v)
        if let v = v {
          if self.command != nil {try decoder.handleConflictingOneOf()}
          self.command = .addListenerBusListener(v)
        }
      }()
      case 2: try {
        var v: Bool?
        try decoder.decodeSingularBoolField(value: &v)
        if let v = v {
          if self.command != nil {try decoder.handleConflictingOneOf()}
          self.command = .removeListenerBusListener(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.command {
    case .addListenerBusListener?: try {
      guard case .addListenerBusListener(let v)? = self.command else { preconditionFailure() }
      try visitor.visitSingularBoolField(value: v, fieldNumber: 1)
    }()
    case .removeListenerBusListener?: try {
      guard case .removeListenerBusListener(let v)? = self.command else { preconditionFailure() }
      try visitor.visitSingularBoolField(value: v, fieldNumber: 2)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingQueryListenerBusCommand, rhs: Spark_Connect_StreamingQueryListenerBusCommand) -> Bool {
    if lhs.command != rhs.command {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingQueryListenerEvent: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".StreamingQueryListenerEvent"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{3}event_json\0\u{3}event_type\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.eventJson) }()
      case 2: try { try decoder.decodeSingularEnumField(value: &self.eventType) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.eventJson.isEmpty {
      try visitor.visitSingularStringField(value: self.eventJson, fieldNumber: 1)
    }
    if self.eventType != .queryProgressUnspecified {
      try visitor.visitSingularEnumField(value: self.eventType, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingQueryListenerEvent, rhs: Spark_Connect_StreamingQueryListenerEvent) -> Bool {
    if lhs.eventJson != rhs.eventJson {return false}
    if lhs.eventType != rhs.eventType {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StreamingQueryListenerEventsResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".StreamingQueryListenerEventsResult"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{1}events\0\u{3}listener_bus_listener_added\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.events) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self._listenerBusListenerAdded) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.events.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.events, fieldNumber: 1)
    }
    try { if let v = self._listenerBusListenerAdded {
      try visitor.visitSingularBoolField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StreamingQueryListenerEventsResult, rhs: Spark_Connect_StreamingQueryListenerEventsResult) -> Bool {
    if lhs.events != rhs.events {return false}
    if lhs._listenerBusListenerAdded != rhs._listenerBusListenerAdded {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_GetResourcesCommand: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".GetResourcesCommand"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    // Load everything into unknown fields
    while try decoder.nextFieldNumber() != nil {}
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_GetResourcesCommand, rhs: Spark_Connect_GetResourcesCommand) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_GetResourcesCommandResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".GetResourcesCommandResult"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{1}resources\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,Spark_Connect_ResourceInformation>.self, value: &self.resources) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.resources.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,Spark_Connect_ResourceInformation>.self, value: self.resources, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_GetResourcesCommandResult, rhs: Spark_Connect_GetResourcesCommandResult) -> Bool {
    if lhs.resources != rhs.resources {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_CreateResourceProfileCommand: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CreateResourceProfileCommand"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{1}profile\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._profile) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._profile {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_CreateResourceProfileCommand, rhs: Spark_Connect_CreateResourceProfileCommand) -> Bool {
    if lhs._profile != rhs._profile {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_CreateResourceProfileCommandResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CreateResourceProfileCommandResult"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{3}profile_id\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt32Field(value: &self.profileID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.profileID != 0 {
      try visitor.visitSingularInt32Field(value: self.profileID, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_CreateResourceProfileCommandResult, rhs: Spark_Connect_CreateResourceProfileCommandResult) -> Bool {
    if lhs.profileID != rhs.profileID {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_RemoveCachedRemoteRelationCommand: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".RemoveCachedRemoteRelationCommand"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{1}relation\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._relation) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._relation {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_RemoveCachedRemoteRelationCommand, rhs: Spark_Connect_RemoveCachedRemoteRelationCommand) -> Bool {
    if lhs._relation != rhs._relation {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_CheckpointCommand: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CheckpointCommand"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{1}relation\0\u{1}local\0\u{1}eager\0\u{3}storage_level\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._relation) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.local) }()
      case 3: try { try decoder.decodeSingularBoolField(value: &self.eager) }()
      case 4: try { try decoder.decodeSingularMessageField(value: &self._storageLevel) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._relation {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    if self.local != false {
      try visitor.visitSingularBoolField(value: self.local, fieldNumber: 2)
    }
    if self.eager != false {
      try visitor.visitSingularBoolField(value: self.eager, fieldNumber: 3)
    }
    try { if let v = self._storageLevel {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_CheckpointCommand, rhs: Spark_Connect_CheckpointCommand) -> Bool {
    if lhs._relation != rhs._relation {return false}
    if lhs.local != rhs.local {return false}
    if lhs.eager != rhs.eager {return false}
    if lhs._storageLevel != rhs._storageLevel {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_MergeIntoTableCommand: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".MergeIntoTableCommand"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{3}target_table_name\0\u{3}source_table_plan\0\u{3}merge_condition\0\u{3}match_actions\0\u{3}not_matched_actions\0\u{3}not_matched_by_source_actions\0\u{3}with_schema_evolution\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.targetTableName) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._sourceTablePlan) }()
      case 3: try { try decoder.decodeSingularMessageField(value: &self._mergeCondition) }()
      case 4: try { try decoder.decodeRepeatedMessageField(value: &self.matchActions) }()
      case 5: try { try decoder.decodeRepeatedMessageField(value: &self.notMatchedActions) }()
      case 6: try { try decoder.decodeRepeatedMessageField(value: &self.notMatchedBySourceActions) }()
      case 7: try { try decoder.decodeSingularBoolField(value: &self.withSchemaEvolution) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.targetTableName.isEmpty {
      try visitor.visitSingularStringField(value: self.targetTableName, fieldNumber: 1)
    }
    try { if let v = self._sourceTablePlan {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try { if let v = self._mergeCondition {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    } }()
    if !self.matchActions.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.matchActions, fieldNumber: 4)
    }
    if !self.notMatchedActions.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.notMatchedActions, fieldNumber: 5)
    }
    if !self.notMatchedBySourceActions.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.notMatchedBySourceActions, fieldNumber: 6)
    }
    if self.withSchemaEvolution != false {
      try visitor.visitSingularBoolField(value: self.withSchemaEvolution, fieldNumber: 7)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_MergeIntoTableCommand, rhs: Spark_Connect_MergeIntoTableCommand) -> Bool {
    if lhs.targetTableName != rhs.targetTableName {return false}
    if lhs._sourceTablePlan != rhs._sourceTablePlan {return false}
    if lhs._mergeCondition != rhs._mergeCondition {return false}
    if lhs.matchActions != rhs.matchActions {return false}
    if lhs.notMatchedActions != rhs.notMatchedActions {return false}
    if lhs.notMatchedBySourceActions != rhs.notMatchedBySourceActions {return false}
    if lhs.withSchemaEvolution != rhs.withSchemaEvolution {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ExecuteExternalCommand: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ExecuteExternalCommand"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap(bytecode: "\0\u{1}runner\0\u{1}command\0\u{1}options\0")

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.runner) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.command) }()
      case 3: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: &self.options) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.runner.isEmpty {
      try visitor.visitSingularStringField(value: self.runner, fieldNumber: 1)
    }
    if !self.command.isEmpty {
      try visitor.visitSingularStringField(value: self.command, fieldNumber: 2)
    }
    if !self.options.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: self.options, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ExecuteExternalCommand, rhs: Spark_Connect_ExecuteExternalCommand) -> Bool {
    if lhs.runner != rhs.runner {return false}
    if lhs.command != rhs.command {return false}
    if lhs.options != rhs.options {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}
