/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.zookeeper.cli;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.storm.shade.org.apache.zookeeper.KeeperException;
import org.apache.storm.shade.org.apache.zookeeper.cli.CliCommand;
import org.apache.storm.shade.org.apache.zookeeper.cli.CliException;
import org.apache.storm.shade.org.apache.zookeeper.cli.CliParseException;
import org.apache.storm.shade.org.apache.zookeeper.cli.CliWrapperException;
import org.apache.storm.shade.org.apache.zookeeper.cli.MalformedPathException;
import org.apache.storm.shade.org.apache.zookeeper.cli.StatPrinter;
import org.apache.storm.shade.org.apache.zookeeper.data.Stat;

public class SetCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public SetCommand() {
        super("set", "path data [-s] [-v version] [-b]", options);
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        DefaultParser parser = new DefaultParser();
        try {
            this.cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 3) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        String path = this.args[1];
        byte[] data = this.cl.hasOption("b") ? Base64.getDecoder().decode(this.args[2]) : this.args[2].getBytes(StandardCharsets.UTF_8);
        int version = this.cl.hasOption("v") ? Integer.parseInt(this.cl.getOptionValue("v")) : -1;
        try {
            Stat stat = this.zk.setData(path, data, version);
            if (this.cl.hasOption("s")) {
                new StatPrinter(this.out).print(stat);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (InterruptedException | KeeperException ex) {
            throw new CliWrapperException(ex);
        }
        return false;
    }

    static {
        options.addOption("s", false, "Print znode stats additionally");
        options.addOption("v", true, "Set with an expected version");
        options.addOption("b", false, "Supply data in base64 format");
    }
}

