/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.topology;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.storm.spout.CheckPointState;
import org.apache.storm.state.State;
import org.apache.storm.state.StateFactory;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.BaseStatefulBoltExecutor;
import org.apache.storm.topology.IStatefulBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatefulBoltExecutor<T extends State>
extends BaseStatefulBoltExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(StatefulBoltExecutor.class);
    private final IStatefulBolt<T> bolt;
    private State state;
    private boolean boltInitialized = false;
    private List<Tuple> pendingTuples = new ArrayList<Tuple>();
    private List<Tuple> preparedTuples = new ArrayList<Tuple>();
    private AckTrackingOutputCollector collector;

    public StatefulBoltExecutor(IStatefulBolt<T> bolt) {
        this.bolt = bolt;
    }

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
        String namespace = context.getThisComponentId() + "-" + context.getThisTaskId();
        this.prepare(topoConf, context, collector, StateFactory.getState(namespace, topoConf, context));
    }

    void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector, State state) {
        this.init(context, collector);
        this.collector = new AckTrackingOutputCollector(collector);
        this.bolt.prepare(topoConf, context, this.collector);
        this.state = state;
    }

    @Override
    public void cleanup() {
        this.bolt.cleanup();
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this.bolt.declareOutputFields(declarer);
        this.declareCheckpointStream(declarer);
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this.bolt.getComponentConfiguration();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void handleCheckpoint(Tuple checkpointTuple, CheckPointState.Action action, long txid) {
        LOG.debug("handleCheckPoint with tuple {}, action {}, txid {}", new Object[]{checkpointTuple, action, txid});
        if (action == CheckPointState.Action.PREPARE) {
            if (!this.boltInitialized) {
                LOG.debug("Failing checkpointTuple, PREPARE received when bolt state is not initialized.");
                this.collector.fail(checkpointTuple);
                return;
            }
            this.bolt.prePrepare(txid);
            this.state.prepareCommit(txid);
            this.preparedTuples.addAll(this.collector.ackedTuples());
        } else if (action == CheckPointState.Action.COMMIT) {
            this.bolt.preCommit(txid);
            this.state.commit(txid);
            this.ack(this.preparedTuples);
        } else if (action == CheckPointState.Action.ROLLBACK) {
            this.bolt.preRollback();
            this.state.rollback();
            this.fail(this.preparedTuples);
            this.fail(this.collector.ackedTuples());
        } else if (action == CheckPointState.Action.INITSTATE) {
            if (!this.boltInitialized) {
                this.bolt.initState(this.state);
                this.boltInitialized = true;
                LOG.debug("{} pending tuples to process", (Object)this.pendingTuples.size());
                for (Tuple tuple : this.pendingTuples) {
                    this.doExecute(tuple);
                }
                this.pendingTuples.clear();
            } else {
                LOG.debug("Bolt state is already initialized, ignoring tuple {}, action {}, txid {}", new Object[]{checkpointTuple, action, txid});
            }
        }
        this.collector.emit("$checkpoint", checkpointTuple, (List<Object>)new Values(new Object[]{txid, action}));
        this.collector.delegate.ack(checkpointTuple);
    }

    @Override
    protected void handleTuple(Tuple input) {
        if (this.boltInitialized) {
            this.doExecute(input);
        } else {
            LOG.debug("Bolt state not initialized, adding tuple {} to pending tuples", (Object)input);
            this.pendingTuples.add(input);
        }
    }

    private void doExecute(Tuple tuple) {
        this.bolt.execute(tuple);
    }

    private void ack(List<Tuple> tuples) {
        if (!tuples.isEmpty()) {
            LOG.debug("Acking {} tuples", (Object)tuples.size());
            for (Tuple tuple : tuples) {
                this.collector.delegate.ack(tuple);
            }
            tuples.clear();
        }
    }

    private void fail(List<Tuple> tuples) {
        if (!tuples.isEmpty()) {
            LOG.debug("Failing {} tuples", (Object)tuples.size());
            for (Tuple tuple : tuples) {
                this.collector.fail(tuple);
            }
            tuples.clear();
        }
    }

    private static class AckTrackingOutputCollector
    extends BaseStatefulBoltExecutor.AnchoringOutputCollector {
        private final OutputCollector delegate;
        private final Queue<Tuple> ackedTuples;

        AckTrackingOutputCollector(OutputCollector delegate) {
            super(delegate);
            this.delegate = delegate;
            this.ackedTuples = new ConcurrentLinkedQueue<Tuple>();
        }

        List<Tuple> ackedTuples() {
            ArrayList<Tuple> result2 = new ArrayList<Tuple>();
            Iterator it = this.ackedTuples.iterator();
            while (it.hasNext()) {
                result2.add((Tuple)it.next());
                it.remove();
            }
            return result2;
        }

        @Override
        public void ack(Tuple input) {
            this.ackedTuples.add(input);
        }
    }
}

