/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceConversion;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceConversionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceConversionFluentImpl;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionNames;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionNamesBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionNamesFluentImpl;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionSpec;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersion;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersionFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class CustomResourceDefinitionSpecFluentImpl<A extends CustomResourceDefinitionSpecFluent<A>>
extends BaseFluent<A>
implements CustomResourceDefinitionSpecFluent<A> {
    private CustomResourceConversionBuilder conversion;
    private String group;
    private CustomResourceDefinitionNamesBuilder names;
    private Boolean preserveUnknownFields;
    private String scope;
    private List<CustomResourceDefinitionVersionBuilder> versions = new ArrayList<CustomResourceDefinitionVersionBuilder>();

    public CustomResourceDefinitionSpecFluentImpl() {
    }

    public CustomResourceDefinitionSpecFluentImpl(CustomResourceDefinitionSpec instance) {
        this.withConversion(instance.getConversion());
        this.withGroup(instance.getGroup());
        this.withNames(instance.getNames());
        this.withPreserveUnknownFields(instance.getPreserveUnknownFields());
        this.withScope(instance.getScope());
        this.withVersions(instance.getVersions());
    }

    @Override
    @Deprecated
    public CustomResourceConversion getConversion() {
        return this.conversion != null ? this.conversion.build() : null;
    }

    @Override
    public CustomResourceConversion buildConversion() {
        return this.conversion != null ? this.conversion.build() : null;
    }

    @Override
    public A withConversion(CustomResourceConversion conversion) {
        this._visitables.get("conversion").remove(this.conversion);
        if (conversion != null) {
            this.conversion = new CustomResourceConversionBuilder(conversion);
            this._visitables.get("conversion").add(this.conversion);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConversion() {
        return this.conversion != null;
    }

    @Override
    public CustomResourceDefinitionSpecFluent.ConversionNested<A> withNewConversion() {
        return new ConversionNestedImpl();
    }

    @Override
    public CustomResourceDefinitionSpecFluent.ConversionNested<A> withNewConversionLike(CustomResourceConversion item) {
        return new ConversionNestedImpl(item);
    }

    @Override
    public CustomResourceDefinitionSpecFluent.ConversionNested<A> editConversion() {
        return this.withNewConversionLike(this.getConversion());
    }

    @Override
    public CustomResourceDefinitionSpecFluent.ConversionNested<A> editOrNewConversion() {
        return this.withNewConversionLike(this.getConversion() != null ? this.getConversion() : new CustomResourceConversionBuilder().build());
    }

    @Override
    public CustomResourceDefinitionSpecFluent.ConversionNested<A> editOrNewConversionLike(CustomResourceConversion item) {
        return this.withNewConversionLike(this.getConversion() != null ? this.getConversion() : item);
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    @Override
    public Boolean hasGroup() {
        return this.group != null;
    }

    @Override
    @Deprecated
    public A withNewGroup(String arg0) {
        return this.withGroup(new String(arg0));
    }

    @Override
    @Deprecated
    public CustomResourceDefinitionNames getNames() {
        return this.names != null ? this.names.build() : null;
    }

    @Override
    public CustomResourceDefinitionNames buildNames() {
        return this.names != null ? this.names.build() : null;
    }

    @Override
    public A withNames(CustomResourceDefinitionNames names) {
        this._visitables.get("names").remove(this.names);
        if (names != null) {
            this.names = new CustomResourceDefinitionNamesBuilder(names);
            this._visitables.get("names").add(this.names);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNames() {
        return this.names != null;
    }

    @Override
    public CustomResourceDefinitionSpecFluent.NamesNested<A> withNewNames() {
        return new NamesNestedImpl();
    }

    @Override
    public CustomResourceDefinitionSpecFluent.NamesNested<A> withNewNamesLike(CustomResourceDefinitionNames item) {
        return new NamesNestedImpl(item);
    }

    @Override
    public CustomResourceDefinitionSpecFluent.NamesNested<A> editNames() {
        return this.withNewNamesLike(this.getNames());
    }

    @Override
    public CustomResourceDefinitionSpecFluent.NamesNested<A> editOrNewNames() {
        return this.withNewNamesLike(this.getNames() != null ? this.getNames() : new CustomResourceDefinitionNamesBuilder().build());
    }

    @Override
    public CustomResourceDefinitionSpecFluent.NamesNested<A> editOrNewNamesLike(CustomResourceDefinitionNames item) {
        return this.withNewNamesLike(this.getNames() != null ? this.getNames() : item);
    }

    @Override
    public Boolean getPreserveUnknownFields() {
        return this.preserveUnknownFields;
    }

    @Override
    public A withPreserveUnknownFields(Boolean preserveUnknownFields) {
        this.preserveUnknownFields = preserveUnknownFields;
        return (A)this;
    }

    @Override
    public Boolean hasPreserveUnknownFields() {
        return this.preserveUnknownFields != null;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public A withScope(String scope) {
        this.scope = scope;
        return (A)this;
    }

    @Override
    public Boolean hasScope() {
        return this.scope != null;
    }

    @Override
    @Deprecated
    public A withNewScope(String arg0) {
        return this.withScope(new String(arg0));
    }

    @Override
    public A addToVersions(int index, CustomResourceDefinitionVersion item) {
        if (this.versions == null) {
            this.versions = new ArrayList<CustomResourceDefinitionVersionBuilder>();
        }
        CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);
        this._visitables.get("versions").add(index >= 0 ? index : this._visitables.get("versions").size(), builder);
        this.versions.add(index >= 0 ? index : this.versions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVersions(int index, CustomResourceDefinitionVersion item) {
        if (this.versions == null) {
            this.versions = new ArrayList<CustomResourceDefinitionVersionBuilder>();
        }
        CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);
        if (index < 0 || index >= this._visitables.get("versions").size()) {
            this._visitables.get("versions").add(builder);
        } else {
            this._visitables.get("versions").set(index, builder);
        }
        if (index < 0 || index >= this.versions.size()) {
            this.versions.add(builder);
        } else {
            this.versions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVersions(CustomResourceDefinitionVersion ... items) {
        if (this.versions == null) {
            this.versions = new ArrayList<CustomResourceDefinitionVersionBuilder>();
        }
        for (CustomResourceDefinitionVersion item : items) {
            CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);
            this._visitables.get("versions").add(builder);
            this.versions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVersions(Collection<CustomResourceDefinitionVersion> items) {
        if (this.versions == null) {
            this.versions = new ArrayList<CustomResourceDefinitionVersionBuilder>();
        }
        for (CustomResourceDefinitionVersion item : items) {
            CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);
            this._visitables.get("versions").add(builder);
            this.versions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVersions(CustomResourceDefinitionVersion ... items) {
        for (CustomResourceDefinitionVersion item : items) {
            CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);
            this._visitables.get("versions").remove(builder);
            if (this.versions == null) continue;
            this.versions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVersions(Collection<CustomResourceDefinitionVersion> items) {
        for (CustomResourceDefinitionVersion item : items) {
            CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);
            this._visitables.get("versions").remove(builder);
            if (this.versions == null) continue;
            this.versions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVersions(Predicate<CustomResourceDefinitionVersionBuilder> predicate) {
        if (this.versions == null) {
            return (A)this;
        }
        Iterator<CustomResourceDefinitionVersionBuilder> each = this.versions.iterator();
        Object visitables = this._visitables.get("versions");
        while (each.hasNext()) {
            CustomResourceDefinitionVersionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<CustomResourceDefinitionVersion> getVersions() {
        return CustomResourceDefinitionSpecFluentImpl.build(this.versions);
    }

    @Override
    public List<CustomResourceDefinitionVersion> buildVersions() {
        return CustomResourceDefinitionSpecFluentImpl.build(this.versions);
    }

    @Override
    public CustomResourceDefinitionVersion buildVersion(int index) {
        return this.versions.get(index).build();
    }

    @Override
    public CustomResourceDefinitionVersion buildFirstVersion() {
        return this.versions.get(0).build();
    }

    @Override
    public CustomResourceDefinitionVersion buildLastVersion() {
        return this.versions.get(this.versions.size() - 1).build();
    }

    @Override
    public CustomResourceDefinitionVersion buildMatchingVersion(Predicate<CustomResourceDefinitionVersionBuilder> predicate) {
        for (CustomResourceDefinitionVersionBuilder item : this.versions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVersion(Predicate<CustomResourceDefinitionVersionBuilder> predicate) {
        for (CustomResourceDefinitionVersionBuilder item : this.versions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVersions(List<CustomResourceDefinitionVersion> versions) {
        if (this.versions != null) {
            this._visitables.get("versions").removeAll(this.versions);
        }
        if (versions != null) {
            this.versions = new ArrayList<CustomResourceDefinitionVersionBuilder>();
            for (CustomResourceDefinitionVersion item : versions) {
                this.addToVersions(item);
            }
        } else {
            this.versions = null;
        }
        return (A)this;
    }

    @Override
    public A withVersions(CustomResourceDefinitionVersion ... versions) {
        if (this.versions != null) {
            this.versions.clear();
        }
        if (versions != null) {
            for (CustomResourceDefinitionVersion item : versions) {
                this.addToVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVersions() {
        return this.versions != null && !this.versions.isEmpty();
    }

    @Override
    public CustomResourceDefinitionSpecFluent.VersionsNested<A> addNewVersion() {
        return new VersionsNestedImpl();
    }

    @Override
    public CustomResourceDefinitionSpecFluent.VersionsNested<A> addNewVersionLike(CustomResourceDefinitionVersion item) {
        return new VersionsNestedImpl(-1, item);
    }

    @Override
    public CustomResourceDefinitionSpecFluent.VersionsNested<A> setNewVersionLike(int index, CustomResourceDefinitionVersion item) {
        return new VersionsNestedImpl(index, item);
    }

    @Override
    public CustomResourceDefinitionSpecFluent.VersionsNested<A> editVersion(int index) {
        if (this.versions.size() <= index) {
            throw new RuntimeException("Can't edit versions. Index exceeds size.");
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    @Override
    public CustomResourceDefinitionSpecFluent.VersionsNested<A> editFirstVersion() {
        if (this.versions.size() == 0) {
            throw new RuntimeException("Can't edit first versions. The list is empty.");
        }
        return this.setNewVersionLike(0, this.buildVersion(0));
    }

    @Override
    public CustomResourceDefinitionSpecFluent.VersionsNested<A> editLastVersion() {
        int index = this.versions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last versions. The list is empty.");
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    @Override
    public CustomResourceDefinitionSpecFluent.VersionsNested<A> editMatchingVersion(Predicate<CustomResourceDefinitionVersionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.versions.size(); ++i) {
            if (!predicate.test(this.versions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching versions. No match found.");
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomResourceDefinitionSpecFluentImpl that = (CustomResourceDefinitionSpecFluentImpl)o;
        if (this.conversion != null ? !this.conversion.equals(that.conversion) : that.conversion != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.names != null ? !this.names.equals(that.names) : that.names != null) {
            return false;
        }
        if (this.preserveUnknownFields != null ? !this.preserveUnknownFields.equals(that.preserveUnknownFields) : that.preserveUnknownFields != null) {
            return false;
        }
        if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) {
            return false;
        }
        return !(this.versions != null ? !this.versions.equals(that.versions) : that.versions != null);
    }

    public int hashCode() {
        return Objects.hash(this.conversion, this.group, this.names, this.preserveUnknownFields, this.scope, this.versions, super.hashCode());
    }

    public class VersionsNestedImpl<N>
    extends CustomResourceDefinitionVersionFluentImpl<CustomResourceDefinitionSpecFluent.VersionsNested<N>>
    implements CustomResourceDefinitionSpecFluent.VersionsNested<N>,
    Nested<N> {
        private final CustomResourceDefinitionVersionBuilder builder;
        private final int index;

        VersionsNestedImpl(int index, CustomResourceDefinitionVersion item) {
            this.index = index;
            this.builder = new CustomResourceDefinitionVersionBuilder(this, item);
        }

        VersionsNestedImpl() {
            this.index = -1;
            this.builder = new CustomResourceDefinitionVersionBuilder(this);
        }

        @Override
        public N and() {
            return (N)CustomResourceDefinitionSpecFluentImpl.this.setToVersions(this.index, this.builder.build());
        }

        @Override
        public N endVersion() {
            return this.and();
        }
    }

    public class NamesNestedImpl<N>
    extends CustomResourceDefinitionNamesFluentImpl<CustomResourceDefinitionSpecFluent.NamesNested<N>>
    implements CustomResourceDefinitionSpecFluent.NamesNested<N>,
    Nested<N> {
        private final CustomResourceDefinitionNamesBuilder builder;

        NamesNestedImpl(CustomResourceDefinitionNames item) {
            this.builder = new CustomResourceDefinitionNamesBuilder(this, item);
        }

        NamesNestedImpl() {
            this.builder = new CustomResourceDefinitionNamesBuilder(this);
        }

        @Override
        public N and() {
            return (N)CustomResourceDefinitionSpecFluentImpl.this.withNames(this.builder.build());
        }

        @Override
        public N endNames() {
            return this.and();
        }
    }

    public class ConversionNestedImpl<N>
    extends CustomResourceConversionFluentImpl<CustomResourceDefinitionSpecFluent.ConversionNested<N>>
    implements CustomResourceDefinitionSpecFluent.ConversionNested<N>,
    Nested<N> {
        private final CustomResourceConversionBuilder builder;

        ConversionNestedImpl(CustomResourceConversion item) {
            this.builder = new CustomResourceConversionBuilder(this, item);
        }

        ConversionNestedImpl() {
            this.builder = new CustomResourceConversionBuilder(this);
        }

        @Override
        public N and() {
            return (N)CustomResourceDefinitionSpecFluentImpl.this.withConversion(this.builder.build());
        }

        @Override
        public N endConversion() {
            return this.and();
        }
    }
}

