/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.util;

import java.util.Properties;
import org.springframework.util.StringUtils;
import org.springmodules.cache.regex.Match;
import org.springmodules.cache.regex.Perl5Regex;
import org.springmodules.cache.regex.Regex;

public abstract class SemicolonSeparatedPropertiesParser {
    private static final Regex KEY_VALUE_REGEX = new Perl5Regex("([\\w]+)=([\\w /,\\*.:=&?]+)");
    private static final String PROPERTY_DELIMITER = ";";

    public static Properties parseProperties(String text) throws IllegalArgumentException {
        String newText = text;
        if (!StringUtils.hasText((String)newText)) {
            return null;
        }
        if (newText.endsWith(PROPERTY_DELIMITER) && !StringUtils.hasText((String)(newText = newText.substring(0, newText.length() - PROPERTY_DELIMITER.length())))) {
            return null;
        }
        Properties properties = new Properties();
        String[] propertiesAsText = StringUtils.delimitedListToStringArray((String)newText, (String)PROPERTY_DELIMITER);
        int propertyCount = propertiesAsText.length;
        for (int i = 0; i < propertyCount; ++i) {
            String property = propertiesAsText[i];
            Match match = KEY_VALUE_REGEX.match(property);
            if (!match.isSuccessful()) {
                String message = "The String " + StringUtils.quote((String)property) + " should match the regular expression pattern " + StringUtils.quote((String)KEY_VALUE_REGEX.getPattern());
                throw new IllegalArgumentException(message);
            }
            String[] groups = match.getGroups();
            String key = groups[1].trim();
            String value = groups[2].trim();
            if (properties.containsKey(key)) {
                throw new IllegalArgumentException("The property " + StringUtils.quote((String)key) + " is specified more than once");
            }
            properties.setProperty(key, value);
        }
        return properties;
    }
}

