/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.EnumSet;
import java.util.Set;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.FrameworkUtil;
import org.identityconnectors.framework.common.objects.AttributeInfo;

public final class AttributeInfoBuilder {
    private String name;
    private Class<?> type;
    private String subtype;
    private String nativeName;
    private final EnumSet<AttributeInfo.Flags> flags;

    public AttributeInfoBuilder() {
        this.setType(String.class);
        this.flags = EnumSet.noneOf(AttributeInfo.Flags.class);
    }

    public AttributeInfoBuilder(String name) {
        this(name, String.class);
    }

    public AttributeInfoBuilder(String name, Class<?> type) {
        this.setName(name);
        this.setType(type);
        this.flags = EnumSet.noneOf(AttributeInfo.Flags.class);
    }

    public AttributeInfo build() {
        return new AttributeInfo(this.name, this.type, this.subtype, this.nativeName, this.flags);
    }

    public AttributeInfoBuilder setName(String name) {
        if (StringUtil.isBlank(name)) {
            throw new IllegalArgumentException("Argument must not be blank.");
        }
        this.name = name;
        return this;
    }

    public AttributeInfoBuilder setType(Class<?> value) {
        FrameworkUtil.checkAttributeType(value);
        this.type = value;
        return this;
    }

    public AttributeInfoBuilder setSubtype(String subtype) {
        this.subtype = subtype;
        return this;
    }

    public AttributeInfoBuilder setSubtype(AttributeInfo.Subtypes subtype) {
        this.subtype = subtype.toString();
        return this;
    }

    public AttributeInfoBuilder setNativeName(String nativeName) {
        this.nativeName = nativeName;
        return this;
    }

    public AttributeInfoBuilder setReadable(boolean value) {
        this.setFlag(AttributeInfo.Flags.NOT_READABLE, !value);
        return this;
    }

    public AttributeInfoBuilder setCreateable(boolean value) {
        this.setFlag(AttributeInfo.Flags.NOT_CREATABLE, !value);
        return this;
    }

    public AttributeInfoBuilder setRequired(boolean value) {
        this.setFlag(AttributeInfo.Flags.REQUIRED, value);
        return this;
    }

    public AttributeInfoBuilder setMultiValued(boolean value) {
        this.setFlag(AttributeInfo.Flags.MULTIVALUED, value);
        return this;
    }

    public AttributeInfoBuilder setUpdateable(boolean value) {
        this.setFlag(AttributeInfo.Flags.NOT_UPDATEABLE, !value);
        return this;
    }

    public AttributeInfoBuilder setReturnedByDefault(boolean value) {
        this.setFlag(AttributeInfo.Flags.NOT_RETURNED_BY_DEFAULT, !value);
        return this;
    }

    public AttributeInfoBuilder setFlags(Set<AttributeInfo.Flags> flags) {
        this.flags.clear();
        if (flags != null) {
            this.flags.addAll(flags);
        }
        return this;
    }

    private void setFlag(AttributeInfo.Flags flag, boolean value) {
        if (value) {
            this.flags.add(flag);
        } else {
            this.flags.remove((Object)flag);
        }
    }

    public static AttributeInfo build(String name, Class<?> type, Set<AttributeInfo.Flags> flags) {
        return new AttributeInfoBuilder(name, type).setFlags(flags).build();
    }

    public static AttributeInfo build(String name, Class<?> type) {
        return AttributeInfoBuilder.build(name, type, null);
    }

    public static AttributeInfo build(String name) {
        return AttributeInfoBuilder.build(name, String.class);
    }

    public static AttributeInfoBuilder define(String name) {
        return new AttributeInfoBuilder(name, String.class);
    }

    public static AttributeInfoBuilder define(String name, Class<?> type) {
        return new AttributeInfoBuilder(name, type);
    }
}

