/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.Map;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.cmd.NeedsActiveExecutionCmd;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.impl.util.VariableListenerUtil;

public class SetExecutionVariablesCmd
extends NeedsActiveExecutionCmd<Object> {
    private static final long serialVersionUID = 1L;
    protected Map<String, ? extends Object> variables;
    protected boolean isLocal;

    public SetExecutionVariablesCmd(String executionId, Map<String, ? extends Object> variables, boolean isLocal) {
        super(executionId);
        this.variables = variables;
        this.isLocal = isLocal;
    }

    @Override
    protected Object execute(CommandContext commandContext, ExecutionEntity execution) {
        if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, execution.getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            compatibilityHandler.setExecutionVariables(this.executionId, this.variables, this.isLocal);
            return null;
        }
        if (this.isLocal) {
            if (this.variables != null) {
                for (String variableName : this.variables.keySet()) {
                    execution.setVariableLocal(variableName, this.variables.get(variableName), false);
                }
            }
        } else if (this.variables != null) {
            for (String variableName : this.variables.keySet()) {
                execution.setVariable(variableName, this.variables.get(variableName), false);
            }
        }
        execution.forceUpdate();
        if (VariableListenerUtil.hasVariableListenerEventDefinitions(execution.getProcessDefinitionId())) {
            CommandContextUtil.getAgenda(commandContext).planEvaluateVariableListenerEventsOperation(execution.getProcessDefinitionId(), execution.getProcessInstanceId());
        }
        return null;
    }

    @Override
    protected String getSuspendedExceptionMessage() {
        return "Cannot set variables because execution '" + this.executionId + "' is suspended";
    }
}

