/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.CollectionUtils;
import org.springframework.webflow.execution.Event;

public class EventFactorySupport {
    private static final String SUCCESS_EVENT_ID = "success";
    private static final String ERROR_EVENT_ID = "error";
    private static final String YES_EVENT_ID = "yes";
    private static final String NO_EVENT_ID = "no";
    private static final String NULL_EVENT_ID = "null";
    private static final String EXCEPTION_ATTRIBUTE_NAME = "exception";
    private static final String RESULT_ATTRIBUTE_NAME = "result";
    private String successEventId = "success";
    private String errorEventId = "error";
    private String yesEventId = "yes";
    private String noEventId = "no";
    private String nullEventId = "null";
    private String exceptionAttributeName = "exception";
    private String resultAttributeName = "result";

    public String getSuccessEventId() {
        return this.successEventId;
    }

    public void setSuccessEventId(String successEventId) {
        this.successEventId = successEventId;
    }

    public String getErrorEventId() {
        return this.errorEventId;
    }

    public void setErrorEventId(String errorEventId) {
        this.errorEventId = errorEventId;
    }

    public String getYesEventId() {
        return this.yesEventId;
    }

    public void setYesEventId(String yesEventId) {
        this.yesEventId = yesEventId;
    }

    public String getNoEventId() {
        return this.noEventId;
    }

    public void setNoEventId(String noEventId) {
        this.noEventId = noEventId;
    }

    public String getNullEventId() {
        return this.nullEventId;
    }

    public void setNullEventId(String nullEventId) {
        this.nullEventId = nullEventId;
    }

    public String getExceptionAttributeName() {
        return this.exceptionAttributeName;
    }

    public void setExceptionAttributeName(String exceptionAttributeName) {
        this.exceptionAttributeName = exceptionAttributeName;
    }

    public String getResultAttributeName() {
        return this.resultAttributeName;
    }

    public void setResultAttributeName(String resultAttributeName) {
        this.resultAttributeName = resultAttributeName;
    }

    public Event success(Object source) {
        return this.event(source, this.getSuccessEventId());
    }

    public Event success(Object source, Object result) {
        return this.event(source, this.getSuccessEventId(), this.getResultAttributeName(), result);
    }

    public Event error(Object source) {
        return this.event(source, this.getErrorEventId());
    }

    public Event error(Object source, Exception e) {
        return this.event(source, this.getErrorEventId(), this.getExceptionAttributeName(), e);
    }

    public Event yes(Object source) {
        return this.event(source, this.getYesEventId());
    }

    public Event no(Object source) {
        return this.event(source, this.getNoEventId());
    }

    public Event event(Object source, boolean booleanResult) {
        if (booleanResult) {
            return this.yes(source);
        }
        return this.no(source);
    }

    public Event event(Object source, String eventId) {
        return new Event(source, eventId, null);
    }

    public Event event(Object source, String eventId, AttributeMap<Object> attributes) {
        return new Event(source, eventId, attributes);
    }

    public Event event(Object source, String eventId, String attributeName, Object attributeValue) {
        return new Event(source, eventId, CollectionUtils.singleEntryMap(attributeName, attributeValue));
    }
}

