/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net;

import com.tc.exception.TCRuntimeException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class TCSocketAddress {
    public static final String LOOPBACK_IP = "127.0.0.1";
    public static final String COMPRESSED_LOOPBACK_IPv6 = "::1";
    public static final String NATURAL_LOOPBACK_IPv6 = "0:0:0:0:0:0:0:1";
    public static final String WILDCARD_IP = "0.0.0.0";
    public static final String COMPRESSED_WILDCARD_IPv6 = "::";
    public static final String NATURAL_WILDCARD_IPv6 = "0:0:0:0:0:0:0:0";
    private static final InetAddress WILDCARD_ADDR;
    private static final InetAddress WILDCARD_ADDR_IPv6;
    private static final InetAddress LOOPBACK_ADDR;
    private static final InetAddress LOOPBACK_ADDR_IPv6;

    public static String getStringForm(InetSocketAddress addr) {
        StringBuilder buf = new StringBuilder();
        String hostAddr = addr.getHostString();
        if (!TCSocketAddress.isWildcardAddress(hostAddr)) {
            boolean isPhysicalIPv6 = hostAddr.contains(":");
            if (isPhysicalIPv6) {
                buf.append("[");
            }
            buf.append(hostAddr);
            if (isPhysicalIPv6) {
                buf.append("]");
            }
        } else {
            buf.append("*");
        }
        buf.append(":").append(addr.getPort());
        return buf.toString();
    }

    public static String getCanonicalStringForm(InetSocketAddress addr) {
        StringBuilder buf = new StringBuilder();
        String hostAddr = addr.getAddress().getCanonicalHostName();
        if (!TCSocketAddress.isWildcardAddress(hostAddr)) {
            boolean isPhysicalIPv6 = hostAddr.contains(":");
            if (isPhysicalIPv6) {
                buf.append("[");
            }
            buf.append(hostAddr);
            if (isPhysicalIPv6) {
                buf.append("]");
            }
        }
        buf.append(":").append(addr.getPort());
        return buf.toString();
    }

    public static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public static boolean isWildcardAddress(String txt) {
        return WILDCARD_IP.equals(txt) || COMPRESSED_WILDCARD_IPv6.equals(txt) || NATURAL_WILDCARD_IPv6.equals(txt);
    }

    public static boolean isLoopbackAddress(String txt) {
        return LOOPBACK_IP.equals(txt) || COMPRESSED_LOOPBACK_IPv6.equals(txt) || NATURAL_WILDCARD_IPv6.equals(txt);
    }

    static {
        InetAddress lookup = null;
        try {
            WILDCARD_ADDR = InetAddress.getByName(WILDCARD_IP);
        }
        catch (UnknownHostException e) {
            throw new TCRuntimeException("Cannot create InetAddress instance for 0.0.0.0");
        }
        try {
            lookup = InetAddress.getByName(COMPRESSED_WILDCARD_IPv6);
        }
        catch (UnknownHostException e) {
            try {
                lookup = InetAddress.getByName(NATURAL_WILDCARD_IPv6);
            }
            catch (UnknownHostException f) {
                throw new TCRuntimeException("Cannot create InetAddress instance for 0:0:0:0:0:0:0:0");
            }
        }
        WILDCARD_ADDR_IPv6 = lookup;
        try {
            LOOPBACK_ADDR = InetAddress.getByName(LOOPBACK_IP);
        }
        catch (UnknownHostException e) {
            throw new TCRuntimeException("Cannot create InetAddress instance for 127.0.0.1");
        }
        lookup = null;
        try {
            lookup = InetAddress.getByName(COMPRESSED_LOOPBACK_IPv6);
        }
        catch (UnknownHostException e) {
            try {
                lookup = InetAddress.getByName(NATURAL_LOOPBACK_IPv6);
            }
            catch (UnknownHostException f) {
                throw new TCRuntimeException("Cannot create InetAddress instance for 0:0:0:0:0:0:0:1");
            }
        }
        LOOPBACK_ADDR_IPv6 = lookup;
    }
}

