/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f.storage;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.yubico.u2f.data.DeviceRegistration;
import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import lombok.Generated;
import org.apereo.cas.util.function.FunctionUtils;
import org.springframework.data.annotation.Id;

@MappedSuperclass
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class U2FDeviceRegistration
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7258490070277856614L;
    @Id
    @Transient
    @JsonProperty(value="id")
    private long id;
    @Column(nullable=false)
    @JsonProperty(value="username")
    private String username;
    @Lob
    @Column(name="record", length=0x7FFFFFFF)
    @JsonProperty(value="record")
    private String record;
    @Column(nullable=false, columnDefinition="TIMESTAMP")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    @JsonProperty(value="createdDate")
    private LocalDate createdDate;

    public U2FDeviceRegistration() {
        this.setId(System.nanoTime());
    }

    @JsonIgnore
    public U2FDeviceRegistration clone() {
        return (U2FDeviceRegistration)FunctionUtils.doUnchecked(() -> (U2FDeviceRegistration)super.clone());
    }

    public boolean matches(U2FDeviceRegistration device) {
        return (Boolean)FunctionUtils.doUnchecked(() -> {
            if (device.getUsername().equals(this.getUsername())) {
                DeviceRegistration requested = DeviceRegistration.fromJson((String)device.getRecord());
                DeviceRegistration current = DeviceRegistration.fromJson((String)this.getRecord());
                return requested.equals((Object)current);
            }
            return false;
        });
    }

    @Generated
    private static long $default$id() {
        return System.currentTimeMillis();
    }

    @Generated
    private static LocalDate $default$createdDate() {
        return LocalDate.now(Clock.systemUTC());
    }

    @Generated
    protected U2FDeviceRegistration(U2FDeviceRegistrationBuilder<?, ?> b) {
        this.id = b.id$set ? b.id$value : U2FDeviceRegistration.$default$id();
        this.username = b.username;
        this.record = b.record;
        this.createdDate = b.createdDate$set ? b.createdDate$value : U2FDeviceRegistration.$default$createdDate();
    }

    @Generated
    public static U2FDeviceRegistrationBuilder<?, ?> builder() {
        return new U2FDeviceRegistrationBuilderImpl();
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getRecord() {
        return this.record;
    }

    @Generated
    public LocalDate getCreatedDate() {
        return this.createdDate;
    }

    @JsonProperty(value="id")
    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @JsonProperty(value="username")
    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @JsonProperty(value="record")
    @Generated
    public void setRecord(String record) {
        this.record = record;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    @JsonProperty(value="createdDate")
    @Generated
    public void setCreatedDate(LocalDate createdDate) {
        this.createdDate = createdDate;
    }

    @Generated
    public U2FDeviceRegistration(long id, String username, String record, LocalDate createdDate) {
        this.id = id;
        this.username = username;
        this.record = record;
        this.createdDate = createdDate;
    }

    @Generated
    private static final class U2FDeviceRegistrationBuilderImpl
    extends U2FDeviceRegistrationBuilder<U2FDeviceRegistration, U2FDeviceRegistrationBuilderImpl> {
        @Generated
        private U2FDeviceRegistrationBuilderImpl() {
        }

        @Override
        @Generated
        protected U2FDeviceRegistrationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public U2FDeviceRegistration build() {
            return new U2FDeviceRegistration(this);
        }
    }

    @Generated
    public static abstract class U2FDeviceRegistrationBuilder<C extends U2FDeviceRegistration, B extends U2FDeviceRegistrationBuilder<C, B>> {
        @Generated
        private boolean id$set;
        @Generated
        private long id$value;
        @Generated
        private String username;
        @Generated
        private String record;
        @Generated
        private boolean createdDate$set;
        @Generated
        private LocalDate createdDate$value;

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @JsonProperty(value="id")
        @Generated
        public B id(long id) {
            this.id$value = id;
            this.id$set = true;
            return this.self();
        }

        @JsonProperty(value="username")
        @Generated
        public B username(String username) {
            this.username = username;
            return this.self();
        }

        @JsonProperty(value="record")
        @Generated
        public B record(String record) {
            this.record = record;
            return this.self();
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
        @JsonProperty(value="createdDate")
        @Generated
        public B createdDate(LocalDate createdDate) {
            this.createdDate$value = createdDate;
            this.createdDate$set = true;
            return this.self();
        }

        @Generated
        public String toString() {
            return "U2FDeviceRegistration.U2FDeviceRegistrationBuilder(id$value=" + this.id$value + ", username=" + this.username + ", record=" + this.record + ", createdDate$value=" + this.createdDate$value + ")";
        }
    }
}

