/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.pages;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.enduser.pages.BaseReauthPage;
import org.apache.syncope.client.enduser.rest.AuthProfileRestClient;
import org.apache.syncope.client.ui.commons.annotations.AMPage;
import org.apache.syncope.client.ui.commons.markup.html.form.IndicatingOnConfirmAjaxLink;
import org.apache.syncope.common.lib.to.AuthProfileTO;
import org.apache.syncope.common.lib.wa.GoogleMfaAuthAccount;
import org.apache.syncope.common.lib.wa.GoogleMfaAuthToken;
import org.apache.syncope.common.lib.wa.ImpersonationAccount;
import org.apache.syncope.common.lib.wa.MfaTrustedDevice;
import org.apache.syncope.common.lib.wa.WebAuthnDeviceCredential;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.navigation.paging.AjaxPagingNavigator;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;

@AMPage(label="Auth Profile", icon="fa fa-passport", listEntitlement="")
public class AuthProfile
extends BaseReauthPage {
    private static final long serialVersionUID = -3147262161518280928L;
    protected static final String AUTH_PROFILE = "page.authProfile";
    protected static final int ROWS_PER_PAGE = 5;
    @SpringBean
    protected AuthProfileRestClient restClient;

    public AuthProfile(PageParameters parameters) {
        super(parameters, AUTH_PROFILE);
        final AuthProfileTO authProfile = this.restClient.read();
        final WebMarkupContainer container = new WebMarkupContainer("content");
        this.contentWrapper.add(new Component[]{container.setOutputMarkupId(true)});
        DataView<ImpersonationAccount> impersonationAccounts = new DataView<ImpersonationAccount>("impersonationAccounts", (IDataProvider)new ListDataProvider(authProfile == null ? List.of() : authProfile.getImpersonationAccounts())){
            private static final long serialVersionUID = 6127875313385810666L;

            public void populateItem(final Item<ImpersonationAccount> item) {
                item.add(new Component[]{new Label("impersonated", (Serializable)((Object)((ImpersonationAccount)item.getModelObject()).getImpersonated()))});
                item.add(new Component[]{new IndicatingOnConfirmAjaxLink<Object>("impersonationAccountDelete", "confirmDelete", true){
                    private static final long serialVersionUID = 1632838687547839512L;

                    public void onClick(AjaxRequestTarget target) {
                        if (authProfile != null) {
                            authProfile.getImpersonationAccounts().remove(item.getModelObject());
                            AuthProfile.this.restClient.update(authProfile);
                            target.add(new Component[]{container});
                        }
                    }
                }});
            }
        };
        impersonationAccounts.setItemsPerPage(5L);
        container.add(new Component[]{impersonationAccounts.setOutputMarkupPlaceholderTag(true)});
        container.add(new Component[]{new AjaxPagingNavigator("impersonationAccountsNavigator", (IPageable)impersonationAccounts)});
        DataView<GoogleMfaAuthToken> googleMfaAuthTokens = new DataView<GoogleMfaAuthToken>("googleMfaAuthTokens", (IDataProvider)new ListDataProvider(authProfile == null ? List.of() : authProfile.getGoogleMfaAuthTokens())){
            private static final long serialVersionUID = 6127875313385810666L;

            public void populateItem(final Item<GoogleMfaAuthToken> item) {
                item.add(new Component[]{new Label("otp", (Serializable)Integer.valueOf(((GoogleMfaAuthToken)item.getModelObject()).getOtp()))});
                item.add(new Component[]{new Label("issueDate", (Serializable)((GoogleMfaAuthToken)item.getModelObject()).getIssueDate())});
                item.add(new Component[]{new IndicatingOnConfirmAjaxLink<Object>("googleMfaAuthTokenDelete", "confirmDelete", true){
                    private static final long serialVersionUID = 1632838687547839512L;

                    public void onClick(AjaxRequestTarget target) {
                        if (authProfile != null) {
                            authProfile.getGoogleMfaAuthTokens().remove(item.getModelObject());
                            AuthProfile.this.restClient.update(authProfile);
                            target.add(new Component[]{container});
                        }
                    }
                }});
            }
        };
        googleMfaAuthTokens.setItemsPerPage(5L);
        container.add(new Component[]{googleMfaAuthTokens.setOutputMarkupPlaceholderTag(true)});
        container.add(new Component[]{new AjaxPagingNavigator("googleMfaAuthTokensNavigator", (IPageable)googleMfaAuthTokens)});
        DataView<GoogleMfaAuthAccount> googleMfaAuthAccounts = new DataView<GoogleMfaAuthAccount>("googleMfaAuthAccounts", (IDataProvider)new ListDataProvider(authProfile == null ? List.of() : authProfile.getGoogleMfaAuthAccounts())){
            private static final long serialVersionUID = 6127875313385810666L;

            public void populateItem(final Item<GoogleMfaAuthAccount> item) {
                item.add(new Component[]{new Label("id", (Serializable)Long.valueOf(((GoogleMfaAuthAccount)item.getModelObject()).getId()))});
                item.add(new Component[]{new Label("name", (Serializable)((Object)((GoogleMfaAuthAccount)item.getModelObject()).getName()))});
                item.add(new Component[]{new Label("secretKey", (Serializable)((Object)((GoogleMfaAuthAccount)item.getModelObject()).getSecretKey()))});
                item.add(new Component[]{new Label("validationCode", (Serializable)Integer.valueOf(((GoogleMfaAuthAccount)item.getModelObject()).getValidationCode()))});
                item.add(new Component[]{new Label("scratchCodes", (Serializable)((Object)((GoogleMfaAuthAccount)item.getModelObject()).getScratchCodes().stream().map(String::valueOf).collect(Collectors.joining(", "))))});
                item.add(new Component[]{new Label("registrationDate", (Serializable)((GoogleMfaAuthAccount)item.getModelObject()).getRegistrationDate())});
                item.add(new Component[]{new IndicatingOnConfirmAjaxLink<Object>("googleMfaAuthAccountDelete", "confirmDelete", true){
                    private static final long serialVersionUID = 1632838687547839512L;

                    public void onClick(AjaxRequestTarget target) {
                        if (authProfile != null) {
                            authProfile.getGoogleMfaAuthAccounts().remove(item.getModelObject());
                            AuthProfile.this.restClient.update(authProfile);
                            target.add(new Component[]{container});
                        }
                    }
                }});
            }
        };
        googleMfaAuthAccounts.setItemsPerPage(5L);
        container.add(new Component[]{googleMfaAuthAccounts.setOutputMarkupPlaceholderTag(true)});
        container.add(new Component[]{new AjaxPagingNavigator("googleMfaAuthAccountsNavigator", (IPageable)googleMfaAuthAccounts)});
        DataView<MfaTrustedDevice> mfaTrustedDevices = new DataView<MfaTrustedDevice>("mfaTrustedDevices", (IDataProvider)new ListDataProvider(authProfile == null ? List.of() : authProfile.getMfaTrustedDevices())){
            private static final long serialVersionUID = 6127875313385810666L;

            public void populateItem(final Item<MfaTrustedDevice> item) {
                item.add(new Component[]{new Label("id", (Serializable)Long.valueOf(((MfaTrustedDevice)item.getModelObject()).getId()))});
                item.add(new Component[]{new Label("name", (Serializable)((Object)((MfaTrustedDevice)item.getModelObject()).getName()))});
                item.add(new Component[]{new Label("deviceFingerprint", (Serializable)((Object)((MfaTrustedDevice)item.getModelObject()).getDeviceFingerprint()))});
                item.add(new Component[]{new Label("recordDate", (Serializable)((MfaTrustedDevice)item.getModelObject()).getRecordDate())});
                item.add(new Component[]{new Label("expirationDate", (Serializable)((MfaTrustedDevice)item.getModelObject()).getExpirationDate())});
                item.add(new Component[]{new IndicatingOnConfirmAjaxLink<Object>("mfaTrustedDeviceDelete", "confirmDelete", true){
                    private static final long serialVersionUID = 1632838687547839512L;

                    public void onClick(AjaxRequestTarget target) {
                        if (authProfile != null) {
                            authProfile.getMfaTrustedDevices().remove(item.getModelObject());
                            AuthProfile.this.restClient.update(authProfile);
                            target.add(new Component[]{container});
                        }
                    }
                }});
            }
        };
        mfaTrustedDevices.setItemsPerPage(5L);
        container.add(new Component[]{mfaTrustedDevices.setOutputMarkupPlaceholderTag(true)});
        container.add(new Component[]{new AjaxPagingNavigator("mfaTrustedDevicesNavigator", (IPageable)mfaTrustedDevices)});
        DataView<WebAuthnDeviceCredential> webAuthnDeviceCredentials = new DataView<WebAuthnDeviceCredential>("webAuthnDeviceCredentials", (IDataProvider)new ListDataProvider(authProfile == null ? List.of() : authProfile.getWebAuthnDeviceCredentials())){
            private static final long serialVersionUID = 6127875313385810666L;

            public void populateItem(final Item<WebAuthnDeviceCredential> item) {
                item.add(new Component[]{new Label("identifier", (Serializable)((Object)((WebAuthnDeviceCredential)item.getModelObject()).getIdentifier()))});
                item.add(new Component[]{new IndicatingOnConfirmAjaxLink<Object>("webAuthnDeviceCredentialDelete", "confirmDelete", true){
                    private static final long serialVersionUID = 1632838687547839512L;

                    public void onClick(AjaxRequestTarget target) {
                        if (authProfile != null) {
                            authProfile.getWebAuthnDeviceCredentials().remove(item.getModelObject());
                            AuthProfile.this.restClient.update(authProfile);
                            target.add(new Component[]{container});
                        }
                    }
                }});
            }
        };
        webAuthnDeviceCredentials.setItemsPerPage(5L);
        container.add(new Component[]{webAuthnDeviceCredentials.setOutputMarkupPlaceholderTag(true)});
        container.add(new Component[]{new AjaxPagingNavigator("webAuthnDeviceCredentialsNavigator", (IPageable)webAuthnDeviceCredentials)});
    }
}

