/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.tabs;

import com.googlecode.wicket.jquery.core.ajax.HandlerPayload;
import com.googlecode.wicket.kendo.ui.form.button.AjaxButton;
import com.googlecode.wicket.kendo.ui.widget.NavigationPanel;
import com.googlecode.wicket.kendo.ui.widget.tabs.TabbedPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.IEvent;

public class TabbedPanelNavigator
extends NavigationPanel {
    private static final long serialVersionUID = 1L;
    private int max = 0;
    private int index = 0;
    private final TabbedPanel tabbedPanel;

    public TabbedPanelNavigator(String id, TabbedPanel tabbedPanel) {
        super(id);
        this.tabbedPanel = tabbedPanel;
    }

    private int count() {
        return this.tabbedPanel.getLastTabIndex() + 1;
    }

    protected void onConfigure() {
        super.onConfigure();
        this.max = this.count() - 1;
        this.getBackwardButton().setEnabled(this.index > 0);
        this.getForwardButton().setEnabled(this.index < this.max);
    }

    @Override
    protected void onBackward(AjaxRequestTarget target, AjaxButton button) {
        if (this.index > 0) {
            this.tabbedPanel.setTabIndex(this.index - 1, (IPartialPageRequestHandler)target);
        }
    }

    @Override
    protected void onForward(AjaxRequestTarget target, AjaxButton button) {
        if (this.index < this.max) {
            this.tabbedPanel.setTabIndex(this.index + 1, (IPartialPageRequestHandler)target);
        }
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof RefreshPayload) {
            RefreshPayload payload = (RefreshPayload)((Object)event.getPayload());
            this.index = payload.getIndex();
            payload.reload(new Component[]{this});
        }
    }

    public static class RefreshPayload
    extends HandlerPayload {
        private final int index;

        public RefreshPayload(int index, IPartialPageRequestHandler handler) {
            super(handler);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

