/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.config.xml;

import java.io.IOException;
import java.net.URI;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ehcache.clustered.client.config.ClusteredStoreConfiguration;
import org.ehcache.clustered.client.internal.config.xml.ClusteredCacheConstants;
import org.ehcache.clustered.client.internal.store.ClusteredStore;
import org.ehcache.clustered.common.Consistency;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.xml.BaseConfigParser;
import org.ehcache.xml.CacheServiceConfigurationParser;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.osgi.service.component.annotations.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Component
public class ClusteringCacheServiceConfigurationParser
extends BaseConfigParser<ClusteredStoreConfiguration>
implements CacheServiceConfigurationParser<ClusteredStore.Provider> {
    public static final String CLUSTERED_STORE_ELEMENT_NAME = "clustered-store";
    public static final String CONSISTENCY_ATTRIBUTE_NAME = "consistency";

    public ClusteringCacheServiceConfigurationParser() {
        super(ClusteredStoreConfiguration.class);
    }

    public Source getXmlSchema() throws IOException {
        return new StreamSource(ClusteredCacheConstants.XML_SCHEMA.openStream());
    }

    public URI getNamespace() {
        return ClusteredCacheConstants.NAMESPACE;
    }

    public ServiceConfiguration<ClusteredStore.Provider, ?> parseServiceConfiguration(Element fragment, ClassLoader classLoader) {
        if (CLUSTERED_STORE_ELEMENT_NAME.equals(fragment.getLocalName())) {
            if (fragment.hasAttribute(CONSISTENCY_ATTRIBUTE_NAME)) {
                return new ClusteredStoreConfiguration(Consistency.valueOf((String)fragment.getAttribute(CONSISTENCY_ATTRIBUTE_NAME).toUpperCase()));
            }
            return new ClusteredStoreConfiguration();
        }
        throw new XmlConfigurationException(String.format("XML configuration element <%s> in <%s> is not supported", fragment.getTagName(), fragment.getParentNode() == null ? "null" : fragment.getParentNode().getLocalName()));
    }

    public Class<ClusteredStore.Provider> getServiceType() {
        return ClusteredStore.Provider.class;
    }

    public Element unparseServiceConfiguration(ServiceConfiguration<ClusteredStore.Provider, ?> serviceConfiguration) {
        return this.unparseConfig(serviceConfiguration);
    }

    protected Element createRootElement(Document doc, ClusteredStoreConfiguration clusteredStoreConfiguration) {
        Consistency consistency = clusteredStoreConfiguration.getConsistency();
        Element rootElement = doc.createElementNS(this.getNamespace().toString(), "tc:clustered-store");
        rootElement.setAttribute(CONSISTENCY_ATTRIBUTE_NAME, consistency.name().toLowerCase());
        return rootElement;
    }
}

