/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.app.verifier;

import com.giffing.wicket.spring.boot.starter.app.verifier.WicketDependencyMismatchDetectedException;
import com.giffing.wicket.spring.boot.starter.app.verifier.WicketDependencyVersionChecker;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;

public class WicketDependencyVersionCheckerFailureAnalyzer
extends AbstractFailureAnalyzer<WicketDependencyMismatchDetectedException> {
    public static String newline = System.getProperty("line.separator");

    protected FailureAnalysis analyze(Throwable rootFailure, WicketDependencyMismatchDetectedException cause) {
        String descriptionMessage = "One or more Wicket dependencies (jars) doesn't match the wicket-core dependency.\n\rWicket Core Version: " + cause.getWicketCoreVersion() + newline;
        for (WicketDependencyVersionChecker.MavenDependency dependency : cause.getDependencies()) {
            descriptionMessage = descriptionMessage + "\t" + dependency + newline;
        }
        String actionMessage = "Please check the Wicket versions configured in your dependency management system (Maven, Gradle, ...) " + newline + "You can disable this check via the property:" + newline + "\twicket.verifier.dependencies.enabled=false." + newline + "You can prevent throwing the exception but still log the detected problems via the property:" + newline + "\twicket.verifier.dependencies.throw-exception-on-dependency-version-mismatch=false";
        return new FailureAnalysis(descriptionMessage, actionMessage, (Throwable)cause);
    }
}

