/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.idp.metadata.locator;

import com.github.benmanes.caffeine.cache.Cache;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataLocator;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlIdPMetadataDocument;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public abstract class AbstractSamlIdPMetadataLocator
implements SamlIdPMetadataLocator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSamlIdPMetadataLocator.class);
    private static final String CACHE_KEY_METADATA = "CasSamlIdentityProviderMetadata";
    protected final CipherExecutor<String, String> metadataCipherExecutor;
    private final Cache<String, SamlIdPMetadataDocument> metadataCache;

    private static Resource getResource(String data) {
        return new ByteArrayResource(StringUtils.defaultString((String)data).getBytes(StandardCharsets.UTF_8));
    }

    private static String buildCacheKey(Optional<SamlRegisteredService> registeredService) {
        if (registeredService.isEmpty()) {
            LOGGER.trace("No registered service provided; using default cache key for metadata");
            return CACHE_KEY_METADATA;
        }
        SamlRegisteredService samlRegisteredService = registeredService.get();
        String key = "CasSamlIdentityProviderMetadata_" + samlRegisteredService.getId() + "_" + samlRegisteredService.getName();
        LOGGER.trace("Using [{}] as cache key for metadata for service definition", (Object)key);
        return key;
    }

    @Override
    public Resource resolveSigningCertificate(Optional<SamlRegisteredService> registeredService) {
        SamlIdPMetadataDocument metadataDocument = this.fetch(registeredService);
        if (metadataDocument != null && metadataDocument.isValid()) {
            LOGGER.trace("Fetching signing certificate resource for metadata document [{}]", (Object)metadataDocument.getId());
            return AbstractSamlIdPMetadataLocator.getResource(metadataDocument.getSigningCertificateDecoded());
        }
        return ResourceUtils.EMPTY_RESOURCE;
    }

    @Override
    public Resource resolveSigningKey(Optional<SamlRegisteredService> registeredService) {
        SamlIdPMetadataDocument metadataDocument = this.fetch(registeredService);
        if (metadataDocument != null && metadataDocument.isValid()) {
            String data = metadataDocument.getSigningKey();
            LOGGER.trace("Fetching signing key resource for metadata document [{}]", (Object)metadataDocument.getId());
            return AbstractSamlIdPMetadataLocator.getResource((String)this.metadataCipherExecutor.decode((Object)data));
        }
        return ResourceUtils.EMPTY_RESOURCE;
    }

    @Override
    public Resource resolveMetadata(Optional<SamlRegisteredService> registeredService) {
        SamlIdPMetadataDocument metadataDocument = this.fetch(registeredService);
        if (metadataDocument != null && metadataDocument.isValid()) {
            LOGGER.trace("Fetching metadata resource for metadata document [{}]", (Object)metadataDocument.getId());
            return AbstractSamlIdPMetadataLocator.getResource(metadataDocument.getMetadataDecoded());
        }
        return ResourceUtils.EMPTY_RESOURCE;
    }

    @Override
    public Resource getEncryptionCertificate(Optional<SamlRegisteredService> registeredService) {
        SamlIdPMetadataDocument metadataDocument = this.fetch(registeredService);
        if (metadataDocument != null && metadataDocument.isValid()) {
            LOGGER.trace("Fetching encryption certificate resource for metadata document [{}]", (Object)metadataDocument.getId());
            return AbstractSamlIdPMetadataLocator.getResource(metadataDocument.getEncryptionCertificateDecoded());
        }
        return ResourceUtils.EMPTY_RESOURCE;
    }

    @Override
    public Resource resolveEncryptionKey(Optional<SamlRegisteredService> registeredService) {
        SamlIdPMetadataDocument metadataDocument = this.fetch(registeredService);
        if (metadataDocument != null && metadataDocument.isValid()) {
            String data = metadataDocument.getEncryptionKey();
            LOGGER.trace("Fetching encryption key resource for metadata document [{}]", (Object)metadataDocument.getId());
            return AbstractSamlIdPMetadataLocator.getResource((String)this.metadataCipherExecutor.decode((Object)data));
        }
        return ResourceUtils.EMPTY_RESOURCE;
    }

    @Override
    public boolean exists(Optional<SamlRegisteredService> registeredService) {
        SamlIdPMetadataDocument metadataDocument = this.fetch(registeredService);
        return metadataDocument != null && metadataDocument.isValid();
    }

    @Override
    public SamlIdPMetadataDocument fetch(Optional<SamlRegisteredService> registeredService) {
        String key = AbstractSamlIdPMetadataLocator.buildCacheKey(registeredService);
        return (SamlIdPMetadataDocument)this.getMetadataCache().get((Object)key, Unchecked.function(k -> {
            SamlIdPMetadataDocument metadataDocument = this.fetchInternal(registeredService);
            if (metadataDocument != null && metadataDocument.isValid()) {
                LOGGER.trace("Fetched and cached SAML IdP metadata document [{}] under key [{}]", (Object)metadataDocument, (Object)key);
                return metadataDocument;
            }
            LOGGER.trace("SAML IdP metadata document [{}] is considered invalid", (Object)metadataDocument);
            return null;
        }));
    }

    protected abstract SamlIdPMetadataDocument fetchInternal(Optional<SamlRegisteredService> var1) throws Exception;

    @Generated
    public CipherExecutor<String, String> getMetadataCipherExecutor() {
        return this.metadataCipherExecutor;
    }

    @Generated
    public Cache<String, SamlIdPMetadataDocument> getMetadataCache() {
        return this.metadataCache;
    }

    @Generated
    protected AbstractSamlIdPMetadataLocator(CipherExecutor<String, String> metadataCipherExecutor, Cache<String, SamlIdPMetadataDocument> metadataCache) {
        this.metadataCipherExecutor = metadataCipherExecutor;
        this.metadataCache = metadataCache;
    }
}

