/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.scheme;

import java.util.Arrays;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.scheme.ACLAScheme;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.compress.colgroup.scheme.SchemeFactory;
import org.apache.sysds.runtime.compress.utils.Util;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ConstScheme
extends ACLAScheme {
    final double[] vals;

    private ConstScheme(IColIndex cols, double[] vals) {
        super(cols);
        this.vals = vals;
    }

    public static ICLAScheme create(ColGroupConst g) {
        return new ConstScheme(g.getColIndices(), g.getValues());
    }

    public static ICLAScheme create(IColIndex cols, double[] vals) {
        if (vals == null) {
            throw new RuntimeException("Invalid null vals for ConstScheme");
        }
        return new ConstScheme(cols, vals);
    }

    @Override
    protected ICLAScheme updateV(MatrixBlock data, IColIndex columns) {
        int nRow = data.getNumRows();
        int nColScheme = this.vals.length;
        for (int r = 0; r < nRow; ++r) {
            for (int c = 0; c < nColScheme; ++c) {
                double v = data.get(r, this.cols.get(c));
                if (Util.eq(v, this.vals[c])) continue;
                return this.updateToDDC(data, columns);
            }
        }
        return this;
    }

    private ICLAScheme updateToDDC(MatrixBlock data, IColIndex columns) {
        return SchemeFactory.create(columns, AColGroup.CompressionType.DDC).update(data, columns);
    }

    private ICLAScheme updateToDDCT(MatrixBlock data, IColIndex columns) {
        return SchemeFactory.create(columns, AColGroup.CompressionType.DDC).updateT(data, columns);
    }

    @Override
    protected AColGroup encodeV(MatrixBlock data, IColIndex columns) {
        return ColGroupConst.create(columns, this.vals);
    }

    @Override
    protected AColGroup encodeVT(MatrixBlock data, IColIndex columns) {
        return ColGroupConst.create(columns, this.vals);
    }

    @Override
    protected ICLAScheme updateVT(MatrixBlock data, IColIndex columns) {
        int nCol = data.getNumColumns();
        int nColScheme = this.vals.length;
        for (int r = 0; r < nColScheme; ++r) {
            int row = this.cols.get(r);
            double def = this.vals[r];
            for (int c = 0; c < nCol; ++c) {
                double v = data.get(row, c);
                if (Util.eq(v, def)) continue;
                return this.updateToDDCT(data, columns);
            }
        }
        return this;
    }

    @Override
    public ConstScheme clone() {
        return new ConstScheme(this.cols, Arrays.copyOf(this.vals, this.vals.length));
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" Cols: ");
        sb.append(this.cols);
        sb.append(" Def:  ");
        sb.append(Arrays.toString(this.vals));
        return sb.toString();
    }
}

