/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.tld;

import java.io.IOException;
import java.io.InputStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.descriptor.DigesterFactory;
import org.apache.tomcat.util.descriptor.XmlErrorHandler;
import org.apache.tomcat.util.descriptor.tld.TaglibXml;
import org.apache.tomcat.util.descriptor.tld.TldResourcePath;
import org.apache.tomcat.util.descriptor.tld.TldRuleSet;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TldParser {
    private final Log log = LogFactory.getLog(TldParser.class);
    private final Digester digester;

    public TldParser(boolean namespaceAware, boolean validation, boolean blockExternal) {
        this(namespaceAware, validation, new TldRuleSet(), blockExternal);
    }

    public TldParser(boolean namespaceAware, boolean validation, RuleSet ruleSet, boolean blockExternal) {
        this.digester = DigesterFactory.newDigester((boolean)validation, (boolean)namespaceAware, (RuleSet)ruleSet, (boolean)blockExternal);
    }

    public TaglibXml parse(TldResourcePath path) throws IOException, SAXException {
        Thread currentThread = Thread.currentThread();
        ClassLoader original = currentThread.getContextClassLoader();
        try {
            TaglibXml taglibXml;
            block11: {
                InputStream is = path.openStream();
                try {
                    currentThread.setContextClassLoader(TldParser.class.getClassLoader());
                    XmlErrorHandler handler = new XmlErrorHandler();
                    this.digester.setErrorHandler((ErrorHandler)handler);
                    TaglibXml taglibXml2 = new TaglibXml();
                    this.digester.push((Object)taglibXml2);
                    InputSource source = new InputSource(path.toExternalForm());
                    source.setByteStream(is);
                    this.digester.parse(source);
                    if (!handler.getWarnings().isEmpty() || !handler.getErrors().isEmpty()) {
                        handler.logFindings(this.log, source.getSystemId());
                        if (!handler.getErrors().isEmpty()) {
                            throw (SAXParseException)handler.getErrors().iterator().next();
                        }
                    }
                    taglibXml = taglibXml2;
                    if (is == null) break block11;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return taglibXml;
        }
        finally {
            this.digester.reset();
            currentThread.setContextClassLoader(original);
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.digester.setClassLoader(classLoader);
    }
}

