/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkMaskedAssignImageFilter_h
#define sitkMaskedAssignImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class MaskedAssignImageFilter
\brief Mask an image with a mask.

This class is templated over the types of the input image type, the mask image type and the type of the output image. Numeric conversions (castings) are done by the C++ defaults.

The pixel type of the input 2 image must have a valid definition of the operator != with zero. This condition is required because internally this filter will perform the operation

\code
if pixel_from_mask_image != masking_value

 pixel_output_image = pixel_input_image

else

 pixel_output_image = outside_value

\endcode


The pixel from the input 1 is cast to the pixel type of the output image.

Note that the input and the mask images must be of the same size.

\warning Any pixel value other than masking value (0 by default) will not be masked out.


\see MaskNegatedImageFilter
\sa itk::simple::MaskedAssign for the procedural interface
\sa itk::MaskedAssignImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT MaskedAssignImageFilter : public ImageFilter {
    public:
      using Self = MaskedAssignImageFilter;

      /** Destructor */
      virtual ~MaskedAssignImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      MaskedAssignImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = NonLabelPixelIDTypeList;
\

      /**
       * Method to explicitly set the outside value of the mask when AssignImage is undefined. Defaults to 0
       */
      SITK_RETURN_SELF_TYPE_HEADER SetAssignConstant ( double AssignConstant ) { this->m_AssignConstant = AssignConstant; return *this; }

      /**
       */
      double GetAssignConstant() const { return this->m_AssignConstant; }

      /** Name of this class */
      std::string GetName() const { return std::string ("MaskedAssignImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
#ifndef SWIG
      Image Execute ( Image && image, const Image & maskImage, const Image & assignImage );
      Image Execute ( Image && image, const Image & maskImage );
#endif
      Image Execute ( const Image & image, const Image & maskImage, const Image & assignImage );
      Image Execute ( const Image & image, const Image & maskImage );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image * image, const Image * maskImage, const Image * assignImage );
      template <class TImageType> Image ExecuteInternal ( const Image * image, const Image * maskImage, const Image * assignImage );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      double  m_AssignConstant{0};


      bool m_InPlace{false};
    };

    /**\
     * \brief Mask an image with a mask.
     *
     * This function directly calls the execute method of MaskedAssignImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::MaskedAssignImageFilter for the object oriented interface
     * @{
     */
#ifndef SWIG
     SITKBasicFilters_EXPORT Image MaskedAssign ( Image && image, const Image & maskImage, const Image & assignImage, double assignConstant = 0 );
     SITKBasicFilters_EXPORT Image MaskedAssign ( Image && image, const Image & maskImage, double assignConstant = 0 );
#endif
     SITKBasicFilters_EXPORT Image MaskedAssign ( const Image & image, const Image & maskImage, const Image & assignImage, double assignConstant = 0 );
     SITKBasicFilters_EXPORT Image MaskedAssign ( const Image & image, const Image & maskImage, double assignConstant = 0 );
     /** @} */
}
#endif
