﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iottwinmaker/IoTTwinMaker_EXPORTS.h>
#include <aws/iottwinmaker/model/MetadataTransferJobStatus.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace IoTTwinMaker {
namespace Model {
class CreateMetadataTransferJobResult {
 public:
  AWS_IOTTWINMAKER_API CreateMetadataTransferJobResult() = default;
  AWS_IOTTWINMAKER_API CreateMetadataTransferJobResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IOTTWINMAKER_API CreateMetadataTransferJobResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The metadata transfer job Id.</p>
   */
  inline const Aws::String& GetMetadataTransferJobId() const { return m_metadataTransferJobId; }
  template <typename MetadataTransferJobIdT = Aws::String>
  void SetMetadataTransferJobId(MetadataTransferJobIdT&& value) {
    m_metadataTransferJobIdHasBeenSet = true;
    m_metadataTransferJobId = std::forward<MetadataTransferJobIdT>(value);
  }
  template <typename MetadataTransferJobIdT = Aws::String>
  CreateMetadataTransferJobResult& WithMetadataTransferJobId(MetadataTransferJobIdT&& value) {
    SetMetadataTransferJobId(std::forward<MetadataTransferJobIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata transfer job ARN.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  CreateMetadataTransferJobResult& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The The metadata transfer job creation DateTime property.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationDateTime() const { return m_creationDateTime; }
  template <typename CreationDateTimeT = Aws::Utils::DateTime>
  void SetCreationDateTime(CreationDateTimeT&& value) {
    m_creationDateTimeHasBeenSet = true;
    m_creationDateTime = std::forward<CreationDateTimeT>(value);
  }
  template <typename CreationDateTimeT = Aws::Utils::DateTime>
  CreateMetadataTransferJobResult& WithCreationDateTime(CreationDateTimeT&& value) {
    SetCreationDateTime(std::forward<CreationDateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata transfer job response status.</p>
   */
  inline const MetadataTransferJobStatus& GetStatus() const { return m_status; }
  template <typename StatusT = MetadataTransferJobStatus>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = MetadataTransferJobStatus>
  CreateMetadataTransferJobResult& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateMetadataTransferJobResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_metadataTransferJobId;

  Aws::String m_arn;

  Aws::Utils::DateTime m_creationDateTime{};

  MetadataTransferJobStatus m_status;

  Aws::String m_requestId;
  bool m_metadataTransferJobIdHasBeenSet = false;
  bool m_arnHasBeenSet = false;
  bool m_creationDateTimeHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTTwinMaker
}  // namespace Aws
