/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;

public class DataSourceMemoryStorage
implements DBPDataSourceConfigurationStorage {
    private final byte[] data;

    public DataSourceMemoryStorage(@NotNull byte[] data) {
        this.data = data;
    }

    @NotNull
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    @NotNull
    public String getStorageId() {
        return "memory";
    }

    public boolean isValid() {
        return true;
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isVirtual() {
        return true;
    }

    @NotNull
    public String getStatus() {
        return null;
    }

    @Nullable
    public String getStorageSubId() {
        return null;
    }
}

