/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import com.tngtech.archunit.core.domain.properties.HasModifiers;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.conditions.ArchPredicates;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import java.lang.annotation.Annotation;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class ProxyRules {
    private ProxyRules() {
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchRule no_classes_should_directly_call_other_methods_declared_in_the_same_class_that_are_annotated_with(Class<? extends Annotation> annotationType) {
        return ProxyRules.no_classes_should_directly_call_other_methods_declared_in_the_same_class_that(ArchPredicates.are(CanBeAnnotated.Predicates.annotatedWith(annotationType)));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchRule no_classes_should_directly_call_other_methods_declared_in_the_same_class_that(DescribedPredicate<? super AccessTarget.MethodCallTarget> predicate) {
        return ArchRuleDefinition.noClasses().should(ProxyRules.directly_call_other_methods_declared_in_the_same_class_that(predicate)).because("it bypasses the proxy mechanism");
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> directly_call_other_methods_declared_in_the_same_class_that_are_annotated_with(Class<? extends Annotation> annotationType) {
        return ProxyRules.directly_call_other_methods_declared_in_the_same_class_that(ArchPredicates.are(CanBeAnnotated.Predicates.annotatedWith(annotationType)));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> directly_call_other_methods_declared_in_the_same_class_that(final DescribedPredicate<? super AccessTarget.MethodCallTarget> predicate) {
        return new ArchCondition<JavaClass>("directly call other methods declared in the same class that " + predicate.getDescription(), new Object[0]){

            @Override
            public void check(JavaClass javaClass, ConditionEvents events) {
                javaClass.getMethodCallsFromSelf().stream().filter(JavaAccess.Functions.Get.origin().is(DescribedPredicate.not(HasModifiers.Predicates.modifier(JavaModifier.BRIDGE)))).forEach(call -> {
                    boolean satisfied = call.getOriginOwner().equals(call.getTargetOwner()) && predicate.test(call.getTarget());
                    events.add(new SimpleConditionEvent(call, satisfied, call.getDescription()));
                });
            }
        };
    }
}

