/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.ShorthandValue;
import io.sf.carte.doc.style.css.property.LexicalValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.UnknownValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;

class CompatDeclarationSet
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final HashMap<String, StyleValue> overrideMap = new HashMap();
    private final HashMap<String, Boolean> overridePrio = new HashMap();
    private final HashMap<String, StyleValue> nonOverrideMap = new HashMap();
    private final HashMap<String, ShorthandValue> compatShorthandMap = new HashMap();
    private final HashMap<String, ShorthandValue> nonOvShorthandMap = new HashMap();

    CompatDeclarationSet() {
    }

    CompatDeclarationSet(CompatDeclarationSet compatDeclarationSet) {
        this.overrideMap.putAll(compatDeclarationSet.overrideMap);
        this.overridePrio.putAll(compatDeclarationSet.overridePrio);
        this.nonOverrideMap.putAll(compatDeclarationSet.nonOverrideMap);
        this.compatShorthandMap.putAll(compatDeclarationSet.compatShorthandMap);
        this.nonOvShorthandMap.putAll(compatDeclarationSet.nonOvShorthandMap);
    }

    void setCompatLonghand(String string, StyleValue styleValue, boolean bl, boolean bl2) {
        if (bl2) {
            this.overrideMap.put(string, styleValue);
            this.overridePrio.put(string, bl);
            this.nonOverrideMap.remove(string);
        } else if (CompatDeclarationSet.isPriorityCompat(styleValue)) {
            this.nonOverrideMap.put(string, styleValue);
        }
    }

    boolean setCompatShorthand(String string, LexicalUnit lexicalUnit, boolean bl, LinkedList<String> linkedList) {
        if (CompatDeclarationSet.containsIdentCompat(lexicalUnit)) {
            String string2 = lexicalUnit.toString();
            ShorthandValue shorthandValue = new ShorthandValue(lexicalUnit, bl);
            shorthandValue.setShorthandText(string2, LexicalValue.serializeMinifiedSequence(lexicalUnit));
            if (linkedList != null && linkedList.contains(string)) {
                this.compatShorthandMap.put(string, shorthandValue);
                this.nonOvShorthandMap.remove(string);
            } else if (shorthandValue.isPriorityCompat()) {
                this.nonOvShorthandMap.put(string, shorthandValue);
            }
            return true;
        }
        return false;
    }

    private static boolean containsIdentCompat(LexicalUnit lexicalUnit) {
        while (lexicalUnit != null) {
            LexicalUnit.LexicalType lexicalType = lexicalUnit.getLexicalUnitType();
            if (lexicalType == LexicalUnit.LexicalType.COMPAT_IDENT || lexicalType == LexicalUnit.LexicalType.COMPAT_PRIO) {
                return true;
            }
            if (lexicalType == LexicalUnit.LexicalType.FUNCTION) {
                return CompatDeclarationSet.containsIdentCompat(lexicalUnit.getParameters());
            }
            if (lexicalType == LexicalUnit.LexicalType.SUB_EXPRESSION) {
                return CompatDeclarationSet.containsIdentCompat(lexicalUnit.getSubValues());
            }
            lexicalUnit = lexicalUnit.getNextLexicalUnit();
        }
        return false;
    }

    static boolean isPriorityCompat(StyleValue styleValue) {
        return styleValue.getPrimitiveType() == CSSValue.Type.UNKNOWN && ((UnknownValue)styleValue).isPriorityCompat();
    }

    static void appendIEPrioCharShorthandMinifiedCssText(StringBuilder stringBuilder, String string, ShorthandValue shorthandValue) {
        stringBuilder.append(string).append(':').append(shorthandValue.getMinifiedCssText(string));
        stringBuilder.append("!important!;");
    }

    static void writeIEPrioCharShorthandCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext, String string, ShorthandValue shorthandValue) throws IOException {
        simpleWriter.write((CharSequence)string);
        styleFormattingContext.writeColon(simpleWriter);
        simpleWriter.write((CharSequence)shorthandValue.getCssText());
        simpleWriter.write((CharSequence)"!important!");
        styleFormattingContext.writeSemiColon(simpleWriter);
    }

    static void writeIEPrioCharLonghandCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext, String string, StyleValue styleValue) throws IOException {
        simpleWriter.write((CharSequence)string);
        styleFormattingContext.writeColon(simpleWriter);
        styleValue.writeCssText(simpleWriter);
        simpleWriter.write((CharSequence)"!important!");
        styleFormattingContext.writeSemiColon(simpleWriter);
    }

    ShorthandValue getCompatShorthand(String string) {
        return this.compatShorthandMap.get(string);
    }

    boolean isCompatShorthand(String string) {
        return this.compatShorthandMap.containsKey(string);
    }

    boolean isCompatLonghand(String string) {
        return this.overrideMap.containsKey(string);
    }

    StyleValue getCompatLonghand(String string) {
        return this.overrideMap.get(string);
    }

    boolean isImportantCompatLonghand(String string) {
        return this.overridePrio.get(string);
    }

    ShorthandValue getNonOvCompatShorthand(String string) {
        return this.nonOvShorthandMap.get(string);
    }

    StyleValue getNonOvCompatLonghand(String string) {
        return this.nonOverrideMap.get(string);
    }

    public void clear() {
        this.overrideMap.clear();
        this.overridePrio.clear();
        this.nonOverrideMap.clear();
        this.compatShorthandMap.clear();
        this.nonOvShorthandMap.clear();
    }

    public CompatDeclarationSet clone() {
        return new CompatDeclarationSet(this);
    }
}

