/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.datatype.microsoft.GUID;
import java.util.ArrayList;
import java.util.List;

public class OemDefinedMsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 1028;
    private static final byte[] guidPartSSOEMID = new byte[]{-68, 37, 9, 2, -69, -85, -76, 96};
    private static final GUID SSOEMID = new GUID(-957726775, 22963, 18902, guidPartSSOEMID);
    private GUID oemID;
    private RecordNumber typeRecordNumber;
    private List<Long> userData = new ArrayList<Long>();

    public OemDefinedMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        int data1 = reader.parseInt();
        short data2 = reader.parseShort();
        short data3 = reader.parseShort();
        byte[] data4 = reader.parseBytes(8);
        this.oemID = new GUID(data1, data2, data3, data4);
        this.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        while (reader.hasMore()) {
            long val = reader.parseUnsignedIntVal();
            this.userData.add(val);
        }
    }

    @Override
    public int getPdbId() {
        return 1028;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: %s, Type %s\n", this.getSymbolTypeName(), this.oemID, this.pdb.getTypeRecord(this.typeRecordNumber)));
        if (this.oemID.equals((Object)SSOEMID)) {
            for (long val : this.userData) {
                builder.append(String.format("   %08X\n", val));
            }
        }
    }

    @Override
    protected String getSymbolTypeName() {
        return "OEM";
    }
}

