/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.IntKeyIndexer;

public class IntSet {
    private IntKeyIndexer indexer;

    public IntSet(int capacity) {
        this.indexer = new IntKeyIndexer(capacity);
    }

    public IntSet(int[] values) {
        this(values.length * 3 / 4);
        for (int i = 0; i < values.length; ++i) {
            this.add(values[i]);
        }
    }

    public int size() {
        return this.indexer.getSize();
    }

    public boolean isEmpty() {
        return this.indexer.getSize() == 0;
    }

    public boolean contains(int value) {
        return this.indexer.get(value) >= 0;
    }

    public void add(int value) {
        this.indexer.put(value);
    }

    public boolean remove(int value) {
        return this.indexer.remove(value) >= 0;
    }

    public void clear() {
        this.indexer.clear();
    }

    public int[] getValues() {
        return this.indexer.getKeys();
    }
}

