/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr;

import ghidra.app.plugin.assembler.sleigh.expr.AbstractBinaryExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.SolverException;
import ghidra.app.plugin.processors.sleigh.expression.DivExpression;

public class DivExpressionSolver
extends AbstractBinaryExpressionSolver<DivExpression> {
    public DivExpressionSolver() {
        super(DivExpression.class);
    }

    @Override
    public MaskedLong computeLeft(MaskedLong rval, MaskedLong goal) throws SolverException {
        return goal.multiply(rval);
    }

    @Override
    public MaskedLong computeRight(MaskedLong lval, MaskedLong goal) throws SolverException {
        if (lval.equals(goal)) {
            return MaskedLong.fromLong(1L);
        }
        throw new SolverException("Encountered a division of the form A / x = B, where A != B. x has many solutions not easily expressed with masking.");
    }

    @Override
    public MaskedLong compute(MaskedLong lval, MaskedLong rval) {
        return lval.divideSigned(rval);
    }
}

