/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghpatexpress;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.slghpatexpress.PatternExpression;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghpatexpress.TokenPattern;
import ghidra.program.model.pcode.Encoder;
import ghidra.sleigh.grammar.Location;
import java.io.IOException;

public abstract class BinaryExpression
extends PatternExpression {
    private PatternExpression left;
    private PatternExpression right;

    public BinaryExpression(Location location) {
        super(location);
        this.left = null;
        this.right = null;
    }

    public PatternExpression getLeft() {
        return this.left;
    }

    public PatternExpression getRight() {
        return this.right;
    }

    @Override
    public TokenPattern genMinPattern(VectorSTL<TokenPattern> ops) {
        return new TokenPattern(this.location);
    }

    @Override
    public void listValues(VectorSTL<PatternValue> list) {
        this.left.listValues(list);
        this.right.listValues(list);
    }

    @Override
    public void getMinMax(VectorSTL<Long> minlist, VectorSTL<Long> maxlist) {
        this.left.getMinMax(minlist, maxlist);
        this.right.getMinMax(minlist, maxlist);
    }

    public BinaryExpression(Location location, PatternExpression l, PatternExpression r) {
        super(location);
        this.left = l;
        this.left.layClaim();
        this.right = r;
        this.right.layClaim();
    }

    @Override
    public void dispose() {
        if (this.left != null) {
            PatternExpression.release(this.left);
        }
        if (this.right != null) {
            PatternExpression.release(this.right);
        }
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        this.left.encode(encoder);
        this.right.encode(encoder);
    }
}

