/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.GoTypeManager;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.app.util.viewer.field.AddressAnnotatedStringHandler;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;
import java.util.Set;

@StructureMapping(structureName={"runtime.slicetype", "internal/abi.SliceType"})
public class GoSliceType
extends GoType {
    @FieldMapping
    @MarkupReference(value="getElement")
    private long elem;

    @Markup
    public GoType getElement() throws IOException {
        return this.programContext.getGoTypes().getType(this.elem);
    }

    @Override
    public DataType recoverDataType() throws IOException {
        GoTypeManager goTypes = this.programContext.getGoTypes();
        DataTypeManager dtm = goTypes.getDTM();
        Structure genericSliceDT = goTypes.getGenericSliceDT();
        StructureDataType sliceDT = new StructureDataType(goTypes.getCP(this), goTypes.getTypeName(this), genericSliceDT.getLength(), dtm);
        sliceDT.replaceWith((DataType)genericSliceDT);
        goTypes.cacheRecoveredDataType(this, (DataType)sliceDT);
        GoType elementType = this.getElement();
        DataType elementDT = goTypes.getDataType(elementType);
        Pointer elementPtrDT = dtm.getPointer(elementDT);
        int arrayPtrComponentIndex = 0;
        DataTypeComponent arrayDTC = genericSliceDT.getComponent(arrayPtrComponentIndex);
        sliceDT.replace(arrayPtrComponentIndex, (DataType)elementPtrDT, -1, arrayDTC.getFieldName(), arrayDTC.getComment());
        return sliceDT;
    }

    @Override
    public boolean discoverGoTypes(Set<Long> discoveredTypes) throws IOException {
        if (!super.discoverGoTypes(discoveredTypes)) {
            return false;
        }
        GoType elementType = this.getElement();
        if (elementType != null) {
            elementType.discoverGoTypes(discoveredTypes);
        }
        return true;
    }

    @Override
    public String getPackagePathString() {
        String ppStr = super.getPackagePathString();
        if (ppStr == null || ppStr.isEmpty()) {
            try {
                GoType elemType = this.getElement();
                if (elemType != null) {
                    ppStr = elemType.getPackagePathString();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ppStr;
    }

    @Override
    public String getStructureNamespace() throws IOException {
        String packagePath = this.getPackagePathString();
        if (packagePath != null && !packagePath.isEmpty()) {
            return packagePath;
        }
        GoType elementType = this.getElement();
        return elementType != null ? elementType.getStructureNamespace() : super.getStructureNamespace();
    }

    @Override
    protected String getTypeDeclString() throws IOException {
        String selfName = this.getName();
        String elemName = this.getElement().getName();
        String defStr = "[]%s".formatted(elemName);
        String defStrWithLinks = "[]%s".formatted(AddressAnnotatedStringHandler.createAddressAnnotationString(this.elem, elemName));
        boolean hasName = !defStr.equals(selfName);
        return "type %s%s".formatted(hasName ? selfName + " " : "", defStrWithLinks);
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.typ.getSize() == (long)(this.programContext.getPtrSize() * 3);
    }
}

