/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace;

import ghidra.features.base.quickfix.QuickFix;
import ghidra.features.base.quickfix.TableDataLoader;
import ghidra.features.base.replace.SearchAndReplaceQuery;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.datastruct.AccumulatorSizeException;
import ghidra.util.datastruct.SizeRestrictedAccumulatorWrapper;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class SearchAndReplaceQuckFixTableLoader
implements TableDataLoader<QuickFix> {
    private SearchAndReplaceQuery query;
    private Program program;
    private boolean hasResults;
    private boolean searchLimitExceeded;

    public SearchAndReplaceQuckFixTableLoader(Program program, SearchAndReplaceQuery query) {
        this.program = program;
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData(Accumulator<QuickFix> accumulator, TaskMonitor monitor) throws CancelledException {
        SizeRestrictedAccumulatorWrapper wrappedAccumulator = new SizeRestrictedAccumulatorWrapper(accumulator, this.query.getSearchLimit());
        try {
            this.query.findAll(this.program, (Accumulator<QuickFix>)wrappedAccumulator, monitor);
        }
        catch (AccumulatorSizeException e) {
            try {
                this.searchLimitExceeded = true;
            }
            catch (Throwable throwable) {
                this.hasResults = !accumulator.isEmpty();
                throw throwable;
            }
            this.hasResults = !accumulator.isEmpty();
        }
        this.hasResults = !accumulator.isEmpty();
    }

    @Override
    public boolean didProduceData() {
        return this.hasResults;
    }

    @Override
    public boolean maxDataSizeReached() {
        return this.searchLimitExceeded;
    }
}

