# frozen_string_literal: true

class AddVulnerabilityFindingSignaturesProjectIdTrigger < Gitlab::Database::Migration[2.2]
  milestone '17.2'

  def up
    install_sharding_key_assignment_trigger(
      table: :vulnerability_finding_signatures,
      sharding_key: :project_id,
      parent_table: :vulnerability_occurrences,
      parent_sharding_key: :project_id,
      foreign_key: :finding_id
    )
  end

  def down
    remove_sharding_key_assignment_trigger(
      table: :vulnerability_finding_signatures,
      sharding_key: :project_id,
      parent_table: :vulnerability_occurrences,
      parent_sharding_key: :project_id,
      foreign_key: :finding_id
    )
  end
end
