# frozen_string_literal: true

module Gitlab
  module ErrorTracking
    module Processor
      module ContextPayloadProcessor
        # This processor is added to inject application context into Sentry
        # events generated by Sentry built-in integrations. When the
        # integrations are re-implemented and use Gitlab::ErrorTracking, this
        # processor should be removed.
        def self.call(event)
          Gitlab::ErrorTracking::ContextPayloadGenerator.generate(nil, {}).each do |key, value|
            event.public_send(key).deep_merge!(value) # rubocop:disable GitlabSecurity/PublicSend
          end

          event
        end
      end
    end
  end
end
