/*
 * Decompiled with CFR 0.152.
 */
package jspecview.dialog;

import java.util.Map;
import javajs.util.DF;
import javajs.util.PT;
import jspecview.api.AnnotationData;
import jspecview.api.JSVPanel;
import jspecview.api.PlatformDialog;
import jspecview.common.Annotation;
import jspecview.common.Coordinate;
import jspecview.common.IntegralData;
import jspecview.common.JSViewer;
import jspecview.common.Measurement;
import jspecview.common.MeasurementData;
import jspecview.common.PanelData;
import jspecview.common.Parameters;
import jspecview.common.PeakData;
import jspecview.common.Spectrum;
import jspecview.dialog.DialogManager;

public abstract class JSVDialog
extends Annotation
implements AnnotationData {
    public String optionKey;
    public Map<String, Object> options;
    protected Annotation.AType type;
    protected String title;
    protected JSViewer vwr;
    protected Spectrum spec;
    protected DialogManager manager;
    protected PlatformDialog dialog;
    protected JSVPanel jsvp;
    protected Object txt1;
    protected Object txt2;
    protected Object txt3;
    protected Object combo1;
    protected MeasurementData xyData;
    protected Parameters myParams;
    protected int precision = 1;
    private int[] loc;
    private Object showHideButton;
    private boolean addClearBtn;
    private boolean addCombo1;
    protected boolean addApplyBtn;
    private boolean isNumeric;
    private boolean defaultVisible;
    private String subType;
    private String graphSetKey;
    private Object[][] tableData;
    private boolean addUnits;
    private String[] unitOptions;
    private int[] formatOptions;
    private Integer unitPtr;
    private boolean isON = true;
    protected int iRowColSelected = -1;
    protected int iSelected = -1;
    private boolean skipCreate;
    private int iRowSelected = -1;
    private int iColSelected = -1;

    public abstract int[] getPosXY();

    @Override
    public boolean isDialog() {
        return true;
    }

    protected abstract void addUniqueControls();

    public abstract boolean callback(String var1, String var2);

    public JSVDialog setParams(String title, JSViewer viewer, Spectrum spec) {
        this.title = title = DialogManager.fixTitle(title);
        this.vwr = viewer;
        this.spec = spec;
        this.manager = viewer.getDialogManager();
        this.jsvp = viewer.selectedPanel;
        this.myParams = ((Parameters)viewer.getPlatformInterface("Parameters")).setName("dialogParams");
        this.subType = spec == null ? "!" : spec.getTypeLabel();
        this.optionKey = (Object)((Object)this.type) + "_" + this.subType;
        this.options = this.manager.getDialogOptions();
        if (spec != null) {
            Object[] specOptions = spec.getDefaultAnnotationInfo(this.type);
            this.options.put(this.optionKey, specOptions);
            this.unitOptions = (String[])specOptions[0];
            this.formatOptions = (int[])specOptions[1];
            this.unitPtr = (Integer)this.options.get(this.optionKey + "_unitPtr");
            if (this.unitPtr == null) {
                this.unitPtr = (Integer)specOptions[2];
            }
        }
        switch (this.type) {
            case Integration: {
                this.isNumeric = true;
                this.addClearBtn = true;
                this.defaultVisible = true;
                this.addApplyBtn = true;
                break;
            }
            case Measurements: {
                this.isNumeric = true;
                this.addClearBtn = true;
                this.addCombo1 = true;
                this.defaultVisible = true;
                break;
            }
            case OverlayLegend: {
                break;
            }
            case PeakList: {
                this.isNumeric = true;
                this.addApplyBtn = true;
                this.defaultVisible = true;
                break;
            }
            case Views: {
                this.defaultVisible = true;
                break;
            }
        }
        this.initDialog();
        return this;
    }

    private void initDialog() {
        this.dialog = this.manager.getDialog(this);
        this.restoreDialogPosition(this.jsvp, this.getPosXY());
        this.dialog.setTitle(this.title);
        this.layoutDialog();
    }

    protected void layoutDialog() {
        this.dialog.startLayout();
        this.addUniqueControls();
        if (this.isNumeric) {
            this.getUnitOptions();
            if (this.addCombo1) {
                this.combo1 = this.dialog.addSelectOption("cmbUnits", "Units", this.unitOptions, this.unitPtr, this.addUnits);
            }
            if (this.addApplyBtn) {
                this.dialog.addButton("btnApply", "Apply");
            }
            this.showHideButton = this.dialog.addButton("btnShow", "Show");
            if (this.addClearBtn) {
                this.dialog.addButton("btnClear", "Clear");
            }
        }
        this.dialog.endLayout();
        this.checkEnables();
        this.dialog.setVisible(this.defaultVisible);
    }

    protected boolean callbackAD(String id, String msg) {
        if (id.equals("FOCUS")) {
            this.eventFocus();
        } else if (id.equals("tableSelect")) {
            this.tableSelect(msg);
        } else if (id.equals("btnClear")) {
            this.clear();
        } else if (id.equals("btnApply")) {
            this.eventApply();
        } else if (id.equals("btnShow")) {
            String label = this.dialog.getText(this.showHideButton);
            this.eventShowHide(label.equals("Show"));
        } else if (id.equals("cmbUnits")) {
            this.setPrecision(this.dialog.getSelectedIndex(this.combo1));
        } else if (id.startsWith("txt")) {
            this.eventApply();
        } else if (id.equals("windowClosing")) {
            this.done();
            return true;
        }
        if (this.jsvp != null) {
            this.jsvp.doRepaint(true);
        }
        return true;
    }

    protected void addUniqueControls(DialogManager dialogHelper) {
    }

    @Override
    public Annotation.AType getAType() {
        return this.type;
    }

    @Override
    public String getGraphSetKey() {
        return this.graphSetKey;
    }

    @Override
    public void setGraphSetKey(String key) {
        this.graphSetKey = key;
    }

    @Override
    public Spectrum getSpectrum() {
        return this.spec;
    }

    @Override
    public boolean getState() {
        return this.isON;
    }

    @Override
    public void setState(boolean b) {
        this.isON = b;
    }

    public void checkEnables() {
        boolean isShow = this.checkVisible();
        this.dialog.setText(this.showHideButton, isShow ? "Hide" : "Show");
    }

    private void createTable(Object[][] data, String[] header, int[] widths) {
        this.tableData = data;
        this.dialog.createTable(data, header, widths);
    }

    private void setTableSelectionEnabled(boolean enabled) {
        this.dialog.setCellSelectionEnabled(enabled);
    }

    @Override
    public Parameters getParameters() {
        return this.myParams;
    }

    protected void showMessage(String msg, String title, int msgType) {
        this.manager.showMessageDialog(this.dialog, msg, title, msgType);
    }

    protected void setThreshold(double y) {
        this.dialog.setText(this.txt1, this.getThreasholdText(y));
    }

    public void applyFromFields() {
        this.apply(null);
    }

    public JSVDialog reEnable() {
        this.paramsReEnable();
        return this;
    }

    public void dispose() {
        this.dialog.dispose();
    }

    public void setVisible(boolean visible) {
        this.dialog.setVisible(visible);
    }

    @Override
    public boolean isVisible() {
        return this.dialog.isVisible();
    }

    public void selectTableRow(int i) {
        this.dialog.selectTableRow(i);
    }

    public void repaint() {
        this.dialog.repaint();
    }

    public void setFields() {
        switch (this.type) {
            case Integration: {
                break;
            }
            case Measurements: {
                break;
            }
            case NONE: {
                break;
            }
            case PeakList: {
                this.myParams = this.xyData.getParameters();
                this.setThreshold(this.myParams.peakListThreshold);
                this.dialog.setSelectedIndex(this.combo1, this.myParams.peakListInterpolation.equals("none") ? 1 : 0);
                this.createData();
                break;
            }
            case OverlayLegend: {
                break;
            }
        }
    }

    public void setFocus(boolean tf) {
        this.dialog.setFocus(tf);
    }

    public void update(Coordinate clicked, double xRange, int yOffset) {
        this.selectTableRow(-1);
        switch (this.type) {
            case Integration: {
                this.loadData();
                this.checkEnables();
                break;
            }
            case Measurements: {
                this.loadData();
                this.checkEnables();
                break;
            }
            case NONE: {
                break;
            }
            case PeakList: {
                if (yOffset > 20) {
                    this.applyFromFields();
                }
                if (this.xyData == null || clicked == null || yOffset > 20) {
                    return;
                }
                int ipt = 0;
                double dx0 = 1.0E100;
                double xval = clicked.getXVal();
                PeakData md = (PeakData)this.xyData;
                double min = Math.abs(xRange / 20.0);
                int i = md.size();
                while (--i >= 0) {
                    double dx = Math.abs(xval - ((Measurement)md.get(i)).getXVal());
                    if (!(dx < dx0)) continue;
                    dx0 = dx;
                    ipt = i;
                }
                if (!(dx0 < min)) break;
                this.selectTableRow(md.size() - 2 - ipt);
                this.repaint();
                break;
            }
            case OverlayLegend: {
                break;
            }
        }
    }

    @Override
    public MeasurementData getData() {
        if (this.xyData == null) {
            this.createData();
        }
        return this.xyData;
    }

    public void setData(AnnotationData data) {
        this.myParams = data.getParameters();
        this.xyData = (MeasurementData)data;
    }

    @Override
    public void setSpecShift(double dx) {
        if (this.xyData != null) {
            this.xyData.setSpecShift(dx);
        }
    }

    protected void apply(Object[] objects) {
        try {
            switch (this.type) {
                case Integration: {
                    double offset = Double.parseDouble((String)objects[0]);
                    double scale = Double.parseDouble((String)objects[1]);
                    this.myParams.integralOffset = offset;
                    this.myParams.integralRange = scale;
                    this.myParams.integralDrawAll = false;
                    ((IntegralData)this.getData()).update(this.myParams);
                    break;
                }
                case Measurements: {
                    break;
                }
                case NONE: {
                    return;
                }
                case PeakList: {
                    if (!this.skipCreate) {
                        this.setThreshold(Double.NaN);
                        this.createData();
                    }
                    this.skipCreate = false;
                    break;
                }
                case OverlayLegend: {
                    break;
                }
                case Views: {
                    this.vwr.parameters.viewOffset = Double.parseDouble((String)objects[0]);
                }
            }
            this.loadData();
            this.checkEnables();
            this.jsvp.doRepaint(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void done() {
        if (this.jsvp != null && this.spec != null) {
            this.jsvp.getPanelData().removeDialog(this);
        }
        if (this.xyData != null) {
            this.xyData.setState(this.isON);
        }
        this.saveDialogPosition(this.getPosXY());
        this.dispose();
        this.jsvp.doRepaint(true);
    }

    private void restoreDialogPosition(JSVPanel panel, int[] posXY) {
        if (panel != null) {
            if (posXY[0] == Integer.MIN_VALUE) {
                posXY[0] = 50;
                posXY[1] = 50;
            }
            int[] pt = this.manager.getLocationOnScreen(panel);
            int height = panel.getHeight();
            this.loc = new int[]{Math.max(0, pt[0] + posXY[0]), Math.max(0, pt[1] + posXY[1])};
            this.dialog.setIntLocation(this.loc);
        }
    }

    private void saveDialogPosition(int[] posXY) {
        try {
            int[] pt = this.manager.getLocationOnScreen(this.dialog);
            posXY[0] = posXY[0] + (pt[0] - this.loc[0]);
            posXY[1] = posXY[1] + (pt[1] - this.loc[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getThreasholdText(double y) {
        if (Double.isNaN(y)) {
            PanelData pd = this.jsvp.getPanelData();
            double f = pd.getSpectrum().isInverted() ? 0.1 : 0.9;
            Coordinate c = pd.getClickedCoordinate();
            y = c == null ? (pd.getView().minYOnScale * f + pd.getView().maxYOnScale) * (1.0 - f) : c.getYVal();
        }
        String sy = DF.formatDecimalDbl(y, y < 1000.0 ? 2 : -2);
        return " " + sy;
    }

    private boolean checkVisible() {
        return this.vwr.pd().getShowAnnotation(this.type);
    }

    private void getUnitOptions() {
        String key = this.optionKey + "_format";
        Integer format = (Integer)this.options.get(key);
        if (format == null) {
            format = this.formatOptions[this.unitPtr == null ? 0 : this.unitPtr];
            this.options.put(key, format);
        }
    }

    protected void eventFocus() {
        if (this.spec != null) {
            this.jsvp.getPanelData().jumpToSpectrum(this.spec);
        }
        switch (this.type) {
            case Integration: {
                if (this.iRowSelected < 0) break;
                ++this.iRowSelected;
                this.tableCellSelect(-1, -1);
                break;
            }
            case Measurements: {
                break;
            }
            case NONE: {
                break;
            }
            case PeakList: {
                this.createData();
                this.skipCreate = true;
                break;
            }
            case OverlayLegend: {
                break;
            }
        }
    }

    protected void eventApply() {
        switch (this.type) {
            case Integration: {
                break;
            }
            case Measurements: {
                break;
            }
            case NONE: {
                break;
            }
            case PeakList: {
                this.createData();
                this.skipCreate = true;
                break;
            }
            case OverlayLegend: {
                break;
            }
        }
        this.applyFromFields();
    }

    private void eventShowHide(boolean isShow) {
        this.isON = isShow;
        if (isShow) {
            this.eventApply();
        }
        this.jsvp.doRepaint(true);
        this.checkEnables();
    }

    private void clear() {
        this.setState(true);
        if (this.xyData != null) {
            this.xyData.clear();
            this.applyFromFields();
        }
    }

    private void paramsReEnable() {
        switch (this.type) {
            case Integration: {
                break;
            }
            case Measurements: {
                break;
            }
            case NONE: {
                break;
            }
            case PeakList: {
                this.skipCreate = true;
                break;
            }
            case OverlayLegend: {
                break;
            }
        }
        this.setVisible(true);
        this.isON = true;
        this.applyFromFields();
    }

    private void tableCellSelect(int iRow, int iCol) {
        System.out.println(iRow + " jSVDial " + iCol);
        if (iRow < 0) {
            iRow = this.iRowColSelected / 1000;
            iCol = this.iRowColSelected % 1000;
            this.iRowColSelected = -1;
        }
        Object value = this.tableData[iRow][1];
        int icolrow = iRow * 1000 + iCol;
        if (icolrow == this.iRowColSelected) {
            return;
        }
        this.iRowColSelected = icolrow;
        System.out.println("Setting rc = " + this.iRowColSelected + " " + this.spec);
        this.selectTableRow(this.iRowSelected);
        try {
            switch (this.type) {
                case Integration: {
                    this.callback("SHOWSELECTION", value.toString());
                    this.checkEnables();
                    break;
                }
                case Measurements: {
                    break;
                }
                case NONE: {
                    break;
                }
                case PeakList: {
                    try {
                        switch (iCol) {
                            case 4: 
                            case 5: 
                            case 6: {
                                double x1 = Double.parseDouble((String)value);
                                double x2 = Double.parseDouble((String)this.tableData[iRow + 3 - iCol][1]);
                                this.jsvp.getPanelData().setXPointers(this.spec, x1, this.spec, x2);
                                break;
                            }
                            default: {
                                this.jsvp.getPanelData().findX(this.spec, Double.parseDouble((String)value));
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        this.jsvp.getPanelData().findX(this.spec, 1.0E100);
                    }
                    this.jsvp.doRepaint(false);
                    break;
                }
                case OverlayLegend: {
                    this.jsvp.getPanelData().setSpectrum(iRow, false);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void loadData() {
        switch (this.type) {
            case Integration: {
                if (this.xyData == null) {
                    this.createData();
                }
                this.iSelected = -1;
                Object[][] data = ((IntegralData)this.xyData).getMeasurementListArray(null);
                String[] header = this.xyData.getDataHeader();
                int[] widths = new int[]{40, 65, 65, 50};
                this.createTable(data, header, widths);
                break;
            }
            case Measurements: {
                if (this.xyData == null) {
                    return;
                }
                Object[][] data = this.xyData.getMeasurementListArray(this.dialog.getSelectedItem(this.combo1).toString());
                String[] header = this.xyData.getDataHeader();
                int[] widths = new int[]{40, 65, 65, 50};
                this.createTable(data, header, widths);
                break;
            }
            case NONE: {
                break;
            }
            case PeakList: {
                if (this.xyData == null) {
                    this.createData();
                }
                Object[][] data = ((PeakData)this.xyData).getMeasurementListArray(null);
                String[] header = ((PeakData)this.xyData).getDataHeader();
                int[] widths = new int[]{40, 65, 50, 50, 50, 50, 50};
                this.createTable(data, header, widths);
                this.setTableSelectionEnabled(true);
                break;
            }
            case OverlayLegend: {
                String[] header = new String[]{"No.", "Plot Color", "Title"};
                Object[][] data = this.vwr.selectedPanel.getPanelData().getOverlayLegendData();
                int[] widths = new int[]{30, 60, 250};
                this.createTable(data, header, widths);
                this.setTableSelectionEnabled(true);
                break;
            }
        }
    }

    private void createData() {
        switch (this.type) {
            case Integration: {
                this.xyData = new IntegralData(this.spec, this.myParams);
                this.iSelected = -1;
                break;
            }
            case Measurements: {
                break;
            }
            case NONE: {
                break;
            }
            case PeakList: {
                try {
                    double thresh;
                    this.myParams.peakListThreshold = thresh = Double.parseDouble(this.dialog.getText(this.txt1));
                    this.myParams.peakListInterpolation = this.dialog.getSelectedItem(this.combo1).toString();
                    this.myParams.precision = this.precision;
                    PeakData md = new PeakData(Annotation.AType.PeakList, this.spec);
                    md.setPeakList(this.myParams, this.precision, this.jsvp.getPanelData().getView());
                    this.xyData = md;
                    this.loadData();
                }
                catch (Exception exception) {}
                break;
            }
            case OverlayLegend: {
                break;
            }
        }
    }

    private void setPrecision(int i) {
        this.precision = this.formatOptions[i];
    }

    private void tableSelect(String url) {
        boolean isAdjusting = "true".equals(this.getField(url, "adjusting"));
        if (isAdjusting) {
            this.iRowSelected = -1;
            this.iColSelected = -1;
            System.out.println("adjusting" + url);
            return;
        }
        int index = PT.parseInt(this.getField(url, "index"));
        switch ("ROW COL ROWCOL".indexOf(this.getField(url, "selector"))) {
            case 8: {
                this.iColSelected = PT.parseInt(this.getField(url, "index2"));
            }
            case 0: {
                this.iRowSelected = index;
                System.out.println("r set to " + index);
                break;
            }
            case 4: {
                this.iColSelected = index;
                System.out.println("c set to " + index);
            }
        }
        if (this.iColSelected >= 0 && this.iRowSelected >= 0) {
            this.tableCellSelect(this.iRowSelected, this.iColSelected);
        }
    }

    private String getField(String url, String name) {
        String key;
        int pt = (url = url + "&").indexOf(key = "&" + name + "=");
        return pt < 0 ? null : url.substring(pt + key.length(), url.indexOf("&", pt + 1));
    }
}

