/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.juife.LinkButton;
import net.sf.juife.NavigationPage;
import org.jsampler.view.InstrumentTable;
import org.jsampler.view.OrchestraTable;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.LeftPane;
import org.jsampler.view.classic.Res;
import org.jsampler.view.classic.ToolbarButton;
import org.jsampler.view.std.JSManageOrchestrasPane;
import org.jsampler.view.std.JSOrchestraPane;

public class ManageOrchestrasPage
extends NavigationPage {
    private final JComponent manageOrchestrasPane;
    OrchestraTable orchestraTable;
    private LinkButton lnkOrchestras = new LinkButton(ClassicI18n.i18n.getButtonLabel("ManageOrchestrasPage.lnkOrchestras"));
    private OrchestraPane orchestraPane = new OrchestraPane();

    public ManageOrchestrasPage() {
        this.setTitle(ClassicI18n.i18n.getLabel("ManageOrchestrasPage.title"));
        this.setLayout(new BoxLayout(this, 1));
        this.manageOrchestrasPane = this.createManageOrchestrasPane();
        this.add(this.manageOrchestrasPane);
        this.installListeneres();
    }

    private JComponent createManageOrchestrasPane() {
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setTopComponent(new ManageOrchestrasPane());
        jSplitPane.setBottomComponent(this.orchestraPane);
        jSplitPane.setDividerSize(3);
        jSplitPane.setDividerLocation(180);
        return jSplitPane;
    }

    private void installListeneres() {
        this.lnkOrchestras.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LeftPane.getLeftPane().showOrchestrasPage();
            }
        });
        OrchestraSelectionHandler orchestraSelectionHandler = new OrchestraSelectionHandler();
        this.orchestraTable.getSelectionModel().addListSelectionListener(orchestraSelectionHandler);
    }

    private class OrchestraSelectionHandler
    implements ListSelectionListener {
        private OrchestraSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ManageOrchestrasPage.this.orchestraPane.setOrchestra(ManageOrchestrasPage.this.orchestraTable.getSelectedOrchestra());
        }
    }

    public class DnDScrollPane
    extends JScrollPane {
        private InstrumentTable instrumentTable;

        private DnDScrollPane(InstrumentTable instrumentTable) {
            this.instrumentTable = instrumentTable;
            this.setViewport(new DnDViewPort());
            this.setViewportView(this.instrumentTable);
            Dimension dimension = new Dimension(this.getMinimumSize().width, this.getPreferredSize().height);
            this.setPreferredSize(dimension);
        }

        public class DnDViewPort
        extends JViewport {
            private DnDViewPort() {
                this.setTransferHandler(new TransferHandler("instrument"){

                    @Override
                    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                        if (DnDScrollPane.this.instrumentTable.isPerformingDnD()) {
                            return false;
                        }
                        if (ManageOrchestrasPage.this.orchestraPane.getSelectedInstrument() == null) {
                            return false;
                        }
                        return super.canImport(jComponent, dataFlavorArray);
                    }
                });
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        DnDScrollPane.this.instrumentTable.clearSelection();
                    }
                });
            }

            public String getInstrument() {
                return null;
            }

            public void setInstrument(String string) {
                DnDScrollPane.this.instrumentTable.setSelectedInstrument(null);
                DnDScrollPane.this.instrumentTable.setInstrument(string);
            }
        }
    }

    class OrchestraPane
    extends JSOrchestraPane {
        OrchestraPane() {
            this.actionAddInstrument.putValue("SmallIcon", Res.iconNew16);
            this.actionEditInstrument.putValue("SmallIcon", Res.iconEdit16);
            this.actionDeleteInstrument.putValue("SmallIcon", Res.iconDelete16);
            this.actionInstrumentUp.putValue("SmallIcon", Res.iconUp16);
            this.actionInstrumentDown.putValue("SmallIcon", Res.iconDown16);
            this.removeAll();
            JToolBar jToolBar = new JToolBar();
            jToolBar.add(new ToolbarButton(this.actionAddInstrument));
            jToolBar.add(new ToolbarButton(this.actionEditInstrument));
            jToolBar.add(new ToolbarButton(this.actionDeleteInstrument));
            jToolBar.addSeparator();
            jToolBar.add(new ToolbarButton(this.actionInstrumentUp));
            jToolBar.add(new ToolbarButton(this.actionInstrumentDown));
            jToolBar.setFloatable(false);
            this.add((Component)jToolBar, "North");
            JScrollPane jScrollPane = new JScrollPane(this.instrumentTable);
            Dimension dimension = new Dimension(jScrollPane.getMinimumSize().width, jScrollPane.getPreferredSize().height);
            jScrollPane.setPreferredSize(dimension);
            this.add(jScrollPane);
        }
    }

    class ManageOrchestrasPane
    extends JSManageOrchestrasPane {
        ManageOrchestrasPane() {
            this.actionAddOrchestra.putValue("SmallIcon", Res.iconNew16);
            this.actionEditOrchestra.putValue("SmallIcon", Res.iconEdit16);
            this.actionDeleteOrchestra.putValue("SmallIcon", Res.iconDelete16);
            this.actionOrchestraUp.putValue("SmallIcon", Res.iconUp16);
            this.actionOrchestraDown.putValue("SmallIcon", Res.iconDown16);
            this.removeAll();
            JToolBar jToolBar = new JToolBar();
            jToolBar.add(new ToolbarButton(this.actionAddOrchestra));
            jToolBar.add(new ToolbarButton(this.actionEditOrchestra));
            jToolBar.add(new ToolbarButton(this.actionDeleteOrchestra));
            jToolBar.addSeparator();
            jToolBar.add(new ToolbarButton(this.actionOrchestraUp));
            jToolBar.add(new ToolbarButton(this.actionOrchestraDown));
            jToolBar.setFloatable(false);
            this.add((Component)jToolBar, "North");
            JScrollPane jScrollPane = new JScrollPane(this.orchestraTable);
            Dimension dimension = new Dimension(jScrollPane.getMinimumSize().width, jScrollPane.getPreferredSize().height);
            jScrollPane.setPreferredSize(dimension);
            this.add(jScrollPane);
            ManageOrchestrasPage.this.orchestraTable = this.orchestraTable;
        }
    }
}

