/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import liquibase.exception.CustomChangeException;
import liquibase.statement.core.UpdateStatement;
import liquibase.structure.core.Table;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;
import org.keycloak.models.utils.KeycloakModelUtils;

public class JpaUpdate1_4_0_Final
extends CustomKeycloakTask {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        String userAttributeTableName = this.database.correctObjectName("USER_ATTRIBUTE", Table.class);
        try {
            try (PreparedStatement statement = this.jdbcConnection.prepareStatement("select NAME, USER_ID from " + this.getTableName("USER_ATTRIBUTE"));
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String name = resultSet.getString(1);
                    String userId = resultSet.getString(2);
                    UpdateStatement updateStatement = new UpdateStatement(null, null, userAttributeTableName).addNewColumnValue("ID", (Object)KeycloakModelUtils.generateId()).setWhereClause("NAME='" + name + "' AND USER_ID='" + userId + "'");
                    this.statements.add(updateStatement);
                }
            }
            this.confirmationMessage.append("Updated " + this.statements.size() + " attributes in USER_ATTRIBUTE table");
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Exception when updating data from previous version", (Throwable)e);
        }
    }

    @Override
    protected String getTaskId() {
        return "Update 1.4.0.Final";
    }
}

