/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class MethodMatchingProxyFactory {
    public static <T> T createProxy(Class<T> interfaceClass, Class<?> backingClass, Object ... constructorArgs) {
        try {
            Object backingObject;
            if (constructorArgs.length == 0 && backingClass.getConstructors().length == 0) {
                backingObject = backingClass.newInstance();
            } else {
                Class[] backingArgsClasses = new Class[constructorArgs.length];
                for (int i = 0; i < constructorArgs.length; ++i) {
                    backingArgsClasses[i] = constructorArgs[i].getClass();
                }
                Constructor<?> ctor = backingClass.getConstructor(backingArgsClasses);
                backingObject = ctor.newInstance(constructorArgs);
            }
            Object proxy = Proxy.newProxyInstance(MethodMatchingProxyFactory.class.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new MethodMatchingInvocationHandler(backingObject));
            return interfaceClass.cast(proxy);
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                RuntimeException rex = (RuntimeException)ex;
                throw rex;
            }
            throw new RuntimeException(ex);
        }
    }

    private static class MethodMatchingInvocationHandler
    implements InvocationHandler {
        private final Object backingObject;

        public MethodMatchingInvocationHandler(Object backingObject) {
            this.backingObject = backingObject;
        }

        @Override
        public Object invoke(Object proxy, Method proxyMethod, Object[] args) throws Throwable {
            try {
                Method backingMethod = this.backingObject.getClass().getMethod(proxyMethod.getName(), proxyMethod.getParameterTypes());
                return backingMethod.invoke(this.backingObject, args);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException("Method '" + proxyMethod.getName() + "' not implemented in " + this.backingObject.getClass().getName() + ".");
            }
        }
    }
}

