/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script.expression;

import java.io.IOException;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.SimpleBindings;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.opensearch.script.GeneralScriptException;
import org.opensearch.script.NumberSortScript;

class ExpressionNumberSortScript
implements NumberSortScript.LeafFactory {
    final Expression exprScript;
    final SimpleBindings bindings;
    final DoubleValuesSource source;
    final boolean needsScores;

    ExpressionNumberSortScript(Expression e, SimpleBindings b, boolean needsScores) {
        this.exprScript = e;
        this.bindings = b;
        this.source = this.exprScript.getDoubleValuesSource((Bindings)this.bindings);
        this.needsScores = needsScores;
    }

    public NumberSortScript newInstance(final LeafReaderContext leaf) throws IOException {
        return new NumberSortScript(){
            DoubleValues values;
            {
                this.values = ExpressionNumberSortScript.this.source.getValues(leaf, new DoubleValues(this){

                    public double doubleValue() {
                        return 0.0;
                    }

                    public boolean advanceExact(int doc) {
                        return true;
                    }
                });
            }

            public double execute() {
                try {
                    return this.values.doubleValue();
                }
                catch (Exception exception) {
                    throw new GeneralScriptException("Error evaluating " + String.valueOf(ExpressionNumberSortScript.this.exprScript), (Throwable)exception);
                }
            }

            public void setDocument(int d) {
                try {
                    this.values.advanceExact(d);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Can't advance to doc using " + String.valueOf(ExpressionNumberSortScript.this.exprScript), e);
                }
            }
        };
    }

    public boolean needs_score() {
        return this.needsScores;
    }
}

