/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.model.destination;

import java.io.IOException;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/opensearch/alerting/model/destination/SNS;", "Lorg/opensearch/core/xcontent/ToXContent;", "topicARN", "", "roleARN", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getTopicARN", "()Ljava/lang/String;", "getRoleARN", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nSNS.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SNS.kt\norg/opensearch/alerting/model/destination/SNS\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
public final class SNS
implements ToXContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String topicARN;
    @NotNull
    private final String roleARN;
    private static final Pattern SNS_ARN_REGEX = Pattern.compile("^arn:aws(-[^:]+)?:sns:([a-zA-Z0-9-]+):([0-9]{12}):([a-zA-Z0-9-_]+)$");
    private static final Pattern IAM_ARN_REGEX = Pattern.compile("^arn:aws(-[^:]+)?:iam::([0-9]{12}):([a-zA-Z0-9-/_]+)$");
    @NotNull
    public static final String TOPIC_ARN_FIELD = "topic_arn";
    @NotNull
    public static final String ROLE_ARN_FIELD = "role_arn";
    @NotNull
    public static final String SNS_TYPE = "sns";

    public SNS(@NotNull String topicARN, @NotNull String roleARN) {
        Intrinsics.checkNotNullParameter((Object)topicARN, (String)"topicARN");
        Intrinsics.checkNotNullParameter((Object)roleARN, (String)"roleARN");
        this.topicARN = topicARN;
        this.roleARN = roleARN;
        if (!SNS_ARN_REGEX.matcher(this.topicARN).find()) {
            boolean $i$a$-require-SNS$32 = false;
            String $i$a$-require-SNS$32 = "Invalid AWS SNS topic ARN: " + this.topicARN;
            throw new IllegalArgumentException($i$a$-require-SNS$32.toString());
        }
        if (!IAM_ARN_REGEX.matcher(this.roleARN).find()) {
            boolean bl = false;
            String string = "Invalid AWS role ARN: " + this.roleARN + " ";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getTopicARN() {
        return this.topicARN;
    }

    @NotNull
    public final String getRoleARN() {
        return this.roleARN;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        XContentBuilder xContentBuilder = builder.startObject(SNS_TYPE).field(TOPIC_ARN_FIELD, this.topicARN).field(ROLE_ARN_FIELD, this.roleARN).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
        return xContentBuilder;
    }

    @NotNull
    public final String component1() {
        return this.topicARN;
    }

    @NotNull
    public final String component2() {
        return this.roleARN;
    }

    @NotNull
    public final SNS copy(@NotNull String topicARN, @NotNull String roleARN) {
        Intrinsics.checkNotNullParameter((Object)topicARN, (String)"topicARN");
        Intrinsics.checkNotNullParameter((Object)roleARN, (String)"roleARN");
        return new SNS(topicARN, roleARN);
    }

    public static /* synthetic */ SNS copy$default(SNS sNS, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = sNS.topicARN;
        }
        if ((n & 2) != 0) {
            string2 = sNS.roleARN;
        }
        return sNS.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "SNS(topicARN=" + this.topicARN + ", roleARN=" + this.roleARN + ")";
    }

    public int hashCode() {
        int result = this.topicARN.hashCode();
        result = result * 31 + this.roleARN.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SNS)) {
            return false;
        }
        SNS sNS = (SNS)other;
        if (!Intrinsics.areEqual((Object)this.topicARN, (Object)sNS.topicARN)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.roleARN, (Object)sNS.roleARN);
    }

    @JvmStatic
    @NotNull
    public static final SNS parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/opensearch/alerting/model/destination/SNS$Companion;", "", "<init>", "()V", "SNS_ARN_REGEX", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "IAM_ARN_REGEX", "TOPIC_ARN_FIELD", "", "ROLE_ARN_FIELD", "SNS_TYPE", "parse", "Lorg/opensearch/alerting/model/destination/SNS;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-alerting"})
    @SourceDebugExtension(value={"SMAP\nSNS.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SNS.kt\norg/opensearch/alerting/model/destination/SNS$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SNS parse(@NotNull XContentParser xcp) throws IOException {
            String string;
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            String topicARN = null;
            String roleARN = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string2 = fieldName;
                if (Intrinsics.areEqual((Object)string2, (Object)SNS.TOPIC_ARN_FIELD)) {
                    Intrinsics.checkNotNullExpressionValue((Object)xcp.textOrNull(), (String)"textOrNull(...)");
                    continue;
                }
                if (Intrinsics.areEqual((Object)string2, (Object)SNS.ROLE_ARN_FIELD)) {
                    Intrinsics.checkNotNullExpressionValue((Object)xcp.textOrNull(), (String)"textOrNull(...)");
                    continue;
                }
                throw new IllegalStateException("Unexpected field: " + fieldName + ", while parsing SNS destination");
            }
            String string3 = topicARN;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"topicARN");
                string3 = null;
            }
            if ((string = roleARN) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"roleARN");
                string = null;
            }
            String string4 = string;
            String string5 = string3;
            return new SNS(string5, string4);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

