/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform.internal;

import java.util.List;
import java.util.regex.Pattern;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryRequest;
import software.amazon.awssdk.services.ec2.model.RequestSpotFleetRequest;

@SdkInternalApi
public final class TimestampFormatInterceptor
implements ExecutionInterceptor {
    private static final Pattern PATTERN = Pattern.compile("\\.\\d\\d\\dZ");
    private static final String START_TIME = "StartTime";
    private static final String VALID_FROM = "SpotFleetRequestConfig.ValidFrom";
    private static final String VALID_UNTIL = "SpotFleetRequestConfig.ValidUntil";

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpRequest request = context.httpRequest();
        SdkRequest original = context.request();
        if (original instanceof DescribeSpotFleetRequestHistoryRequest) {
            List startTime = request.firstMatchingRawQueryParameters(START_TIME);
            if (startTime != null && !startTime.isEmpty()) {
                return (SdkHttpRequest)((SdkHttpRequest.Builder)request.toBuilder()).putRawQueryParameter(START_TIME, this.sanitize((String)startTime.get(0))).build();
            }
        } else if (original instanceof RequestSpotFleetRequest) {
            List validFrom = request.firstMatchingRawQueryParameters(VALID_FROM);
            List validUntil = request.firstMatchingRawQueryParameters(VALID_UNTIL);
            return (SdkHttpRequest)((SdkHttpRequest.Builder)((SdkHttpRequest.Builder)request.toBuilder()).applyMutation(builder -> {
                if (validFrom != null && !validFrom.isEmpty()) {
                    builder.putRawQueryParameter(VALID_FROM, this.sanitize((String)validFrom.get(0)));
                }
                if (validUntil != null && !validUntil.isEmpty()) {
                    builder.putRawQueryParameter(VALID_UNTIL, this.sanitize((String)validUntil.get(0)));
                }
            })).build();
        }
        return request;
    }

    private String sanitize(String input) {
        return PATTERN.matcher(input).replaceFirst("Z");
    }
}

